;##################################################################
;
;   Phoenix-Z80 (Data storage, Save/Restore)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated February 13, 2001.
;
;##################################################################     

;############## Save the game

game_save:
        ld      de,saved_flag
        ld      a,1
        ld      (de),a
        inc     de
        ld      hl,perm_var_start
        ld      bc,perm_var_size
        ldir
        jp      game_exit

;############## Test for saved game, restoring if it exists

restore_game:
        ld      hl,saved_flag
        ld      a,(hl)
        or      a
        ret     z

#ifdef  __TI82__
        ld      (hl),0
        inc     hl
        ld      de,perm_var_start
        ld      bc,perm_var_size
        ldir
        jp      pre_main_loop
#endif

#ifdef __TI83__
        inc     hl
        ld      de,perm_var_start
        ld      bc,perm_var_size
        ldir
        ld      a,(ext_level)
        or      a
        call    nz,ext_level_saved
        xor     a
        ld      (saved_flag),a
        jp      pre_main_loop
#endif

#ifdef __85OR86__
        inc     hl
        ld      de,perm_var_start
        ld      bc,perm_var_size
        ldir
        ld      a,(ext_level)
        or      a
        call    nz,ext_level_saved
        xor     a
        ld      (LEVEL_LOCATION),a
        ld      (saved_flag),a
        jp      pre_main_loop
#endif   

;############## Actual storage space

#ifdef __TI86__

level_name      =$d750
saved_flag      =$d758
saved_data      =$d759
pb_array        =$d7a1
e_array         =$d831
eb_array        =$d909
high_scores     =$d963
high_scores_end =$d9bc

#else

#include "source/storage.asm"

#endif
