;##################################################################
;
;   Phoenix-Z80 (Memory area swapping routine)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated February 11, 2001.
;
;##################################################################     

;############## MEMORY EXCHANGE ROUTINE
; Moves BC bytes of memory from (HL) to (DE)
; Backs up original contents of destination into source
; If overlapping regions, part of destination to be backed up is placed in
; non-overlapped part of source

        call    CP_HL_DE
        jr      c,move_down

exir:   ld      a,(de)
        ldi
        dec     hl
        ld      (hl),a
        inc     hl
        ld      a,b
        or      c
        jr      nz,exir
        ret

move_down:
        dec     bc
        add     hl,bc
        push    hl
        ex      de,hl
        add     hl,bc
        pop     de
        inc     bc

exdr:   ld      a,(de)
        ldd
        inc     hl
        ld      (hl),a
        dec     hl
        ld      a,b
        or      c
        jr      nz,exdr
        ret
