;##################################################################
;
;   Phoenix-Z80 (External level handling for Ion)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated February 13, 2001.
;
;##################################################################     

;############## Level selector

lsup:   xor     a
        cp      e
        jr      z,select_loop
        ld      (CURSOR_ROW),de
        dec     e
lsmove: ld      a,32
        push    de
        ROM_CALL(TX_CHARPUT)
        pop     de
        ld      (CURSOR_ROW),de
        ld      a,'*'
        push    de
        ROM_CALL(TX_CHARPUT)
        pop     de
        jr      select_loop

lsdown: ld      a,(misc_flags)
        cp      e
        jr      z,select_loop
        ld      (CURSOR_ROW),de
        inc     e
        jr      lsmove

level_selector:
        ROM_CALL(CLEARLCD)
        ld      de,0
        ld      (CURSOR_ROW),de
        ld      hl,default_msg
        ROM_CALL(D_ZT_STR)

        call    show_list

        ld      de,0
select_loop:
        call    GET_KEY
        cp      G_UP
        jr      z,lsup
        cp      G_DOWN
        jr      z,lsdown
        cp      G_CLEAR
        jp      z,game_exit
        cp      G_DEL
        jp      z,game_exit
        cp      G_MODE
        jp      z,game_exit
        cp      G_ENTER
        jr      nz,select_loop

        ld      a,e
        ld      (ext_level),a
        or      a
        ret     z

find_ext_lev:
        ld      b,a
        ld      hl,(progptr)
loop_hunt:
        ld      ix,identification
        push    bc
        call    ionDetect
        pop     bc
        ex      de,hl
        djnz    loop_hunt

        ex      de,hl
        inc     hl

        ld      de,level_name
        ld      bc,8
        ldir

load_external_level:
        xor     a
        ld      (check_restore),a
        ld      (saved_flag),a

        ld      de,$F00C
        ld      (level_addr),de
        ld      (restore_mem+1),hl

memory_exchange:
        ld      bc,$c00
#include source/exchange.asm

;############## Restore game saved in external level

ext_level_saved:
        ld      hl,(progptr)
el_search:
        ld      ix,identification
        call    ionDetect
        jr      nz,load_error
        push    de
        ld      b,8
        ld      de,level_name
evloop: inc     hl
        ld      a,(de)
        cp      (hl)
        jr      nz,els_nomatch
        inc     de
        djnz    evloop

        inc     hl
        call    load_external_level
        ld      a,1
        ld      (ext_level),a
        jp      pre_main_loop

els_nomatch:
        pop     hl
        jr      el_search

;############## Get list of levels

show_list:
        xor     a
        ld      (misc_flags),a

        ld      hl,(progptr)
loop_list:
        ld      ix,identification
        call    ionDetect
        ret     nz

        push    de

        ld      de,misc_flags
        ld      a,(de)
        inc     a
        ld      (de),a
        ld      (CURSOR_ROW),a
        ld      a,2
        ld      (CURSOR_COL),a

        ld      b,8
ldisp:  inc     hl
        push    bc
        push    hl
        ld      a,(hl)
        ROM_CALL(TX_CHARPUT)
        pop     hl
        pop     bc
        djnz    ldisp

        pop     hl

        ld      a,(misc_flags)
        cp      7
        ret     z
        jr      loop_list

identification:
        .db     "PhX",0

;############## Display loading error message

load_error:
        ld      hl,0
        ld      (CURSOR_ROW),hl
        ld      hl,load_error_msg
        ROM_CALL(D_ZT_STR)
error_loop:
        call    GET_KEY
        cp      G_CLEAR
        jp      z,game_exit
        cp      G_1
        jr      nz,error_loop

        xor     a
        ld      (saved_flag),a
        ld      (ext_level),a
        ld      sp,(initsp+1)
        jp      no_saved_game

load_error_msg:
        .db     "ERROR:  Unable  "
        .db     "to locate level "
        .db     "you saved the   "
        .db     "game in.  Press "
        .db     "1 to start a new"
        .db     "game, or CLEAR  "
        .db     "to exit.",0

;############## Messages

default_msg:
        .db     "* Built-In World",0
