;##################################################################
;
;   Phoenix-Z80 (Level initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated February 13, 2001.
;
;##################################################################     

;############## Load the next level

load_row:
        ld      b,(hl)
        inc     hl
        ld      a,(hl)
        ld      (set_up_enemies_loop+1),a
        inc     hl
        ld      a,(hl)
        inc     hl
        ld      c,(hl)
        inc     hl
        push    hl
        push    af
        call    LD_HL_MHL
        pop     af
        ex      de,hl
        call    set_up_enemies
        ex      de,hl
        pop     hl
        inc     hl
        inc     hl
        jr      level_loader

load_poke:
        ld      b,(hl)
        inc     hl
        push    hl
        call    LD_HL_MHL
        ld      (hl),b
        pop     hl
        inc     hl
        inc     hl
        jr      level_loader

load_bounce:
        ld      b,(hl)
        inc     hl
        push    hl
        ex      de,hl
        call    bounce_install
        ex      de,hl
        pop     hl
        jr      level_loader

restart:
        ld      hl,level
        ld      (hl),0

load_level:
        ld      hl,level
        ld      a,(hl)
        inc     (hl)
        ld      hl,(level_addr)
        add     a,a
        call    ADD_HL_A
        call    LD_HL_MHL

        ld      de,e_array
        ld      a,(hl)
        ld      (enemies_left),a
        inc     hl
level_loader:
        ld      a,(hl)
        inc     hl
        ld      (smc_loader_jump+1),a
smc_loader_jump:
        jr      loader_table

loader_table:
        ret                             ;0
        jp      load_row               ;1
        jp      load_single            ;4
        jp      load_bounce            ;7
        jp      load_delayed           ;10
        jp      load_poke              ;13
        jp      game_finished          ;16
        jp      shop                   ;19
                                        ;22

word_poke:
        ld      c,(hl)
        inc     hl
        ld      b,(hl)
        inc     hl
        push    hl
        call    LD_HL_MHL
        ld      (hl),c
        inc     hl
        ld      (hl),b
        pop     hl
        inc     hl
        inc     hl
        jr      level_loader

load_single:
        push    hl
        call    LD_HL_MHL
        ld      bc,e_size
        ldir
        pop     hl
        inc     hl
        inc     hl
        jr      level_loader
   
load_delayed:
        ld      b,(hl)
        inc     hl
        ld      a,(hl)
        ld      (loop_install_delayed+1),a
        inc     hl
        push    hl
        ex      de,hl
        call    install_delayed
        ex      de,hl
        pop     hl
        jr      level_loader

;############## Initialize levels with bouncing enemies

bounce_install:
        ld      a,14
        ld      de,e_size-7
loop_put_bouncing:
        ld      (hl),15                 ; e_type
        inc     hl
        ld      (hl),3                  ; XV
        inc     hl
        ld      (hl),3                  ; YV
        inc     hl
        ld      (hl),a
        inc     hl
        add     a,10
        ld      (hl),8
        inc     hl
        ld      (hl),20
        inc     hl
        ld      (hl),9
        inc     hl
        ld      (hl),36
        add     hl,de
        djnz    loop_put_bouncing
        ret

;############## Install enemy data for one row of enemies
;
; HL -> position in e_array to start installing
; B = number of enemies in row
; C = Y coordinate of row (from top of screen)
; DE = enemy image
; A = starting X coordinate
;
; Returns with HL -> first unused enemy, B = 0

set_up_enemies:
        push    af
        ld      a,(spacing)
        ld      (smc_spacing+1),a
        pop     af

set_up_enemies_loop:
        ld      (hl),3          ; Enemy type
        inc     hl
        ld      (hl),0          ; Phase
        inc     hl
        ld      (hl),-60        ; Timer
        inc     hl                               
        ld      (hl),a          ; X-coordinate
smc_spacing:
        add     a,15
        inc     hl

        push    af

        ld      a,(de)
        ld      (hl),a          ; Width
        inc     hl
        ld      (hl),c          ; Y-coordinate
        inc     hl
        inc     de
        ld      a,(de)
        ld      (hl),a          ; Height
        dec     de
        inc     hl

        dec     de
        ld      a,(de)
        ld      (hl),a          ; Power
        inc     de

        pop     af

        inc     hl
        ld      (hl),e          ; Image, low byte
        inc     hl
        ld      (hl),d          ; Image, high byte
        inc     hl
        inc     hl
        inc     hl
        djnz    set_up_enemies_loop
        ret

;############## Initialize levels with circle/bar enemies

install_delayed:
        ld      a,b
        ld      c,9
        ld      de,e_size-6
loop_install_delayed:
        ld      (hl),9                  ; e_type
        inc     hl
        ld      (hl),a                  ; e_phase
        inc     hl
        inc     hl
        ld      (hl),c                  ; e_x
        inc     hl
        ld      (hl),c
        inc     hl
        ld      (hl),c                  ; e_y
        inc     hl
        ld      (hl),c
        add     a,15
        add     hl,de
        djnz    loop_install_delayed
        ret
        ret
