;##################################################################
;
;   Phoenix-Z80 (low-level support routines)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last modified January 11, 2001.
;
;##################################################################   

;############## Synchronization

synchronize:
        ld      hl,timer
        ld      a,(speed)
        cp      (hl)
        jr      c,too_slow

loop_wait:
        cp      (hl)            ; Test value of 4 - (timer)
        jr      nc,loop_wait    ; NC : timer <= 4
        ld      (hl),0

;        ld      a,(CONTRAST)
;        add     a,$1e
;        or      $c0
;        out     ($10),a
        ret

too_slow:
        ld      (hl),0
;        ld      a,(CONTRAST)
;        add     a,$16
;        or      $c0
;        out     ($10),a

        ret

timer_interrupt:
        push    af
        push    hl
        ld      hl,timer
        inc     (hl)
        pop     hl
        pop     af
        jp      $38
timer_interrupt_end:

;############## Low-level support routines

ADD_HL_A:
        add     a,l
        ld      l,a
        ret     nc
        inc     h
        ret

FAST_RANDOM:
        push    hl
        ld      hl,0
        ld      a,(hl)
        inc     hl
        xor     (hl)
        inc     hl
        xor     (hl)
        inc     hl
        res     6,h
        ld      (FAST_RANDOM+2),hl
        pop     hl
        ret
        ret
