;##################################################################
;
;   P H O E N I X         F O R        T I - 8 6
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated December 10, 2000.
;
;##################################################################

TEXT_MEM        =$C0F9
_asm_exec_ram   =$d748

#include "source/phoenixz.h"

;############## TI-86 program header (for YAS, etc.)

        .org    _asm_exec_ram
        nop
        jp      startup
        .dw     0
        .dw     title

storage_start:                          ;storage starting at _asm_exec_ram+8
#include "source/storage.asm"
storage_end:

title:  .db     "Phoenix ", VERSION, " by Patrick D",0

;############## Initialization

startup:
        call    $49DC                   ; _flushAllMenus
        call    $4AB1                   ; _runindicoff

        ld      hl,compressed_data
        ld      de,$8100
        call    Decompress

        call    $8100

game_finished:
        ld      hl,variable_name
        call    $42d7                   ;_MOV10TOOP1
        call    $46CB                   ; _FINDSYM; BDE -> start of program
        ld      hl,storage_start+4-_asm_exec_ram
        ld      a,b
        add     hl,de
        adc     a,0                     ; AHL -> perm storage in variable
        call    $5285                   ; _SET_ABS_DEST_ADDR
        ld      a,0
        ld      hl,storage_start
        call    $4647                   ; _SET_ABS_SRC_ADDR
        ld      a,0
        ld      hl,storage_end-storage_start
        call    $464f                   ; _SET_MM_NUM_BYTES
        call    $52ed                   ; _mm_ldir

        ld      hl,TEXT_MEM
        ld      (hl),' '
        ld      bc,167
        ld      de,TEXT_MEM+1
        ldir
        call    $4A7E                   ;_clrLCD
        ld      hl,0
        ld      ($C00F),hl              ;CURSOR_ROW
        ld      (iy+13),6
        set     0,(iy+3)

variable_name:
        .db     0,7,"phoenix"

#include "lite86.asm"

compressed_data:
        .end
        .end
