;##################################################################
;
;   P H O E N I X         F O R        T I - 8 5   /  T I - 8 6
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated February 13, 2001.
;
;##################################################################     

sidesdata       =$FA70
leftsidecoord   =$FB70
leftsidevel     =$FB71
rightsidecoord  =$FB72
rightsidevel    =$FB73

#define __85OR86__

;############## Initialize synchronization, screen sides, external levels

main:   ld      (iy+13),0               ; No-scroll text mode

        xor     a
        ld      (in_game),a

        ld      (initsp+1),sp           ; Save SP for exit

        call    set_up_sides            ; Set up scrolling side data

        ld      hl,timer_interrupt      ; Initialize interrupt
        call    INT_INSTALL

        ld      hl,level_table          ; Indicate no external level loaded
        ld      (level_addr),hl
        xor     a
        ld      (ext_level),a

        call    restore_game            ; Check for saved game

no_saved_game:

        ld      hl,default_images       ; Load default set of images
        ld      de,is_boss1l
        ld      bc,default_images_end-default_images
        ldir

        ld      hl,$fc00                ; Set graphics frame
        ld      (smc_gfxmem_start+1),hl

        ld      a,4                     ; Set speed to normal (for title)
        ld      (speed),a

        call    check_level_loaded      ; Check for external level

;############## Title screen

redraw_title:
        call    CLEARLCD
        ld      hl,title_main

show_title:
        push    hl
        call    clear_buffer
        ld      hl,$fe00
        ld      bc,$1ff
        call    OTH_CLEAR
        pop     hl

        call    display_hl_msgs
        
title_loop:
        call    scroll_sides
        call    display_sides

        call    synchronize
        call    GET_KEY
        cp      K_F2
        jr      z,show_contact
        cp      K_F3
        jr      z,show_instructions
        cp      K_F1
        jp      z,start_new_game
        cp      K_ALPHA
        jr      z,show_highs
        cp      K_EXIT
        jr      nz,title_loop

game_exit:
        call    INT_REMOVE
        ld      a,$7c
        out     (0),a
initsp: ld      sp,0
        ret

show_highs:
        call    no_high_score
        jr      redraw_title

show_contact:
        ld      hl,title_contact
        jr      show_title

show_instructions:
        ld      hl,title_instructions
        jr      show_title

;############## Title screen messages

title_main:
        .db     "  Phoenix  ",VERSION,0
        .db     0
        .db     "  Programmed by",0
        .db     "Patrick  Davidson",0
        .db     0
        .db     " F1 - Start Game",0
        .db     "F2 - Contact Info",0
        .db     "F3 - Instructions",0
        .db     -1

title_instructions:
        .db     "Arrows: Move Ship",0
        .db     "Fn: Select Weapon",0
        .db     "2nd: Shoot Weapon",0
        .db     "MORE: Save + Exit",0
        .db     -1

title_contact:
        .db     "E-Mail:",0
        .db     "     pad@calc.org",0
        .db     "World Wide Web:",0
        .db     "    pad.calc.org",0
        .db     -1

;############## Initialize a new game

start_new_game:
        call    initialize_game

pre_main_loop:
        ld      a,1
        ld      (in_game),a
        ld      hl,-6
        add     hl,sp
        ld      (collision_done+1),hl
        
;############## Game main loop
        
main_loop:
        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl

        bit     0,l
        jr      z,time_elapsed
        ld      hl,(time_score)
        ld      a,h
        or      l
        jr      z,time_elapsed
        dec     hl
        ld      (time_score),hl
time_elapsed:

        call    hit_enemies            ; Collisions btw. bullets & enemies
   
        call    scroll_sides           ; Scroll sides (inside side buffer)
        call    clear_buffer           ; Prepare main display buffer

        call    do_player              ; Move and draw player
        call    do_companion           ; Move and draw companion ship

        call    enemies                ; Move and draw enemies

        call    player_bullets         ; Move and draw player bullets

        call    enemy_bullets          ; Move and draw enemy bullets
        call    hit_player             ; Collisions involving player

        call    prepare_indicator      ; Prepare shield indicator
                
        call    synchronize
        call    display_screen         ; Synchronize and swap buffers

        call    handle_input           ; Process control keys

        ld      a,(enemies_left)
        or      a
        jr      nz,main_loop
        call    load_level

        ld      hl,in_game
        ld      a,(hl)
        or      a
        jr      nz,main_loop
        inc     a
        ld      (timer),a
        ld      (hl),a
        jr      main_loop

;############## Include remainder of game files
        
#include "source/lib16.asm"
#include "source/new16.asm"
#include "source/disp16.asm"
#include "source/drwspr.asm"
#include "source/player16.asm"
#include "source/shoot.asm"
#include "source/bullets.asm"
#include "source/enemies.asm"
#include "source/init.asm"
#include "source/enemyhit.asm"
#include "source/collide.asm"
#include "source/ebullets.asm"
#include "source/hityou.asm"
#include "source/shop16.asm"
#include "source/helper.asm"
#include "source/eshoot.asm"
#include "source/extlev16.asm"
#include "source/score16.asm"
#include "source/images.asm"
#include "source/levels.asm"
#include "source/data.asm" 

.end
