;##################################################################
;
;   P H O E N I X         F O R        T I - 8 3 / +      ( I o n )
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated December 10, 2000.
;
;##################################################################     

#define __TI83__

#include "ion.inc"
#include "keys.inc"

#define TEXT_MEM saferam2+200

#define ROM_CALL(kewl_routinez) bcall(kewl_routinez)

#ifdef TI83P
        .org    progstart-2
        .db     $BB,$6D

interrupt_entry =$9898
interrupt_byte  =$98
interrupt_table =$9900
interrupt_reg   =$99
backup_storage  =$9A01

#else
        .org    progstart

interrupt_entry =$8282
interrupt_byte  =$82
interrupt_table =$8300
interrupt_reg   =$83
backup_storage  =$8401

#endif

GFX_AREA        =plotsscreen

	ret
    jr  nc,start

D_ZT_STR        =_puts
D_HL_DECI       =_disphl
TX_CHARPUT      =_putc
CLEARLCD        =_clrlcdf
CURSOR_ROW      =currow
CURSOR_COL      =curcol

#include "source/phoenixz.h"

        .db     "Phoenix for Ion",0

start:  jr      main

GET_KEY:
        bcall(_getcsc)
        ret

LD_HL_MHL:
        ld      a,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,a
        ret

CP_HL_DE:
        push    hl
        and     a
        sbc     hl,de
        pop     hl
        ret

#include "source/main12.asm"
