;##################################################################
;
;   Phoenix-Z80 (Player firing)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated December 10, 2000.
;
;##################################################################

;############## Bullet descriptions   

bullet_data_normal:
        .db     6,2,2,6

bullet_data_enhanced:
        .db     3,4,4,8

bullet_double_left:
        .db     9,2,3,7

bullet_double_right:
        .db     12,2,3,7

bullet_triple_left:
        .db     15,3,4,4

bullet_triple_right:
        .db     18,3,4,4

bullet_triple_center:
        .db     21,4,4,4

bullet_quad_left:
        .db     24,8,3,5

bullet_quad_right:
        .db     27,8,3,5

bullet_super:
        .db     33,20,5,7

bullet_swing_left:
        .db     36,8,4,4

bullet_swing_right:
        .db     39,8,4,4

;############## Main shooting routine

player_shoot:
        ld      a,(chosen_weapon)
        or      a
        jr      z,player_shoot_1
        dec     a
        jr      z,player_shoot_2
        dec     a
        jr      z,player_shoot_3
        dec     a
        jr      z,player_shoot_4

player_shoot_5:
       ld      hl,bullet_super
        ld      a,(weapon_5)
        xor     2
        ld      (weapon_5),a
        rrca
        and     1
        add     a,3
        ld      c,a
        call    fire_bullet

        ld      hl,bullet_swing_left
        ld      c,0
        call    fire_bullet

        ld      hl,bullet_swing_right
        ld      c,8
        jr      fire_bullet

player_shoot_4:
        ld      a,(weapon_4)
        xor     128
        ld      (weapon_4),a
        ld      a,0
        jp      m,ps4l
        ld      a,7
ps4l:
        ld      (whichside+1),a
        add     a,2
        ld      c,a

        ld      hl,bullet_quad_right
        call    fire_bullet

whichside:
        ld      c,0
        ld      hl,bullet_quad_left
        jr      fire_bullet

player_shoot_3:
        ld      hl,bullet_triple_center
        ld      c,4
        call    fire_bullet

        ld      hl,bullet_triple_left
        ld      c,2
        call    fire_bullet

        ld      hl,bullet_triple_right
        ld      c,6
        jr      fire_bullet

player_shoot_2:
        ld      hl,bullet_double_left
        ld      c,1
        call    fire_bullet

        ld      hl,bullet_double_right
        ld      c,8
        jr      fire_bullet

player_shoot_1:
        ld      a,(weapon_upgrade)
        or      a
        jr      nz,shoot_enhanced
        ld      hl,bullet_data_normal
        ld      c,5
        jr      fire_bullet

shoot_enhanced:
        ld      c,4     
        ld      hl,bullet_data_enhanced

;############## Fire bullet described at (HL) with X = C - 2

fire_bullet:
        push    hl
        ld      hl,pb_array            ; Locate unused bullet in HL
        ld      b,pb_num
        ld      de,pb_size
loop_search_bullet:
        ld      a,(hl)
        or      a
        jr      z,found_bullet
        add     hl,de
        djnz    loop_search_bullet
        pop     hl
        ret

found_bullet:
        ex      de,hl
        pop     hl

;############## Copy bullet data, HL->description, DE->data, C-2 = X offset

bullet_copy:
        ldi                             ; Type
        ldi                             ; Amount of damage
        ld      a,(player_x)
        add     a,c
        ld      (de),a                  ; X-coordinate
        inc     de
        ldi                             ; Width
        ld      a,(player_y)
        add     a,-3
        ld      (de),a                  ; Y-coordinate
        inc     de
        ldi                             ; Height
        inc     de
        inc     de
        ld      a,7
        ld      (de),a                  ; Data
        ret


