
/* Compacteur ZCP
   Kaid [kaid@excite.fr]
*/

/* Prototypes */
char donnebit(unsigned char *Source,unsigned int i);
char donne7bits(unsigned char *Source,unsigned int i,unsigned int taille);
int  CompZCP(unsigned char *Source,unsigned char *Destination,unsigned int Taille);


/* Retourne le bit  la position i */
char donnebit(unsigned char *Source,unsigned int i)
{
 return (Source[i/8] & ( 128 >> i%8))>0;
}

/* Retourne les 7 bits de la position i  i+6 */
char donne7bits(unsigned char *Source,unsigned int i,unsigned int taille)
{
 unsigned short reste=i%8;
 unsigned char c;

 c=Source[i/8] << reste;

 if (i/8+1<taille)
  c+=Source[i/8+1] >> (8-reste);

 return (c >> 1);
}

/* Compresse le buffer Source de taille <Taille> vers le buffer Destination */
int CompZCP(unsigned char *Source,unsigned char *Destination,unsigned int Taille)
{

 unsigned char b;
 unsigned int Diff,Compteur=0,j=0,k=0,Tmp_j;

 /* On boucle tantque nous ne sommes pas  la fin du fichier */
 while (Compteur<Taille*8)
 {
  /* On sauve le compteur de bits lus*/
  Tmp_j=j;
  b=donnebit(Source,j);
  j++;

  /* On boucle tant que nous sommes sur le mme bit*/
  while (b==donnebit(Source,j) && (j-Tmp_j<63))
   j++;

  /* Diff contient le nombre de rptitions du bit <b> */
  Diff=j-Tmp_j;

  /* S'il ne s'agit pas d'une rptition */
  if (Diff<=7)
  {
    /* On lit 7 bits  partir de Tmp_j */
    b=donne7bits(Source,Tmp_j,Taille);
    j=Tmp_j+7;

    /* On crit les 7 bits et le flag de copie */
    Destination[k++]=b | 128;

    /* On incrmente notre compteur */
    Compteur+=7;
  }
  else
  {
   /* Le flag est dj  0. On ajoute le bit qui est rpt et le nombre de fois*/
   Destination[k++]=(b*64+Diff);

   /* On incrmente notre compteur */
   Compteur+=Diff;
  }
 }

  /* On place le zro final */
  Destination[k++]=0;

  /* On retourne la taille du buffer compact */
  return k;
}


