// Written by Julien Muchembled.
// Copyright (c) 2000-2001. All rights reserved.

// Built with Visual C++ 5.0

#include <windows.h>
#include <stdio.h>

bool b89, bGoodCalc;
char AppName[]="HW2Patch", FileName[MAX_PATH]="", szSuccess[]="AMS 2.0x has been successfully %spatched";
BYTE AMSver, *basecode, *dat;
DWORD BCsize=0, FileSize, ROMbase;
HANDLE hf;
OPENFILENAME ofn={sizeof (OPENFILENAME),NULL,0,"Calculator Upgrade (*.tib;*.89u;*.9xu)\0*.tib;*.89u;*.9xu\0",NULL,0,0,FileName,MAX_PATH,NULL,0,NULL,NULL,OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,NULL,NULL,NULL,0,NULL,NULL};

__declspec (naked) DWORD __fastcall GetDWORD (DWORD addr)
{ __asm {
	add ecx,basecode
	mov eax,[ecx]
	bswap eax
	ret
} }

bool HW2Patch ()
{
	short *addr = (short *) &basecode[GetDWORD (0xB6*4 + GetDWORD (ROMbase + 0x12150)) - 0x5C];
	addr[2] = ~addr[2]; addr[5] = ~addr[5]; addr[8] = ~addr[8];
	return !(*addr ^= 0xDFFF);
}

void FreeAll ()
{
	free (dat);
	CloseHandle (hf);
}

void MsgErrBox ()
{
	DWORD dw = GetLastError();
	if (dw) {
		char *lpMsgBuf;
		FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, NULL, dw, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &lpMsgBuf, 0, NULL);
		MessageBox (NULL, lpMsgBuf, AppName, MB_ICONERROR);
		LocalFree (lpMsgBuf);
	}
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdshow)
{
	if (GetOpenFileName (&ofn)) {
		if ((hf = CreateFile (FileName, GENERIC_READ | GENERIC_WRITE, NULL, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, (HANDLE) NULL)) == INVALID_HANDLE_VALUE)
			MsgErrBox ();
		else { DWORD dw;
			dat = (BYTE *) malloc (FileSize = GetFileSize (hf, NULL));
			ReadFile (hf, dat, FileSize, &dw, NULL);
			basecode = dat;
			if (!_stricmp (&FileName[ofn.nFileExtension],"tib")) BCsize = FileSize;
			else do {
				basecode += BCsize + 74;
				if (((DWORD)basecode-(DWORD)dat) >= FileSize) {
					MessageBox (NULL, "Basecode not found.", AppName, MB_ICONERROR);
					FreeAll (); return 1;
				}
				BCsize = *(DWORD *)basecode; basecode+=4;
			}	while (strcmp ((char *)&basecode[17-78], "basecode"));
			if (bGoodCalc = !strncmp ((char *)&basecode[22], "Advanced Mathematics Software", sizeof("Advanced Mathematics Software")-1)) {
				ROMbase = (b89 = (basecode[141] < 0x40)) ? 0x200000 : 0x400000;
				bGoodCalc = false;
				for (dw=0; dw<BCsize;dw++)
					if (basecode[dw+0] == '2'
					 && basecode[dw+1] == '.'
					 && basecode[dw+2] == '0'
					 && basecode[dw+3] >= '1'
					 && basecode[dw+3] <= '5') {
						bGoodCalc = true;
						AMSver = (szSuccess[7] = basecode[dw+3]) - '1';
						break;
			}		}
			if (bGoodCalc) {
				basecode -= ROMbase + 0x12000;
				char msg[sizeof("AMS 2.0x has been successfully unpatched")];
				sprintf (msg, szSuccess, HW2Patch () ? "" : "un");
				SetFilePointer (hf, 0, NULL, FILE_BEGIN);
				WriteFile (hf, dat, FileSize, &dw, NULL);
				MessageBox (NULL, msg, AppName, 0);
			}	else MessageBox (NULL, "Not AMS 2.01-2.05", AppName, MB_ICONERROR);
			FreeAll ();
	}	}
	return 0;
}