// C Source File
// Created 10/25/00; 5:08:25 PM

// Available Patches
// #define USE_GRAY_PATCH
// #define USE_LONGMUL_PATCH
// #define USE_LONGDIV_PATCH
// #define USE_INITS_PATCH

#define SAVE_SCREEN  // Save/Restore LCD Contents

#include <nostub.h>  // Make NoStub Program
#include <all.h>     // Include All Header Files

int _ti89;           // Produce .89Z File

int _main()
{
//Start Program//
//Start Program Block//
//Variable Declaration    //
	int index1,index2,aname;
	ti_float *amu;
	ti_float *abun;
	ti_float *buffer;
	ti_float total;
	char buffert[8];
//End Variable Declaration//

//Start Information Retrieval Section 1//
	clrscr();
	FontSetSys(F_4x6);
  ST_helpMsg ("Welcome to Atom Figure 2.0!"); 
	printf("Atom Figure v2.0\n\n");
	printf("Number of atoms: ");
//End Information Retrieval Section 1  //

//Start Variable Assignment//
	index2 = index1 = atoi(gets(buffert));
	amu = malloc(index1 * sizeof(ti_float));
  abun = malloc(index1 * sizeof(ti_float));
  buffer = malloc(index1 * sizeof(ti_float));  
  aname = 1;
  total = FLT(0);
  index2 = --index1;
//End Variable Assignment  //

//Start Information Retrieval Section 2//
	ST_helpMsg ("Enter in the information"); 
	for( index1 = index1; index1 >= 0; index1--)
	{
		printf("Atom #%d- AMU(s): ", aname);
		amu[index1] = atof(gets(buffert));

		printf("Atom #%d- Abundance A/100: ", aname);
		abun[index1] = atof(gets(buffert));

		aname++;
	}
//End Information Retrieval Section 2 //

//Start Calculations Section//
	index1 = index2;
	while( index1 >= 0 )
	{//This while multiplies the AMU and ABUN vectors//
		buffer[index1] = fmul( abun[index1], amu[index1] );
		
		index1--;	
	}
	index1 = index2;
	while( index2 >= 0 )
	{
		total = fadd( buffer[index2], total );
	
		index2--;
	}
//End Calculations Section  //

//Start Output/Total Section//
	clrscr();
	printf("Atom Figure v2.0\n\n");

	while( index1 >= 0 )
	{
		printf("[%f] * [%f] = %f\n", amu[index1], abun[index1], buffer[index1]);
					
		index1--;
	}
	
	printf("\nThe average mass is: %f", total);
	ngetchx();
  ST_eraseHelp (); 
//End Output/Total Section  //
//End Program Block//
//End Program//
	return 0;
}
