/*
 * CONIO.H
 *
 * Reimplementation of CONIO.H for Pacific C.
 * Distributed under the terms of the GNU public license V2 or any other.
 * This is free software, no warranty at all for anything.
 *
 * Author: Diego (dgi_il@hotmail.com, dgi_il@surfree.net.il )
 */

#ifndef __PACIFIC_C_CONIO_H__
#define __PACIFIC_C_CONIO_H__

/* constants */
#define LASTMODE  -1         /* Previous text mode                       */
#define BW40       0         /* Black and white       40 columns         */
#define C40        1         /* Color                 40 columns         */
#define BW80       2         /* Black and white       80 columns         */
#define C80        3         /* Color                 80 columns         */
#define MONO       7         /* Monochrome            80 columns         */
#define C4350     64         /* EGA and               43-line            */
                             /* VGA                   50-line            */

/* functions declarations */
void gotoxy(int x, int y);   /* sets cursor position 0,0=top,left        */
int  wherex(void);           /* read cursor column 0=left                */
int  wherey(void);           /* read cursor line   0=top                 */
void clrscr(void);           /* clear screen                             */
void clreol(void);           /* clear to end of line                     */
void textmode(int newmode);  /* change screen mode, only text            */

#define cprintf gnu_printf

#endif
