/*
 * DIR.H
 *
 * Reimplementation of DIR.H for Pacific C.
 * Distributed under the terms of the GNU public license V2 or any other.
 * This is free software, no warranty at all for anything.
 *
 * Author: Diego (dgi_il@hotmail.com, dgi_il@surfree.net.il )
 *         Code stollen from : djgpp (most definitions)
 *			     : HiTechC examples.
 */

#ifndef __PAFICIC_C_DIR_H__
#define __PAFICIC_C_DIR_H__

struct ffblk {
	char		filler[21];
	unsigned char	attr;
	unsigned short	time, date;
	unsigned long	size;
	char		name[13];
};

/* attributes for findfirst()/findnext() */
#define FA_RDONLY       1
#define FA_HIDDEN       2
#define FA_SYSTEM       4
#define FA_LABEL        8
#define FA_DIREC        16
#define FA_ARCH         32

/* sizes of parameters of fnsplit()/fnmerge() */
#define MAXPATH   80
#define MAXDRIVE  3
#define MAXDIR    66
#define MAXFILE   9
#define MAXEXT    5

/* fnsplit() returns thease flags */
#define WILDCARDS 0x01
#define EXTENSION 0x02
#define FILENAME  0x04
#define DIRECTORY 0x08
#define DRIVE	  0x10


int  fnsplit (char *path, char *drive, char *dir, char *name, char *ext);
void fnmerge (char *path, char *drive, char *dir, char *name, char *ext);

int  findfirst(const char *_pathname, struct ffblk *_ffblk, int _attrib);
int  findnext(struct ffblk *_ffblk);

#endif

