/*
 * CONIO.C
 *
 * Reimplementation of CONIO.C for Pacific C.
 * Distributed under the terms of the GNU public license V2 or any other.
 * This is free software, no warranty at all for anything.
 *
 * Author: Diego (dgi_il@hotmail.com, dgi_il@surfree.net.il )
 */

#include <stdio.h>
#include <stdarg.h>
#include <dos.h>
#include <p_conio.h>

static int screensize=4000;

void clrscr(void)
{
   union    REGS regs;
   unsigned char page;          /* temporary for video page             */

   regs.h.ah = 0x0f;            /* get current video state data         */
   int86(0x10,&regs,&regs);     /* BIOS video services (INT 10H)        */
   page = regs.h.bh;            /* save video page                      */
   regs.h.ah = 2;               /* set cursor position                  */
   regs.h.bh = page;            /* restore video page                   */
   regs.h.dh = regs.h.dl = 0;   /* 0 is upper-left corner               */
   int86(0x10,&regs,&regs);     /* BIOS video services (INT 10H)        */

   regs.h.ah = 0x09;            /* fill screen                          */
   regs.h.al = 0x20;            /* with spaces                          */
   regs.h.bh = page;            /* restore video page                   */
   regs.h.bl = 0x07;            /* attribute for normal video           */
   #ifdef __WATCOMC__
     regs.w.cx = screensize;
   #else
     regs.x.cx = screensize;
   #endif
   int86( 0x10, &regs, &regs);
}

void clreol(void)
{
   union REGS regs;
   int x,width,page;            /* temporary for video page             */

   regs.h.ah = 0x0f;            /* get current video state data         */
   int86( 0x10,&regs,&regs);    /* BIOS video services (INT 10H)        */
   page  = regs.h.bh;           /* save video page                      */
   width = regs.h.ah;           /* number of columns                    */
   regs.h.ah = 0x03;            /* read cursor position                 */
   regs.h.bh = 0;
   int86( 0x10, &regs, &regs );
   x = regs.h.dl;
   regs.h.ah = 0x09;            /* fill screen                          */
   regs.h.al = 0x20;            /* with spaces                          */
   regs.h.bh = page;            /* restore video page                   */
   regs.h.bl = 0x07;            /* attribute for normal video           */
   #ifdef __WATCOMC__
     regs.w.cx = width-x;
   #else
     regs.x.cx = width-x;
   #endif
   int86( 0x10, &regs, &regs);
}

void gotoxy(int x, int y)
{
   union REGS regs;
   regs.h.ah = 15;              /* function 15; get video attributes    */
   int86( 0x10,&regs,&regs );   /* BIOS video services (INT 10H)        */
   /* note: bh now contains current display page number                 */
   regs.h.dl = x-1;
   regs.h.dh = y-1;
   regs.h.ah = 2;             /* function 2; set cursor position        */
   int86(0x10,&regs,&regs);   /* BIOS video services (INT 10H)          */
}

int wherex(void)
{
   int x;
   union REGS  regs;
   regs.h.ah = 0x03;
   regs.h.bh = 0;
   int86( 0x10, &regs, &regs );
   x = regs.h.dl+1;
   return (x);
}

int wherey(void)
{
   int y;
   union REGS  regs;
   regs.h.ah = 0x03;
   regs.h.bh = 0;
   int86( 0x10, &regs, &regs );
   y = regs.h.dh+1;
   return (y);
}

void textmode(int newMode)
{
   static int lastMode = LASTMODE;
   union  REGS regs;
   int    newVideoMode=-1;
   int    x, y, page;

   if (newMode==LASTMODE){
     if (lastMode==LASTMODE)
       newMode = C80;                   /* not initialized              */
     else
       newMode = lastMode;              /* use last successfull         */
   }

   if (newMode==C4350){
     if (lastMode!=C80){
       regs.h.ah = 0x00;                /* Set video mode               */
       regs.h.al = 0x03;                /* Color 80                     */
       int86( 0x10, &regs, &regs );
     }
     regs.h.ah = 0x11;                  /* Caracter generator functions */
     regs.h.al = 0x12;                  /* Load Rom font 8x8            */
     regs.h.bl = 0;
     int86( 0x10, &regs, &regs );
     screensize = 4000;                 /* size for clear screen        */
     if (lastMode==C80){                /* this is not ok if this is first call */
     /*** this is to clear only the bottom half of the screen ***/
       regs.h.ah = 15;                  /* function 15; get video attributes */
       int86(0x10,&regs,&regs);
       page=regs.h.bh;                  /* save page                    */
       regs.h.ah = 0x03;                /* read cursor position         */
       int86( 0x10, &regs, &regs );
       x=regs.h.dl;
       y=regs.h.dh;
       regs.h.ah = 2;                   /* set cursor position          */
       regs.h.bh = page;                /* restore video page           */
       regs.h.dh = 25;                  /* cursor to start of bottom half */
       regs.h.dl = 0;
       int86(0x10,&regs,&regs);
       regs.h.ah = 0x09;                /* fill screen                  */
       regs.h.al = 0x20;                /* with spaces                  */
       regs.h.bh = page;                /* restore video page           */
       regs.h.bl = 0x07;                /* attribute for normal video   */
       #ifdef __WATCOMC__
         regs.w.cx = screensize-2000;   /* use correct size for blanking */
       #else
         regs.x.cx = screensize-2000;
       #endif
       int86( 0x10, &regs, &regs);
       regs.h.ah = 2;                   /* function 2; set cursor position */
       regs.h.dl = x;                   /* restore cursor position       */
       regs.h.dh = y;
       int86(0x10,&regs,&regs);         /* BIOS video services (INT 10H) */
     }
     else
       clrscr();
     lastMode = newMode;
     return;
   }

   switch (newMode) {
     case BW40:
       newVideoMode = 0x00;             /* Black & White 40             */
       screensize   = 1000;             /* size for clear screen        */
       break;
     case C40:
       newVideoMode = 0x01;             /* Color 40 */
       screensize   = 1000;             /* size for clear screen        */
       break;
     case BW80:
       newVideoMode = 0x02;             /* Black & White 80             */
       screensize   = 2000;             /* size for clear screen        */
       break;
     case C80:
       newVideoMode = 0x03;             /* Color 80                     */
       screensize   = 2000;             /* size for clear screen        */
       break;
     case MONO:
       newVideoMode = 0x07;             /* Color 80                     */
       screensize   = 2000;             /* size for clear screen        */
       break;
     default:
       return;                          /* bad mode: exit               */
   }
   regs.h.ah = 0x00;                    /* Set video mode               */
   regs.h.al = newVideoMode;
   int86( 0x10, &regs, &regs );

   regs.h.ah = 0x11;                    /* Caracter generator functions */
   regs.h.al = 0x14;                    /* Load Rom font for VGA 8x16   */
   regs.h.bl = 0;
   int86( 0x10, &regs, &regs );
   clrscr();
   lastMode = newMode;
}


int gnu_printf(const char *fmt, ...)
{
    va_list argptr;
    int cnt;

    va_start( argptr, fmt );
    cnt = vprintf(fmt, argptr);         /* do output                    */
    va_end(argptr);

    fflush(stdout);                     /* flush to output              */
    return(cnt);
}


