/*
 * DIR.H
 *
 * Reimplementation of DIR.H for Pacific C.
 * Distributed under the terms of the GNU public license V2 or any other.
 * This is free software, no warranty at all for anything.
 *
 * Author: Diego (dgi_il@hotmail.com, dgi_il@surfree.net.il )
 */

#include <dos.h>
#include <string.h>
#include <p_dir.h>

int fnsplit (char *path, char *drive, char *dir, char *name, char *ext)
{
  int i,result=0;
  char *pstr,*pchar;

  drive[0] = 0;
  dir  [0] = 0;
  name [0] = 0;
  ext  [0] = 0;
  pstr  = 0;
  pchar = 0;

  /* find the drive */
  pchar = strchr( path, ':' );
  pstr  = (char *) path;
  if (pchar)
    {
      for (i = 0; pstr != pchar; i++ )
         {
           drive[i] = *pstr;
           pstr++;
         }
      drive[i  ] = ':';
      drive[++i] = 0;
      /* now it points to ':' */
      pstr++;                          /* now it doesn't */
      result += DRIVE;
    }

  /* now do the directory */
  strcpy( dir, pstr );                 /* copies the all name, without the drive name */
  pchar  = strrchr( dir, '\\' );
  if (!pchar)
    pchar   = strrchr( dir, '/' );     /* try to find also unix slashes */
  if (pchar)
    {
      pchar++;
      *pchar = 0;                      /* end this string here */
      result += DIRECTORY;
    }
  else
    {
    /* if not found, then is pure file name (command,command.com) */
      dir[0] = 0;
    }

  /* now do the name */
  pchar  = strrchr( path, '\\' );
  if (!pchar)
    pchar  = strrchr( path, '/' );
  if (!pchar)
    pchar = path;
  else
    pchar++;
  strcpy( name, pchar );            /* copy all the name, with ext */
  pchar  = strrchr( name, '.' );
  *pchar = 0;                       /* now it is only the file name */
  result += FILENAME;

  /* finaly do the extension */
  pchar = strrchr( path, '.' );
  if (pchar)
    {
      strcpy( ext, pchar );
      result += EXTENSION;
    }

  /* now check for wild-cards */
  return result;
}

void fnmerge (char *path, char *drive, char *dir, char *name, char *ext)
{
  *path = 0; /* start the path string as null terminated string */

  if (drive)
    {
      int i;
      strcat( path, drive );

      i = strlen(path);
      if ( (i) & (path[i-1] != ':'))
        { /* force it to end with a : */
          path[i] = ':';
          path[i++] = 0;
        }
    }

  if (dir)
    {
      int i;
      strcat( path, dir );

      i = strlen(path);
      if ((path[i-1] != '/') & (path[i-1] != '\\'))
        { /* force it to end with a \ */
          path[i] = '\\';
          path[++i] = 0;
        }
    }

  if (name)
    strcat( path, name );

  if (ext)
    {
      char buf[MAXEXT];
      buf[0] = '.';
      buf[1] = 0;

      if (ext[0] != '.')
        { /* an extension must start with '.' */
          strcat( buf, ext );
          strcpy( (char *) ext, buf );
        }
       strcat( path, ext );
    }
}

static struct ffblk __ffblk__;

int findfirst(const char *_pathname, struct ffblk *_ffblk, int _attrib)
{
  union REGS    regs;
  __ffblk__ = *_ffblk;
  regs.h.ah = 0x1a;
  regs.x.dx = (unsigned) &__ffblk__;
  intdos(&regs, &regs);         /* set DTA to file */


  msdos(0x1a00, (unsigned) &__ffblk__);
  return msdos(0x4e00, (unsigned) &__ffblk__, 0);
}

int findnext (struct ffblk *_ffblk)
{
  return msdos(0x4f00);
}
