#define	SCREEN_X 640
#define	SCREEN_Y 480
#define	STARS_COUNT 1000

#include <time.h>
#include <allegro.h>
#include "star.h"
#include "pieces.h"

float	rand(int range);

BITMAP *vir_screen;
int	main_board[28][15];
PIECE	curr_piece;
POINT	where_piece;
int	piece_flag;
char    piece_rotate_direction = LEFT_DIRECTION;

#define	SPEED 35

void make_new_piece();
void update_piece( int direction );
void rotate_piece();
void draw_piece();
void draw_tetris();


void main()
{
   STAR	   star[STARS_COUNT];
   int	   x,y;
   int     c,i;

   srand(time(0));
   allegro_init();
   install_timer();
   install_keyboard();
   set_gfx_mode(GFX_VESA1,	SCREEN_X, SCREEN_Y, 0, 0);
   vir_screen =	create_bitmap(SCREEN_W,	SCREEN_H);

   for (i=0; i<STARS_COUNT; i++)
      star[i].set_vals(	rand() % SCREEN_X, rand() % SCREEN_Y, 0, rand(2) );
//   make_new_piece();

  where_piece.x	= rand() % (15-3);
  where_piece.y	= -3;
  piece_flag = SPEED;
  curr_piece = _LONG;

   do
   {
     if (keypressed())  c = readkey();
     else               c = 0;
     clear( vir_screen );

     for (i=0; i<STARS_COUNT; i++) star[i].update( vir_screen );
     rect( vir_screen, 200-1, 20-1, 440, 20+28*16, 10 );
     // x=15    y=28
     update_piece( c );
     draw_piece();
     draw_tetris();

     vsync();
     blit( vir_screen, screen, 0, 0, 0,	0, SCREEN_W, SCREEN_H);
   }
   while ( (c>>8 != KEY_ESC) );

   destroy_bitmap(vir_screen);
}

float rand(int range)
{
  float	f=1,f1;

  f  =	rand() % --range;
  do {
      f1  = rand() % 50;
      f1 /=	     50;}
  while(!f1);

  f += f1;
  return f;
}

void make_new_piece()
{ int n,j,i;
  where_piece.x	= rand() % (15-3);
  where_piece.y	= -3;

  piece_flag = SPEED;

  switch (rand()%5) {
    case 0 : curr_piece	= _BOX;	  break;
    case 1 : curr_piece	= _LONG;  break;
    case 2 : curr_piece	= _UGLY1; break;
    case 3 : curr_piece	= _UGLY2; break;
    case 4 : curr_piece	= _HIX;	  break;
  }

  n = (rand() % 9) + 1;

  for (i=0; i<4; i++)
    for (j=0; j<4; j++)
       if (curr_piece[i][j]) curr_piece[i][j] = n;
}

int collision()
{  int y,x, i;

   i = false;
   for (y=0; y<4; y++)
     for (x=0; x<4; x++)
//if the piece is drawen on screen
        if (curr_piece[y][x])
//and is in boundary
          if (where_piece.y+y>=0)
//check if there is a collision
            i |= (main_board[where_piece.y+y][where_piece.x+x]);

  return i | (where_piece.y == 29-4);
}

int move_ok( int Adirection )
{   POINT tmp    = where_piece;
    int   result = true;
    int   i, x, y, dx=0, dy=0;

// get the size of the piece
   for (y=0; y<4; y++ )
     for (x=0; x<4; x++ )
         if ((curr_piece[y][x]) && (x>dx)) dx = x;
// calculate new position
    switch (Adirection){
      case 0: break;                    // used to see if the rotation went OK
      case KEY_LEFT:  tmp.x--; break;
      case KEY_RIGHT: tmp.x++; break;
      case KEY_UP:
      case KEY_DOWN: break;
      default: return false;
    }
//check bounds
    if ( (tmp.x<0) || (tmp.x>14-dx) ) { result = false; }
//check if is a vlid position
   for (y=0; y<4; y++ )
     for (x=0; x<4; x++ )
        if (  (curr_piece[y][x])  && (main_board[y+tmp.y][x+tmp.x]) )
          result = false;
//        if ((curr_piece[y][x]) && (!main_board[y+tmp.y][x+tmp+x])) result = false;
//the end
   return result;
}

void update_piece( int direction )
{ int x,y;

  if (move_ok(direction>>8))
    switch (direction>>8){
      case KEY_LEFT:  where_piece.x--; break;
      case KEY_RIGHT: where_piece.x++; break;
      case KEY_UP:    rotate_piece(); break;
      case KEY_DOWN:  piece_flag = 1; break;
      default:        switch(direction && 0xff){
                        case KEY_SPACE: !piece_rotate_direction;
                      }
    }

  --piece_flag;
  if (piece_flag) return;

  where_piece.y++;
  piece_flag = SPEED;

  if (collision())
    {where_piece.y--;
     for (y=0; y<4; y++)
       for (x=0; x<4; x++)
          if (curr_piece[y][x])
            main_board[where_piece.y+y][where_piece.x+x] = curr_piece[y][x];
     make_new_piece();
    }
}

int bottom_part_0()
{
 int x,y,i;

 i = true;
 for (x=0; x<4; x++)
   {
    if (curr_piece[3][x])
      {
       i = false;
       break;
      }
   }

 return i;
}

void rotate_piece()
{
 int x,y,z;
 PIECE tmp=curr_piece, restore=curr_piece;

 if (piece_rotate_direction)
   for (x=0; x<4; x++)
     for (y=0; y<4; y++)
        tmp[y][x] = curr_piece[3-x][y];
 else
   for (x=0; x<4; x++)
     for (y=0; y<4; y++)
        tmp[y][x] = curr_piece[x][3-y];

 curr_piece = tmp;

 z = 0;
 while (bottom_part_0())
   {
    for (y=3; y!=0; y--)
       for (x=0; x<4; x++)
          curr_piece[y][x] = curr_piece[y-1][x];

    for (x=0; x<4; x++) curr_piece[z][x] = 0;
    z++;
   }

 if (!move_ok( 0 )) curr_piece = restore;
}

void draw_piece()
{
 int  x,  y, i;
 int xx, yy, xxx, yyy;

 xxx = 200 + where_piece.x*16;
 yyy =	20 + where_piece.y*16;

 for (y=0; y<4;	y++ )
   for (x=0; x<4; x++ )
     {
      i	= curr_piece[y][x];
      if (i)
	{
	 xx = x*16 + xxx;
	 yy = y*16 + yyy;
         if (where_piece.y+y>=0)
            rectfill( vir_screen, xx, yy, xx+15, yy+15, i );
	 rectfill( vir_screen, xx-xxx+500, yy-yyy+50, xx-xxx+515, yy-yyy+65, i );
	}
     }

}

void draw_tetris()
{
 int  x,  y, i;
 int xx, yy;
 for (y=0; y<28; y++ )
   for (x=0; x<15; x++ )
     {
      i	= main_board[y][x];
      if (i)
	{
	 xx = x*16 + 200;
	 yy = y*16 + 20;
	 rectfill( vir_screen, xx, yy, xx+15, yy+15, i );
	}
     }
}

