#include "undef.h"
#include <allegro.h>
#include <time.h>
#include "undef2.h"

//
// undefine this to see the position of the worm on the screen
//
// #define debug
//

#define SCREEN_Y      480
#define SCREEN_X      640
#define SQ_SIZE_Y     10
#define SQ_SIZE_X     10
#define MAP_Y         SCREEN_Y / SQ_SIZE_Y
#define MAP_X         SCREEN_X / SQ_SIZE_X
#define MAX_WORM_SIZE 80
#define LEVEL_NUM     10
#define MAX_LIFES     3
#define LEVEL_CHAR    -1

//
// map definitions
//
struct TPOINT {char x, y;};
char   map[MAP_Y][MAP_X];

void init_map();
void draw_map();


//
//  worm definitions
//
TPOINT worm[MAX_WORM_SIZE];
char   worm_size = 10;
char   lifes     = MAX_LIFES-1;
char   dead      = false;

void init_worm();
void draw_worm();
void move_worm( char direction, char Grow );
void kill_worm();

//
//   Levels definition
//
char   level_add[LEVEL_NUM] = { 0, 2, 3, 6, 8, 9, 10, 10, 12, 13 };
char   curr_level           = 0;
char   change_size          = 0;
TPOINT where;

void make_new_level();



main()
{
   int c=0,c1;

   srand(time(0));

   allegro_init();
   install_keyboard();
   install_timer();
   set_gfx_mode(GFX_AUTODETECT, SCREEN_X, SCREEN_Y, 0, 0);

   init_map();
   init_worm();
   make_new_level();
   draw_map();
   draw_worm();

   do
   {
     rest(100);
     if (keypressed()) c = readkey();

     switch (c>>8) {
       case KEY_LEFT : if ((c1>>8)==KEY_RIGHT) c = c1; break;
       case KEY_RIGHT: if ((c1>>8)==KEY_LEFT)  c = c1; break;
       case KEY_UP   : if ((c1>>8)==KEY_DOWN)  c = c1; break;
       case KEY_DOWN : if ((c1>>8)==KEY_UP)    c = c1; break;
       case KEY_ESC  : break;

       #ifdef debug
       case KEY_SPACE: readkey(); c = c1; break;  // work as pause here
       #endif

       default: c = c1;
     }

     move_worm( c >> 8, change_size );
     if (change_size) change_size--;
     c1 = c;

     if (dead)
       if (lifes)
         {
           lifes--;
           kill_worm();
           dead = false;
         }
       else c = KEY_ESC << 8;
   }
   while ( (c>>8 != KEY_ESC) && (curr_level != LEVEL_NUM) );

  #ifdef debug
  clear(screen);
  textprintf(screen, font, 0, 10, 10,
        "the level is %d /n at %d:%d", curr_level, where.x, where.y );
  readkey();
  #endif

   return 0;
}


/*******************/
/*  map functions  */
/*******************/
void init_map()
{
   char i;

   for (i = 15; i<35; i++)
      {
       map[i][19] = 70;
       map[i][43] = 70;
      }

   for (i = 20; i!=43; i++) map[20][i] = 70;

   for (i = 5; i<15; i++)
      {
       map[15][i] = 70;
       map[30][i] = 70;
      }

   for (i = MAP_X-5; i>MAP_X-15; i--)
      {
       map[15][i] = 70;
       map[30][i] = 70;
      }
}

void draw_map()
{
   char x, y;

   for (y=0;y<MAP_Y;y++)
     for (x=0;x<MAP_X;x++)
       {
        rectfill( screen, x*SQ_SIZE_X,      y*SQ_SIZE_Y,
                    (x+1)*SQ_SIZE_X-1, (y+1)*SQ_SIZE_Y-1,
                 map[y][x]
               );
        if (x==where.x && y==where.y)
         textprintf(screen, font, x*SQ_SIZE_X, y*SQ_SIZE_Y, 10,
           "%i", curr_level);

       }
}


/********************/
/*  worm functions  */
/********************/
void init_worm()
{
  char xx,yy;
  char i;

  do
    {
     xx = rand() % MAP_X;
     yy = rand() % MAP_Y;
    }
  while (map[yy][xx]);

  for (i = 0; i<worm_size; i++)
    {
     worm[i].x = xx;
     worm[i].y = yy;
    }
}

void draw_worm()
{
  char n,x,y;

/* Draws it the beginning to the end. If all the worm is
   in the same place then you will see only the last part
  for (n=0;n<worm_size;n++)
     {
         x = worm[n].x;
         y = worm[n].y;

         rectfill( screen, x*SQ_SIZE_X,       y*SQ_SIZE_Y,
                       (x+1)*SQ_SIZE_X-1, (y+1)*SQ_SIZE_Y-1,
                   n+1 );
         map[y][x] = n+1;
     }
*/


/* Draws it from the end to the beginning. Showing last the
first part of the worm
*/
  for (n=worm_size-1; n!=-1; n--)
     {
         x = worm[n].x;
         y = worm[n].y;

         rectfill( screen, x*SQ_SIZE_X,       y*SQ_SIZE_Y,
                       (x+1)*SQ_SIZE_X-1, (y+1)*SQ_SIZE_Y-1,
                   n+1 );
         map[y][x] = n+1;
     }

}

void move_worm( char direction, char Grow )
{
   char i;
   char newx, newy;
   char xx, yy;

   switch (direction) {
     case KEY_DOWN:  newx = worm[0].x;
                     newy = worm[0].y + 1;
                     if (newy==MAP_Y) newy = 0;
                     break;
     case KEY_UP:    newx = worm[0].x;
                     newy = worm[0].y - 1;
                     if (newy<0) newy = MAP_Y-1;
                     break;
     case KEY_LEFT:  newx = worm[0].x - 1;
                     newy = worm[0].y;
                     if (newx<0) newx = MAP_X-1;
                     break;
     case KEY_RIGHT: newx = worm[0].x + 1;
                     newy = worm[0].y;
                     if (newx==MAP_X) newx = 0;
                     break;
     default:        return;
   };

  if ( (map[newy][newx])  &&  (map[newy][newx]!=LEVEL_CHAR) )
       { dead = true; return; }


  if   (Grow)
       {
          if (worm_size!=MAX_WORM_SIZE-1) worm_size++;
          else
            {
              xx = worm[worm_size-1].x;
              yy = worm[worm_size-1].y;

              map[yy][xx] = 0;
              rectfill( screen, xx*SQ_SIZE_X,       yy*SQ_SIZE_Y,
                          (xx+1)*SQ_SIZE_X-1, (yy+1)*SQ_SIZE_Y-1,
                         0 );
            }
       }
  else {
         xx = worm[worm_size-1].x;
         yy = worm[worm_size-1].y;

         map[yy][xx] = 0;
         rectfill( screen, xx*SQ_SIZE_X,       yy*SQ_SIZE_Y,
                       (xx+1)*SQ_SIZE_X-1, (yy+1)*SQ_SIZE_Y-1,
                   0 );
       }

  for ( i=worm_size-1; i; i-- )
     {
        worm[i] = worm[i-1];
        #ifdef debug
        textprintf(screen, font, 0, (i+1)*10, 10,
           "#%i  %i:%i ", i, worm[i].x, worm[i].y);
        #endif
     }

  worm[0].x = newx;
  worm[0].y = newy;
  #ifdef debug
  textprintf(screen, font, 0, 10, 10,
        "#%i  %i:%i ", 0, worm[0].x, worm[0].y);
  #endif

  if (map[newy][newx] == LEVEL_CHAR)
    {
      draw_worm();
      make_new_level();
    }
  else draw_worm();

}

void kill_worm()
{
  char xx, yy, i;

  for (i=0; i<worm_size;i++)
     {
       xx = worm[i].x;
       yy = worm[i].y;
       map[yy][xx] = 70;
     }

  init_worm();
  draw_map();
}

/*********************/
/*  level functions  */
/*********************/
void make_new_level()
{
  map[where.y][where.x] = 0;

  change_size = level_add[curr_level];

  do
    {
     where.x = rand() % MAP_X;
     where.y = rand() % MAP_Y;
    }
  while (map[where.y][where.x]);

  map[where.y][where.x] = LEVEL_CHAR;
  curr_level ++;
  draw_map();
}

