/*
 *  dir command
 *
 *  This program implements the standard dos comamnd: "dir"
 *  It was developed using djgpp, and compiled under turbo c 1.01
 *  (from the museum).
 *
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <assert.h>

//#define __DEBUG__
//#undef  __DEBUG__

#ifdef __DJGPP__
  #include <unistd.h>
  #include <crt0.h>

/*
 * I would like to thank CENTROID CORPORATION, HOWARD, PA 16841
 * for releasing the source code of their program, from which i learn
 * a few tricks for djgpp.
 */

#define UNUSED __attribute__((unused))

int _crt0_startup_flags =
       _CRT0_FLAG_USE_DOS_SLASHES |          // keep the backslashes
       _CRT0_FLAG_DISALLOW_RESPONSE_FILES |  // no response files (i.e. `@gcc.rf')
//       _CRT0_FLAG_NO_LFN |                   // disable long file names
       _CRT0_FLAG_LOCK_MEMORY |              // disable virtual memory
       _CRT0_FLAG_KEEP_QUOTES |              // get the original comd line from user
       _CRT0_FLAG_PRESERVE_FILENAME_CASE;    // keep DOS names uppercase

/* no wild card expantion, the proram will handle it self */
char **__crt0_glob_function(char *_argument)
{
  return 0;
};

#endif /* djgpp part... */

struct _config{
  int  pause_after_screen;
  int  wide_display;
  char show_attr[8];  /* capital without, normal with: "aR", archive+!readonly */
  char sort_order[8]; /* capital down, normal up: "nD", name+date(reversed) */
  int  show_subdirectories;
  int  bare_format;
};

struct _totals{
  int file_count;
  int dir_count;
  unsigned long byte_count;
};

#pragma -a-
struct media_id
{
  int info_level;
  int serial1;
  int serial2;
  char vol_id[11];
  char file_sys[8];
};
#pragma -a.

struct _dir_entry{
  char file_name[260];
  unsigned char  attrib;   /* actual attributes of the file found */
  unsigned short ftime;    /* hours:5, minutes:6, (seconds/2):5 */
  unsigned short fdate;    /* (year-1980):7, month:4, day:5 */
  unsigned long  fsize;    /* size of file */

  struct _dir_entry *next;
};
void show_wide_dir( struct _dir_entry *head );

/*
 * deletes the linked list of files loaded with findfirst
 */
void delete_list( struct _dir_entry *head )
{
  struct _dir_entry *tmp = head;

  while (tmp){
    struct _dir_entry *tmp2 = tmp;
    tmp = tmp->next;
    free( tmp2 );
  }
}

char *get_first_param( char *command )
{
  static char temp[256];
  int  i=0;

  if (!command)  return NULL;
  if (!*command) return NULL;
/* pad spaces before the command */
  while ((command[0]!=0) && (command[0]==' '))
    strcpy(&command[0], &command[1]);

/* copy the first word */
  while ( (command[0]!=',') && /*(command[0]!='-') & */
          (command[0]!=' ') && (command[0]!=0) ){
    temp[i] = command[0];
    i++;
    strcpy(&command[0], &command[1]);
  }
  temp[i] = 0;

/* pad spaces before the parameters */
  while ((command[0]) && (command[0]==' '))
    strcpy(&command[0], &command[1]);

/* pad spaces after parameters */
  i = strlen( command );
  while (command[i-1] == ' '){
    command[i-1] = 0;
    i--;
  }

  return temp;
}

/*
 * deletes count bytes from a string, moving the remaining string
 */
char *str_del( char *source, int count )
{
   memmove( source, source + count, strlen(source) - count + 1 );
   return source;
}

/* (happilly stollen from freecom)
 * convert
 *
 * insert commas into a number
 */
int convert(unsigned long num, char *des)
{
  char temp[32];
  int c = 0;
  int n = 0;

  if (num == 0){
    des[0] = '0';
    des[1] = 0;
    n = 1;
  }
  else{
    temp[31] = 0;
    while (num > 0){
      if (((c + 1) % 4) == 0)
        temp[30 - c++] = ',';
      temp[30 - c++] = (char)(num % 10) + '0';
      num /= 10;
    }
    strcpy(des, &temp[31 - c]);
  }
  return n;
}

/* (happilly stolen from freecom (misc.c)
 *
 * returns the unmber of the drive
 *
 */
int drvNum(int drive)
{
  if(drive == 0)
    return getdisk();
  if(drive <= 32)
    return drive - 1;
  return toupper(drive) - 'A';
}

/* (happilly stolen from freecom (misc.c)
 *
 * attempts to change to a drive,
 * returns 1, if the drive exists
 * returns 0, if the drive does not exists
 *
 */
int changeDrive(int drive)
{
  drive = drvNum(drive);
  setdisk(drive);

  if (getdisk() == drive) return 0;

  printf("Invalid drive %c", drive + 'A' );
  return 1;
}

/* happily stollen from freecom (cmdline.c)
 *
 * Name: ltrim() - left trims a string by removing leading spaces
 * Input: str - a pointer to a string
 * Output: returns a trimmed copy of str
 */
char *ltrim(char *str)
{
  char c;
  if ((!str) || (!*str)) return NULL;
  while ((c = *str++) != '\0' && isspace(c));
  return str - 1;
}

/* happily stollen from freecom (cmdline.c)
 *
 * Name: rtrim() - right trims a string by removing trailing spaces
 * Input: str - a pointer to a string
 * Output: str will have all spaces removed from the right.
 */
void rtrim(char *str)
{
  char *p;
  if ((!str) || (!*str)) return;
  if ((!str) || (!*str)) return;
  p = strchr(str, '\0');
  while (--p >= str && isspace(*p));
  p[1] = '\0';
}

char *trim( char * const str )
{
  rtrim( str );
  return ltrim( str );
}

/*
 * appends s1, to d_string, by allocating a new
 * memory region tp d_string, copying d_string to it
 * and finally catting s1 into it.
 */
char *append_dstring( char *d_string, char *s1 )
{
  char *c = (char *) malloc( strlen(d_string) + strlen(s1) );
  if (d_string)
    strcpy( c, d_string );
  else
    *c = 0;
  strcat( c, s1 );
  free( d_string );
  return c;
}

void pharse_command_line( char *cmd_line, struct _config *config )
{
  char *c=cmd_line;

  for (;(c) && (*c) ;c++){          /* he he... i wrote c++...cool... ;-) */
     while ((*c==' ') && (*c)) c++; /* i did it again.... */
     if ('/' == *c){
        str_del( c, 1 );
        switch (toupper(*c)){
           case 'P': config->pause_after_screen  = 1; break;
           case 'W': config->wide_display        = 1; break;
           case 'S': config->show_subdirectories = 1; break;
           case 'B': config->bare_format         = 1; break;
           case 'A':{  /* display attributes */
              int reverse=0;
              str_del( c, 1 );
              if (*c=='-'){ /* do not show thease files */
                 reverse =1;
                 str_del( c, 1 );
              }
              switch(toupper(*c)){
                 case 'D': strcat(config->show_attr,reverse?"D":"d"); break;
                 case 'H': strcat(config->show_attr,reverse?"H":"h"); break;
                 case 'S': strcat(config->show_attr,reverse?"S":"s"); break;
                 case 'A': strcat(config->show_attr,reverse?"A":"a"); break;
                 case 'R': strcat(config->show_attr,reverse?"R":"r"); break;
              }
              break;
           } /* case 'A' */
           case 'O': { /* sort order */
              int reverse=0;
 	      str_del( c, 1 );
              if (*c=='-'){ /* reversed order */
 		reverse =1;
                 str_del( c, 1 );
              }           
              switch(toupper(*c)){
                case 'N': strcat(config->sort_order,reverse?"N":"n"); break;
                case 'E': strcat(config->sort_order,reverse?"E":"e"); break;
                case 'G': strcat(config->sort_order,reverse?"G":"g"); break;
                case 'A': strcat(config->sort_order,reverse?"A":"a"); break;
                case 'S': strcat(config->sort_order,reverse?"S":"s"); break;
                case 'D': strcat(config->sort_order,reverse?"D":"d"); break;
              }
              break;
           } /* case 'O' */
        } /* switch (toupper(*c))*/
        str_del( c, 1 );
     }
     while ((*c!=' ') && (*c)) c++;
  }
}

/*
 *  this function returns the possitive attributes,
 *  negative (which must not be found in a file) are handeled
 *  sepparatly
 */
int get_effective_attr( char *attr)
{
   int the_attr = 0;

   /* by default directories are on */
   if (!strchr( attr, 'D' )) the_attr |= FA_DIREC;
   /* hidden off */
   if ( strchr( attr, 'h' )) the_attr |= FA_HIDDEN;
   /* system off */
   if ( strchr( attr, 's' )) the_attr |= FA_SYSTEM;

   /* the DOS will use them on by default anyway */
   if ( strchr( attr, 'a' )) the_attr |= FA_ARCH;
   if ( strchr( attr, 'r' )) the_attr |= FA_RDONLY;

   return the_attr;
}


struct _dir_entry* fill_list( char *dir_name, char *mask,
  struct _config *config, struct _totals *totals )
{
  char               buffer[260];
  struct _dir_entry *head=NULL, *curr=NULL;
  struct ffblk       f;
  int                done;
  int                attr;

  strcpy(buffer, dir_name );
  strcat(buffer, mask);
  attr = get_effective_attr(config->show_attr);
  done = findfirst( buffer, &f, attr );

  while (!done){
     if (f.ff_attrib & attr) {
        struct _dir_entry *tmp_entry;
        tmp_entry = (struct _dir_entry*) malloc( sizeof(struct _dir_entry) );
   
        tmp_entry->attrib    = f.ff_attrib;
        strcpy(tmp_entry->file_name,f.ff_name);
        tmp_entry->fsize     = f.ff_fsize,
        tmp_entry->ftime     = f.ff_ftime;
        tmp_entry->fdate     = f.ff_fdate;
        tmp_entry->next      = NULL;
        if (head)
          curr->next     = tmp_entry;
        else {
           head = tmp_entry;
        }

        if (tmp_entry->attrib & FA_DIREC)
          totals->dir_count++;
        else {
          totals->file_count++;
          totals->byte_count += tmp_entry->fsize;
        }
     }

     if (curr)
       curr = curr->next;
     else
       curr = head;
     done = findnext( &f );
  }

  /* when doing dir *.bat /s, need to force the dearch of dirs
     name *.* instead of *.bat, execpt when asked to ommit directories

  if ((config->show_subdirectories) and !strchar(config->show_attr, 'd')){
  }
  */

  return head;
}

/* compare sunctions:
 * -----------------
 *
 * the next functions are used bu compare, which will look
 * in the confid string which sub-functions to use. hopefully.
 *  if file1 < file2 return  1
 *  if file1 > file2 return -1
 *  if file1 = file2 return  0
 */
int compare_by_ext( struct _dir_entry *file1, struct _dir_entry *file2 )
{
  int i = 0;

  if ((!file1) || (!file2))
    return 0; /* if one of them is NULL avoid saying anthying... */

  if (file1->attrib & FA_DIREC) i  = 1;
  if (file2->attrib & FA_DIREC) i |= 2;

  switch (i){
    case 0: /* or both dirs, or both files */
    case 3: {
            char f1[MAXFILE]="", e1[MAXEXT]="",
	         f2[MAXFILE]="", e2[MAXEXT]="";
	    int a;
            fnsplit( file1->file_name, NULL, NULL, f1, e1 );
            fnsplit( file2->file_name, NULL, NULL, f2, e2 );

	    a = strcmp(e1,e2);
	    if (!a){
	      a =  strcmp(f1,f2);
	      if (!a) return 0;
	    }

            if (a>0)
	      return  1;
	    else
	      return -1;
    }
    case 1: /* file1 is a dir and file2 not */
	    return -1;
    case 2: /* file2 is a dir and file1 not */
            return 1;
  }
  return 0;
}

int compare_by_dir( struct _dir_entry *file1, struct _dir_entry *file2 )
{
  int i = 0;
  if (file1->attrib & FA_DIREC) i  = 1;
  if (file2->attrib & FA_DIREC) i |= 2;
  switch (i){
    case 0:
    case 3: return  0;
    case 1: return -1;
    case 2: return  1;
  }
  return 0;
}

int compare_by_size( struct _dir_entry *file1, struct _dir_entry *file2 )
{
  int i = 0;
  if (file1->attrib & FA_DIREC) i  = 1;
  if (file2->attrib & FA_DIREC) i |= 2;
  switch (i){
    case 0: if (file1->fsize == file2->fsize)
               return 0;
             else
               if (file1->fsize > file2->fsize)
                 return -1;
               else
                 return 1;
    case 1: return  1;
    case 2: return -1;
    case 3: return  0;
  }

  return 0;
}

int compare_by_name( struct _dir_entry *file1, struct _dir_entry *file2 )
{
  int a = strcmp( file1->file_name, file2->file_name );
  if (!a)
    return 0;
  else
    if (a>0)
       return 1;
    else
       return -1;
}

int compare( struct _dir_entry *file1, struct _dir_entry *file2, char *sort_order )
{
   int sort_index = 0;
   int result = 0;

   while (1) {
     if (!sort_order[sort_index])
       return 0;

     switch (sort_order[sort_index]){
       case 'A': /* access date, (earliest first) */
       case 'a': result = 0; break;
       case 'D': /* date && time (earliest first) */
       case 'd': result = 0; break;
       case 'E': /* extention (dirs first) */
       case 'e': result = compare_by_ext( file1, file2 ); break;
       case 'G': /* dirs first */
       case 'g': result = compare_by_dir( file1, file2 ); break;
       case 'N': /* by name */
       case 'n': result = compare_by_name( file1, file2 ); break;
       case 'S': /* size, smallest first */
       case 's': result = compare_by_size( file1, file2 ); break;
     }

     if ((strchr("ADEGNS", sort_order[sort_index] )))
       result *= -1;

     if (result)
       break;
     else
       sort_index ++;
  }
  return result;
}

void copy_data( struct _dir_entry *d1, struct _dir_entry *d2 )
{
  /* d2 = d1 */
  if (!d2) printf("d1:<%s>, d2:<%s>", d1->file_name, d2->file_name );

  strcpy( d2->file_name, d1->file_name );
  d2->attrib = d1->attrib;
  d2->ftime  = d1->ftime;
  d2->fdate  = d1->fdate;
  d2->fsize  = d1->fsize;
}

/* my implementation of bouble search on a single linked list */
void sort_list( struct _dir_entry *head, char *sort_order )
{
  char sorted = 1;
  struct _dir_entry *curr = head;

  do{
    curr = head;
    sorted = 1;
    while ((curr) && (curr->next)) {
      if (compare( curr, curr->next, sort_order )==1) {
	struct _dir_entry t;
	copy_data( curr, &t );
	copy_data( curr->next, curr );
	copy_data( &t, curr->next );
	sorted = 0;
      }
      curr = curr->next;
    }
#ifdef __DEBUG__
//      ScreenClear();
      clrscr();
      gotoxy( 1, 1 );
//      system("cls");
      show_wide_dir(head );
      delay( 10 );
#endif
  } while (!sorted);
}

void show_detail_dir( struct _dir_entry *head )
{
  struct _dir_entry *tmp = head;

  if (!tmp){
    printf("File not found.\n");
  }

  while (tmp){
    int time = tmp->ftime >> 5 >> 6;

    /* print file name */
    if (tmp->file_name[0] == '.')
      printf("%-13s", tmp->file_name);
    else{
      char buffer[260];
      char *ext;
      strcpy( buffer, tmp->file_name );
      ext = strrchr(buffer, '.');
      if (!ext)
        ext = "";
      else
        *ext++ = '\0'; 
      printf("%-8s %-3s ", buffer, ext);
    }

    /* print <dir> or size in bytes */
    if (tmp->attrib & FA_DIREC)
      printf("%-14s","   <DIR>");
    else {
      char buffer[30];
      convert(tmp->fsize, buffer);
      printf("   %10s ", buffer);
    }
    /* print the date */
    printf(" %.2d-%.2d-%02d", ((tmp->fdate >> 5) & 0x000f),
             (tmp->fdate & 0x001f), ((tmp->fdate >> 9) + 80) % 100);
    /* print the time */
    printf(" %2d:%.2u%c\n",
            (time == 0 ? 12 : (time <= 12 ? time : time - 12)),
           ((tmp->ftime >> 5) & 0x003f),
            (time <= 11 ? 'a' : 'p'));
    tmp = tmp->next;
  }
}

void show_wide_dir( struct _dir_entry *head )
{
  struct _dir_entry *curr=head;

  int i = 0;
  curr = head;
  if (!curr) printf("File not found.\n");
  while (curr){
    char buffer[30];
    if (curr->attrib & FA_DIREC)
      sprintf(buffer, "[%s]", curr->file_name);
    else
        strcpy(buffer, curr->file_name);
    printf("%-15s", buffer);

    i++;
    if (i==5){
      printf("\n");
      i = 0;
    }
    curr = curr->next;
  }
  printf("\n");
}

void show_dir( char *dir_name, char *mask,
               struct _config *config,
               struct _totals *global_totals )
{
  struct _dir_entry *head=NULL;
  struct _totals totals;

  memset( &totals, 0, sizeof(totals) );

  mask     = trim( mask );
  dir_name = trim( dir_name );
  if ((!mask[0]) || (!mask)) {
    /* if no mask asked, mask=*.*, and show directories. */
    mask = "*.*";
/*  strcat( config->show_attr, "d" ); */
  }
  if ((!dir_name)||(!*dir_name)){
     /* due to a buf in turboc rtl i need to do this,
        otherwise memory is going to be trashed somewhere
      */
/*     dir_name = (char *) malloc( 16 );*/

     dir_name = (char *) calloc(8, sizeof(char));
     dir_name = /*(char *)*/getcwd( dir_name, 128 );
  }
  if (dir_name[strlen(dir_name)-1]!='\\') strcat( dir_name, "\\" );

  head  = fill_list( dir_name, mask, config, &totals );
  global_totals->dir_count  += totals.dir_count;
  global_totals->file_count += totals.file_count;
  global_totals->byte_count += totals.byte_count;

  /* sort it */
  if (config->sort_order[0])
     sort_list( head, config->sort_order );

  /* and display it */
  printf(" Directory of %s\n\n", dir_name);
  if (!config->wide_display)
    show_detail_dir( head );
  else
    show_wide_dir( head );

  /* take care of sub-directories searches */
  if (config->show_subdirectories){
     struct _dir_entry *curr = head;
     char *dir_list = NULL, *c = NULL, *c1;

     if (!config->bare_format){
       char buffer[32];
       convert(totals.file_count, buffer);
       printf("%10s file(s)", buffer);
       convert(totals.byte_count, buffer);
       printf("   %12s bytes\n\n", buffer);
     }

     /* make a list of dirs...  */
     while (curr) {
       if ((curr->attrib & FA_DIREC) && strcmp(curr->file_name,".") && strcmp(curr->file_name,"..")) {
           dir_list = append_dstring( dir_list, " " );
           dir_list = append_dstring( dir_list, curr->file_name );
       }
       curr = curr->next;
     }

     /* remove files from the list... */
     delete_list( head );

     c1 = dir_list;
     c = get_first_param( dir_list );
     while( (c!=NULL) && (*c!=NULL)){
       rtrim( c );
       ltrim( c );
       if ((c!=NULL) || (*c!=NULL)) {
	   int orig_size = strlen( dir_name );
	   strcat(dir_name,c);
	   show_dir( dir_name, mask, config, global_totals );
           dir_name[orig_size] = 0;
       }
       c = get_first_param( dir_list );
     };
     free( c1 );
  }
  else
     delete_list( head );
}

void display_header( struct _config *config )
{
  struct ffblk f;
  int currDisk;
  #define drive 2 /* c:> TODO */
  currDisk = getdisk();

  if(changeDrive(drive+1) != 0) {
    setdisk(currDisk);
    return;
  }

  /* print drive info */
  printf(" Volume in drive %c", drive + 'A');

  if (findfirst("\\*.*", &f, FA_LABEL) == 0){
    char *dotptr = strchr(f.ff_name, '.');
    if ((dotptr != NULL) && (strlen(dotptr + 1)))
      str_del( dotptr, 1 );
    printf(" is %s\n", f.ff_name);
  }
  else
    printf(" has no label\n");

  setdisk(currDisk);

  /* print the volume serial number if the return was successful */
/*  if (!r.x.cflag) TODO
    printf(" Volume Serial Number is %04X-%04X\n", media.serial2, media.serial1);
*/
    printf(" Volume Serial Number is %04X-%04X\n", 0xF978, 0x1cea );

  if (config->show_subdirectories)
    printf("\n");
}

void display_footer( struct _config *config, struct _totals *totals )
{
  char buffer[32];
  struct dfree d;
  if (config->bare_format)
    return;

  if (config->show_subdirectories)
     printf("Total files listed\n");

  convert(totals->file_count, buffer);   printf("%10s file(s)", buffer);
  convert(totals->byte_count, buffer);   printf("%12s bytes\n", buffer);
  convert(totals->dir_count, buffer);    printf("%10s dir(s)" , buffer);

  getdfree(0, &d);
  convert( (unsigned long)d.df_avail *
           (unsigned long)d.df_bsec  *
           (unsigned long)d.df_sclus ,
	   buffer
	 );
  printf("%15s free\n\n", buffer);
}

void do_dir( char *params )
{
  struct _config config;
  struct _totals totals;
  char           mask[8+1+3];

  memset( &config, 0, sizeof(config) );
  memset( &totals, 0, sizeof(totals) );

  pharse_command_line( params, &config );
  ltrim( params );
  rtrim( params );
  {
     char d[MAXDRIVE]="", p[MAXDIR]="", f[MAXFILE]="", e[MAXEXT]="";
     params = trim( params );
     if ((params) && (*params)) /*which = */fnsplit( params, d, p, f, e);
     mask[0] = 0;
     strcat( mask, f );
     strcat( mask, e );

     if ((*d) && (!*p) ) strcpy(p, "\\" );
     strcpy( params, d );
     strcat( params, p );
  }


  /* show header */
  if (!config.bare_format)
     display_header( &config );
  /* display the dir(s) */
  show_dir( params, mask, &config, &totals );
  /* display the footer */
  if (!config.bare_format)
     display_footer( &config, &totals );
  else
     printf("\n");
}


int main( int argc, char *argv[] )
{
/*  char *a = NULL;
  int i;
  for (i=1; i!=argc; i++) {
     a = append_dstring( a, " " );
     a = append_dstring( a, argv[i] );
  }
*/

  char a[260] = "";
  int i;
  for (i=1; i!=argc; i++) {
     strcat( a, " " );
     strcat( a, argv[i] );
  }

  do_dir( a );
/*   free( a ); */

  return 0;
}

