#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <assert.h>
#include <dos.h>
#include <stdio.h>

#ifndef __DJGPP__
  #include <alloc.h>
#endif

#ifndef __DJGPP__
  struct dosdate_t
  {
    unsigned char day;            /* 1--31 */
    unsigned char month;          /* 1--12 */
    unsigned int year;            /* 1980--2099 */
    unsigned char dayofweek;      /* 0--6; 0 = Sunday */
  };

  unsigned _dos_setdate(struct dosdate_t *d)
  {
    union REGS r;

    assert(d);
    r.x.ax  = 0x2B00;
    r.x.cx  = d->year;
    r.x.dx  = d->month << 8;
    r.x.dx += d->day & 0xFF;

    intdos( &r, &r );

    if (r.x.ax & 0x00FF)
      return 1;

    return 0;
  }

  void _dos_getdate(struct dosdate_t *d)
  {
    union REGS r;

    assert(d);
    r.x.ax = 0x2A00;
    intdos(&r, &r);

    d->year = r.x.cx;
    d->month = r.x.dx >> 8;
    d->day = r.x.dx & 0xFF;
    d->dayofweek = r.x.ax & 0xFF;
  }

#endif


const char *day_strings[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

char *str_del( char *source, int count )
{
   memmove( source, source + count, strlen(source) - count + 1 );
   return source;
}

/* happily stollen from freecom: cmdline.c
 *
 * Name: ltrim() - left trims a string by removing leading spaces
 * Input: str - a pointer to a string
 * Output: returns a trimmed copy of str
 */
char *ltrim(char *str)
{
  char c;
//  assert(str);
  while ((c = *str++) != '\0' && isspace(c));
  return str - 1;
}

/* happily sotllen from freecom: parsenum.c
 *
 */
char *parsenum(char *s, int maxCnt, int *cnt, int nums[])
{
  int n;
  *cnt = 0;
  
  if(!s || !cnt || !nums || maxCnt <= 0)
    return NULL;
  /* skip leading whitespaces */
  s = ltrim(s);
 
  while(isdigit(*s)) {
    /* scan next number */
    n = 0;
    do {
      if(n >= 10000) return NULL;
      n = n * 10 + *s - '0';
    } while(isdigit(*++s));
    nums[(*cnt)++] = n;
    if (!isascii(*s) || !ispunct(*s) ||
	isspace(*s) ||                   // not included in freecomb
	!--maxCnt) break;
    ++s;      /* skip delimiter */
  }
  return ltrim(s);
}

int do_date( char *params, int exit_on_enter )
{
  struct dosdate_t new_date;
  int nums[3], items;

  _dos_getdate(&new_date);
  params = parsenum( params, 3, &items, nums);

  if ((params) && (*params)){
     printf("Invalid date.\n");
     return 1;
  }

  switch (items){
    case 0: if (exit_on_enter)
             ; // do nothing
            else {//
               char buffer[50]; // lets go wild...
               printf( "Current date is: %s %i-%i-%i\nEnter new date:(mm:dd:[cc]yy):",
                      day_strings[new_date.dayofweek], new_date.month, new_date.day, new_date.year);
               //read the new date
               gets(buffer);            
               // if enpthy do nothing...
               do_date( buffer, 1 );            
            }
            break;
    case 3: new_date.year  = nums[2];
    case 2: new_date.day   = nums[1];
    case 1: new_date.month = nums[0];
  }
  
  if ( _dos_setdate(&new_date) ){
    printf("Invlaid date\n");
    return 1;
  }

  return 0;
}

/*
 * appends s1, to d_string, by allocating a new
 * memory region tp d_string, copying d_string to it
 * and finally catting s1 into it.
 */
char *append_dstring( char *d_string, char *s1 )
{
  char *c = (char *) malloc( strlen(d_string) + strlen(s1) );
  if (d_string)
    strcpy( c, d_string );
  else
    *c = 0;
  strcat( c, s1 );
  free( d_string );
  return c;
}


int main( int argc, char *argv[] )
{
  char *a = NULL;
  int i;
  for (i=1; i!=argc; i++) {
     a = append_dstring( a, " " );
     a = append_dstring( a, argv[i] );
  }

  i = do_date( a, 0 );
  free( a );

  return i;
}
