#ifndef __BATCH_H__
#define __BATCH_H__

#ifndef NIL
 #define NIL 0
#endif

struct FLAGS{
  unsigned   echo:1;
  unsigned   local_echo:1;
  unsigned   exit:1;
};

typedef struct BATCH_FILE{
/* if a commmand.com is called from the command line as
 *  command.com /c dir /w /oe, this structure is for the main loop:
 */
  char   arguments[128];      /* /c dir /w /oe                          */
  char   command_line[128];   /* is the line you are typing             */
  char   command[128];        /* command is the program you want to run */
  char   parameters[128];     /* this are it's parameters               */
  char   label[25];           /* the label of this line,                */

  char   prompt[80];
  struct FLAGS  flags;
  FILE   *input, *output;
  int    line;
} BATCH_FILE;

int   process_line( BATCH_FILE *batch );
int   execute_line( BATCH_FILE *batch );
char *get_prompt( char *prompt );

void  read_line( BATCH_FILE *batch );
int   run_batch( BATCH_FILE *batch );

#endif

