/*
 * Global definitions for fdshell.
 * Which headers to include, which features to enable
 * for each compiler, etc.
 */

#ifndef _FDSHELL_H
#define _FDSHELL_H

#ifdef __TURBOC__
  #include  "compile\turboc.h"
  #define   __FDSHELL_COMPILER_SUPPORTED__ 1
  #define   __COMPILER_FOUND__              "Turbo C (DOS real-mode)"

  #define __CAN_USE_SPAWNO__
#endif

#ifdef __DJGPP__
  #include  "compile\djgpp.h"
  #define   __FDSHELL_COMPILER_SUPPORTED__ 1
  #define   __COMPILER_FOUND__              "DJGPP (DOS 32bit Protected-mode)"
#endif

#ifdef HI_TECH_C
  #include  "compile\hitechc.h"
  #define   __FDSHELL_COMPILER_SUPPORTED__ 1
  #define   __COMPILER_FOUND__              "PACIFIC HI-TECH-C (DOS real-mode)"
#endif

#ifdef __GNUC__
  #ifdef __LINUX__
    #include "compile\djgpp.h"
    #define   __FDSHELL_COMPILER_SUPPORTED__ 1
    #define   __COMPILER_FOUND__              "GCC (linux native)"
  #endif
#endif

#ifndef __FDSHELL_COMPILER_SUPPORTED__
  #error Compiler not supported, sorry. List of supported compilers in readme.txt. You can help porting if you want...
/* and just in case it does not recognize the #error statment... make one */
  Compiler not supported, sorry. List of supported compilers in readme.txt. You can help porting if you want...
#endif

#include "config.h"

/* check what the "user" choosed for compilation */

#ifndef __CAN_USE_SPAWNO__
  #ifdef __USE_SPAWNO__     /* use it when it is available, currently  */
     #undef __USE_SPAWNO__  /* only TCPP101                            */
  #endif
#endif

#ifdef __USE_SPAWNO__
  #include "..\src\libs\spawno\spawno.h"
#endif
/* otherwise use the one in process.h */

#include "fd_func.h"
#include "fd_types.h"
#include "batch.h"
#include "echo.h"
#include "exit.h"
#include "pause.h"
#include "messages.h"
#include "goto.h"
#include "cmdln.h"

#endif

