#include "fdshell.h"


typedef void (*COMMAND_FUNC) (struct BATCH_FILE *batch );

struct COMMAND_ENTRY {
  char *command_name;
  COMMAND_FUNC func;
};

void rem_func( struct BATCH_FILE *batch )
{
}

void call_func( struct BATCH_FILE *batch )
{
  call_batch( batch, 0 );
}

struct COMMAND_ENTRY new_command_table[] = {
  { "exit"     , exit_func  },
  { "rem"      , rem_func   },
  { "call"     , call_func  },
  { "echo"     , echo_func  },
  { "pause"    , pause_func },
  { "cls"      , NULL       },
  { "goto"     , goto_func  },
  { 0          , 0          }
};

int process_line( BATCH_FILE *batch )
{
  char temp[256], *tmp = temp;
  int  i;
 
  strcpy( temp, batch->command_line );
  strcpy( batch->command   , (char *) get_first_param( tmp ) );
  strcpy( batch->parameters, tmp );
 
  parse_string( batch->command   , batch->arguments );
  parse_string( batch->parameters, batch->arguments );
 *batch->label = 0;
 
  if (*batch->command==':'){
    strcpy( batch->label, batch->command );
    strcpy( batch->command   , (char *) get_first_param( batch->parameters ) );
    str_del( batch->label, 1 );
  }
 
  i = strlen(batch->command)-1;
  if (batch->command[i]==':'){
    strcpy( batch->label  , batch->command );
    strcpy( batch->command, (char *) get_first_param( batch->parameters ) );
    str_del( &batch->label[i], 1 );
  }
 
  #ifdef __MSDOS__
  /* in dos compilations this program is not case sensitive */
  strlwr( batch->command );
  #endif
 
  if (*batch->command == '@'){
    batch->flags.local_echo = 1;
    DELETE_CHAR( batch->command );
  }
  else
    batch->flags.local_echo = 0;
 
  return 0;
}

int execute_line( BATCH_FILE *batch )
{
 struct COMMAND_ENTRY *p;
 char  *pp;

 if (!*batch->command) return 0;

/*
 * search for the command in the command table
 */
 for (p=new_command_table; (p->command_name) ; p++){
   if (!strcmp(p->command_name,batch->command)){
     if	( p->func )
       p->func( batch );
     else {
       printf( "Function not implemented yet (%s).\n", batch->command );
       if (batch->flags.echo) fprintf( batch->output, "\n" );
     }
     return 0;
   }
 }

/*
 * the command was not found in the command table, that menas that
 * it is not a built-in (internal) command
 * See if it is an external command and execute it
 */
  pp = (char *)fd_searchpath( batch->command );
  if ( (!pp) || (!*pp) )
    fprintf( batch->output,
                    fdshell_messages[msg_BAD_COMMAND],
             batch->command );
  else
    if (is_binary_executable( batch->command ))
       execute_external_binary( batch->command, batch->parameters );
    else {
      if (batch->input==stdin)
        call_batch( batch, batch->command );
      else{
        fclose(batch->input);
        batch->input = fopen( batch->command,"r");
        batch->line  = 0;
      }
    }
  fprintf( batch->output, "\n" );
  return 0;
}

char *get_prompt( char *prompt )
{
  int  i=0, j=0;
  char temp [256], *p;

  while (prompt[i]){
    switch (prompt[i]){
      case '$':
        i++;
        switch (prompt[i]){
          case 'b':temp[j] = '|';
                   j++;
                   i++;
                   break;
          case 'c':temp[j] = ')';
                   j++;
                   i++;
                   break;
          case 'g':
          case 'G':temp[j] = '>';
                   j++;
                   i++;
                   break;
          case 'p':
          case 'P':
                 #ifdef __PACIFIC__
                  /* pacific uses staticly allocated momory to
                   * return this
                   */
                   p = getcwd( 0 );
                 #else
                  /* in all other compilers need you to pass
                   * a pointer (null will allocate a new one)
                   */
                   p = (char *)malloc( 128 );
                   getcwd( p, 128 );
                 #endif
                   if (prompt[i] == 'p'){
                     /* convert it to lowercase */
                   /*  strlwr( p ); */
                   }
                   temp[j] = 0;
                   strcat( (char *) temp, p );
                   j+= strlen( p );
                   i++;
                 #ifndef __PACIFIC__
                   free( p );
                 #endif
                   break;
          default: /*j++;*/
                   i++;
                   break;
        }
        break;
      default : temp[j] = prompt[i];
                i++;
                j++;
                break;
    }
  }

  temp[j] = 0;

  strcpy( prompt, temp );
  return prompt;
}

void read_line( BATCH_FILE *batch )
{
  char tmp[128];
  strcpy(tmp, batch->prompt);

  batch->command_line[0] = 0;
  if (batch->input == stdin) {
    fprintf( batch->output, get_prompt(tmp) ); /* when callling get_prompt
                                                * the result is saved in temp
                                                */
    fflush( batch->output );
 /* should be:
  *   gets( batch->command_line );
  * But I have written a much better function for that
  */
    get_command_line( batch->command_line, 120 );
  }
  else {
    int i;
    fgets( batch->command_line, 128, batch->input );
    /* "fgets()" keeps the \n in the string */
    i = strlen( batch->command_line );
    if (batch->command_line[i-1]=='\n') batch->command_line[i-1] = 0;
  }
}

int run_batch( BATCH_FILE *batch )
{
  while ((!batch->flags.exit)&& !feof(batch->input)) {
    read_line( batch );
    process_line( batch );
    if (!batch->flags.local_echo)
    if ((batch->input!=stdin) && (batch->flags.echo)){
      fprintf( batch->output, batch->command_line );
      fprintf( batch->output, "\n" );
    }
    execute_line( batch );
    batch->line ++;
  }

  if (batch->input !=stdin ) fclose( batch->input );
  if (batch->output!=stdout) fclose( batch->output );

  return 1;
}

int call_batch( BATCH_FILE *batch, char *filename  )
{
  BATCH_FILE *second_batch=0;
  char   temp[256];

  second_batch = 0;
  second_batch = malloc(sizeof(BATCH_FILE));
  strcpy( second_batch->arguments, batch->parameters);
  if (!filename)
     strcpy( temp, get_first_param(second_batch->arguments));
  else
    strcpy( temp, filename );
  fd_searchpath( temp );

  second_batch->input = fopen( temp, "r" );
  second_batch->output       = stdout;
  second_batch->line         = 0;
 *second_batch->command_line = 0;
 *second_batch->command      = 0;
 *second_batch->parameters   = 0;
  second_batch->flags.echo   = 1;
  second_batch->flags.exit   = 0;
 *second_batch->label        = 0;

  if (!second_batch->input)
    fprintf( batch->output,
             fdshell_messages[msg_COULD_NOT_OPEN_FILE], temp);
  else
    run_batch( second_batch );
  free( second_batch );
  return 0;
}
