#include "cmdln.h"

#ifdef HI_TECH_C
   #define __WORK_ARROUND__
#endif

#ifdef __TURBOC__
   #define __WORK_ARROUND__
#endif

char insert_mode = 1;
char history[10][128];

char *get_command_line( char *buffer, int buffer_len )
{
 char c2[2];
 int i, curr_history=-1;
 char *p=buffer, c=0, t=0;

 memset( buffer, 0, buffer_len );
 while (!t){
   c = getch();
   t = char_in_str(c,"\n\r");
   switch (c) {
     case 0:            /* functions key or arrow */
         t = 0;
         c = getch();
         switch (c) {
           case 'K' :                   /* left arrow */
                if (p==buffer) break;
                p--;
                printf("\b");
                fflush(stdout);
                break;
           case 'M' :                   /* right arrow */
                if (*p==0) break;
                printf( "%c", *p );
                fflush(stdout);
                p++;
                break;
           case 'H' :                   /* up arrow    */
           case 'P' :                   /* down arrow  */
		i = curr_history;
		if (c=='H')
		   curr_history++;
		else
		   curr_history--;
		if (curr_history>=10) curr_history = 0;
		if (curr_history<=-1)  curr_history = 9;
		if (*history[curr_history]) {
                  for ( ; *p; p++, printf(" ") );
                  for ( ; p!=buffer; p--, printf("\b \b") );
                  memset( buffer, 0, buffer_len );
                  p = buffer;
                  strcpy( buffer, history[curr_history] );
                  for ( ; *p; p++ );
                  printf("%s", buffer );
		}
		else
                  curr_history = i;
                fflush(stdout);  /* Pacific C demands it */  
		break;
           case 'R' :                   /* insert      */
                insert_mode = (insert_mode?0:1);
                #ifndef HI_TECH_C
                if (insert_mode)
                  _setcursortype(_NORMALCURSOR);
                else
                  _setcursortype(_SOLIDCURSOR);
                #endif
                break;
           default:
                break;
         }
         break;

#ifdef __WORK_ARROUND__
/* This is a work arround a bug of TURBO C and PACIFIC C
 * It thinks '\e' means 'e', and when you press escape you see it on the
 * screen. When you press 'e' it clears the screen. Does ANSY C defines
 * \e as escape or this is an extention of GCC/DJGPP?
 */
     case '\x1B':
#else
     case '\e':         /* escape cleans the line */
#endif
         for ( ; *p; p++, printf(" ") );
         for ( ; p!=buffer; p--, printf("\b \b") );
         fflush(stdout);
         memset( buffer, 0, buffer_len );
         p = buffer;
	 curr_history = 0;
         break;
     case '\026'  : // ctrlV
         insert_mode = (insert_mode?0:1);
         #ifndef HI_TECH_C
         if (insert_mode)
           _setcursortype(_NORMALCURSOR);
         else
           _setcursortype(_SOLIDCURSOR);
         #endif
         break;
     case '\b':         /*back space */
         if (p==buffer) break;
         printf( "\b \b" );
         fflush(stdout); /* Pacific C demans it */
         p--;
        *p = 0;
         break;
     case '\r':         /* enter means end input */
     case '\n':
/*      *p = 0; */
         break;
     default:
         if (insert_mode){
           c2[0] = c;
           c2[1] = 0;
           str_ins( p, c2 );
         }
         else
          *p = c;
         printf("%s", p );
         p++;
         if (*p)
           for (i=0; i!= strlen(buffer)-(p-buffer); i++, printf("\b") );
         fflush(stdout);  /* Pacific C demands it */  
   }
  }
  printf("\n");

  for (i=9; i; i-- )
     strcpy( history[i], history[i-1] );
  strcpy( history[0], buffer );
  return buffer;
}

void save_history( FILE *stream )
{
  if (!stream) return;
}

void laod_history( FILE *stream )
{
  if (!stream) return;
}

