/*
 * This file was happily sotelln from FreeCOM - FreeDOS command interpreter.
 *
 * This is basicly alias.c and cmd_line.cfiles from version 2025.
 * It saved me a few hours of work, and it fixes some problems that I did
 * not even thought of. Thanks FreeCOM guys!!.
 *
 * This file is GNU.
 */

#include "alias.h"

/* assert */
#define assert(char) ((void) 0)

/* stollen from cmd_line.c in freecom */
char *ltrim(char *str)
{ char c;

  assert(str);

  while ((c = *str++) != '\0' && isspace(c))
    ;

  return str - 1;
}

/*
 * Name: rtrim() - right trims a string by removing trailing spaces
 * Input: str - a pointer to a string
 * Output: str will have all spaces removed from the right.
 */
void rtrim(char * const str)
{ char *p;

  assert(str);

  p = strchr(str, '\0');
  while (--p >= str && isspace(*p))
    ;
  p[1] = '\0';
}

/*
 *  Combines ltrim() & rtrim()
 */
char *trim(char *str)
{ assert(str);
  rtrim(str);
  return ltrim(str);
}

/* shamesly stollen from freecom... alias.c */

typedef struct TAlias
{
  char *name;
  char *subst;
  unsigned short used;
  struct TAlias *next;
}
TAlias;

static unsigned short useFlag = 0;
static TAlias *first = 0,
 *last = 0;

/* module internal functions */
void partstrlower(char *str)    /* strlwr only for first word in string */
{       char c;
  assert(str);
  while ((c = *str) != '\0' && !isspace(c))
  {
    *str++ = tolower(c);
  }
}

void aliasprint( FILE *where )
{
  TAlias *ptr = first;
  while (ptr)
  {
        assert(ptr->name);
        assert(ptr->subst);
    fprintf(where, "%s=%s\n", ptr->name, ptr->subst);
    ptr = ptr->next;
  }
  fprintf(where, "\n" );
}

void aliasdel(char *name)
{
  TAlias *ptr = first,
   *prev = 0;

  while (ptr)
  {
        assert(ptr->name);
        assert(ptr->subst);
    if (!strcmp(ptr->name, name))
    {
      if (prev)
        prev->next = ptr->next;
      else
        first = ptr->next;
      free(ptr->name);
      free(ptr->subst);
      free(ptr);
      return;
    }
    prev = ptr;
    ptr = ptr->next;
  }
}

int aliasadd(char *name, char *subst)
{
  TAlias *ptr = first,
   *prev,
   *entry;
  char *s;

        assert(subst);
        assert(name);

        /* When the alias is already located within the list, we need not
                search for the correct location */
  while (ptr)
  {
        assert(ptr->name);
        assert(ptr->subst);
    if (!strcmp(ptr->name, name))
    {
      if((s = strdup(subst)) == NULL)
        return -1;
      free(ptr->subst);
      ptr->subst = s;
      return 0;
    }
    ptr = ptr->next;
  }

        /* newly create the alias */
  if((ptr = (TAlias *) malloc(sizeof(TAlias))) == NULL)
    return -1;
  ptr->next = NULL;

  if((ptr->name = strdup(name)) == NULL) {
    free(ptr);
    return -1;
  }

  if((ptr->subst = strdup(subst)) == NULL)
  {
    free(ptr->name);
    free(ptr);
    return -1;
  }
  partstrlower(ptr->subst);     /* it's necessary for recursive substitution */

  ptr->used = 0;

 /* Alias table must be sorted!
  * Here a little example:
  *   command line = "ls -c"
  * If the entries are
  *   ls=dir
  *   ls -c=ls /w
  * command line will be expanded to "dir -c" which is not correct.
  * If the entries are sortet as
  *   ls -c=ls /w
  *   ls=dir
  * it will be expanded to "dir /w" which is a valid DOS command.
  */
  entry = first;
  prev = 0;
  while (entry)
  {
    if (strcmp(ptr->name, entry->name) > 0)
    {
      if (prev)
      {
        prev->next = ptr;
        ptr->next = entry;
      }
      else
      {
        ptr->next = entry;
        first = ptr;
      }
      return 0;
    }
    prev = entry;
    entry = entry->next;
  }

  /* The new entry is the smallest (or the first) and must be
   * added to the end of the list.
   */
  if (!first)
    first = ptr;
  else
    last->next = ptr;
  last = ptr;

  return 0;
}

void aliasexpand(char *cmd, int maxlen)
{
  char *cp;
  unsigned m;
  unsigned len;
  short expanded;
  TAlias *ptr;

        assert(cmd);

  if (++useFlag == 0)           /* (int) overflow */
  {                             /* The useFlag specifies, if the particular
                                   ALIAS is used by the _current_ expand.
                                   To avoid to clear the flag each time when
                                   to expand a string a different flag value
                                   is used each time. */
    if((ptr = first) != NULL)
                        /* reset all values to be sure we hit no old one */
      do ptr->used = 0;
      while((ptr = ptr->next) != NULL);
    useFlag = 1;
  }
        cp = ltrim(cmd);                /* skip leading whitespaces */

  /* Check if the user disabled alias expansion */
  if (*cp == '*')
  {
        cp = ltrim(cp + 1);
    memmove(cmd, cp, strlen(cp) + 1);
    return;
  }

  /* this allows to case-sensitively compare strings, which
   is much faster */
  partstrlower(cp);
  /* to simplify the loop below */
  memmove(cmd, cp, strlen(cp) + 1);

  /* substitution loop */
  /* Empty alias list --> no loop */
  if(first) do {
    expanded = 0;
    ptr = first;
    do {
        assert(ptr);
        assert(ptr->name);
        assert(ptr->subst);
      len = strlen(ptr->name);
      if ((isspace(cmd[len]) || cmd[len] == '\0')       /* end of word */
       && !strncmp(cmd, ptr->name, len)         /* line begins with alias */
       && ptr->used != useFlag)                                 /* this alias unused */
      {
        m = strlen(ptr->subst);
        if (strlen(cmd) - len + m > maxlen)
        {
//          error_command_too_long(); rem by dgi
          cmd[0] = '\0';        /* the parser won't cause any problems with an empty line */
          return;
        }
        else
        {
                /* adjust the remaining part within the command line */
          memmove(&cmd[m], &cmd[len], strlen(&cmd[len]) + 1);
                /* prepend the alias substitution */
          memcpy(&cmd[0], &ptr->subst[0], m);
          ptr->used = useFlag;
          expanded = 1;
        }
      }
    } while((ptr = ptr->next) != NULL);
  } while(expanded);
}

char *alias_get( char *alias )
{
  TAlias *ptr = first;

  while (ptr){
    if (!stricmp( alias, ptr->name))
      return ptr->subst;
    ptr = ptr->next;
  }

  return 0;
}

#pragma argsused
void alias_func( BATCH_FILE *batch )
{
  char *ptr;
  if (!batch->parameters || !*batch->parameters){
    aliasprint( batch->output );
    return;
  }

  if ((ptr = strchr(batch->parameters, '=')) == 0) {
    printf("%s\n", alias_get(batch->parameters) );
    return;
  }

  /* Split rest into name and substitute */
  *ptr++ = '\0';
  partstrlower(batch->parameters);
  if (ptr[0]) {
    aliasadd(batch->parameters, trim(ptr));
    return;
  }

  aliasdel(batch->parameters);
  return;
}

