#include <fd_func.h>

/* fnsplit, fnmerge
 *
 * Slipts and merges a string containing a file name. Knows to manipulate also LFN
 * (knows "." at the beggining of a file, is a directory).
 */
int fnsplit (char *path, char *drive, char *dir, char *name, char *ext)
{
  int i,result=0;
  char *pstr,*pchar;

  drive[0] = 0;
  dir  [0] = 0;
  name [0] = 0;
  ext  [0] = 0;
  pstr  = 0;
  pchar = 0;

  /* find the drive */
  pchar = strchr( path, ':' );
  pstr  = (char *) path;
  if (pchar)
    {
      for (i = 0; pstr != pchar; i++ )
         {
           drive[i] = *pstr;
           pstr++;
         }
      drive[i  ] = ':';
      drive[++i] = 0;
      /* now it points to ':' */
      pstr++;                          /* now it doesn't */
      result += DRIVE;
    }

  /* now do the directory */
  strcpy( dir, pstr );                 /* copies the all name, without the drive name */
  pchar  = strrchr( dir, '\\' );
  if (!pchar)
    pchar   = strrchr( dir, '/' );     /* try to find also unix slashes */
  if (pchar)
    {
      pchar++;
      *pchar = 0;                      /* end this string here */
      result += DIRECTORY;
    }
  else
    {
    /* if not found, then is pure file name (command,command.com) */
      dir[0] = 0;
    }

  /* now do the name */
  pchar  = strrchr( path, '\\' );
  if (!pchar)
    pchar  = strrchr( path, '/' );
  if (!pchar)
    pchar = path;
  else
    pchar++;
  strcpy( name, pchar );            /* copy all the name, with ext */
  pchar  = strrchr( name, '.' );
  *pchar = 0;                       /* now it is only the file name */
  result += FILENAME;

  /* finaly do the extension */
  pchar = strrchr( path, '.' );
  if (pchar)
    {
      strcpy( ext, pchar );
      result += EXTENSION;
    }

  /* now check for wild-cards */
  return result;
}

void fnmerge (char *path, char *drive, char *dir, char *name, char *ext)
{
  *path = 0; /* start the path string as null terminated string */

  if (drive)
    {
      int i;
      strcat( path, drive );

      i = strlen(path);
      if ( (i) & (path[i-1] != ':'))
        { /* force it to end with a : */
          path[i] = ':';
          path[i++] = 0;
        }
    }

  if (dir)
    {
      int i;
      strcat( path, dir );

      i = strlen(path);
      if ((path[i-1] != '/') & (path[i-1] != '\\'))
        { /* force it to end with a \ */
          path[i] = '\\';
          path[++i] = 0;
        }
    }

  if (name)
    strcat( path, name );

  if (ext)
    {
      char buf[MAXEXT];
      buf[0] = '.';
      buf[1] = 0;

      if (ext[0] != '.')
        { /* an extension must start with '.' */
          strcat( buf, ext );
          strcpy( (char *) ext, buf );
        }
       strcat( path, ext );
    }
}

char *strupr( char *str )
{
  if (str)
    while (*str){
      *str = toupper(*str);
      str ++;
    }

 return str;
}

char *strlwr( char *str )
{
//  printf("before %s.\n", str );
  if (str)
    while (*str){
      *str = tolower(*str);
      str ++;
    }
//  printf("after %s.\n", str );
  return str;
}

int access(const char *filename, int flags)
{
   FILE *f;

   f = fopen( filename, "r" );
   if (f){
     fclose( f );
     return 0;
   } else
     return 1;
}

void gotoxy(int x, int y)
{
   union REGS regs;
   regs.h.ah = 15;              /* function 15; get video attributes    */
   int86( 0x10,&regs,&regs );   /* BIOS video services (INT 10H)        */
   /* note: bh now contains current display page number                 */
   regs.h.dl = x-1;
   regs.h.dh = y-1;
   regs.h.ah = 2;             /* function 2; set cursor position        */
   int86(0x10,&regs,&regs);   /* BIOS video services (INT 10H)          */
}

int wherex(void)
{
   int x;
   union REGS  regs;
   regs.h.ah = 0x03;
   regs.h.bh = 0;
   int86( 0x10, &regs, &regs );
   x = regs.h.dl+1;
   return (x);
}

int wherey(void)
{
   int y;
   union REGS  regs;
   regs.h.ah = 0x03;
   regs.h.bh = 0;
   int86( 0x10, &regs, &regs );
   y = regs.h.dh+1;
   return (y);
}

int get_psp()
{
   union REGS regs;
   regs.h.ah = 0x51;
   intdos( &regs, &regs );
   return regs.x.bx;
}

