#include "set.h"
/*
 *  command: set
 *  Syntax : set [variable_name] <=> [value]
 *           the equal sign is optional.
 */
void set_func( struct BATCH_FILE *batch )
{
  char var[80], content[511], *cc; /* sizes from 4dos */

  if (*batch->parameters){
    cc = strchr( batch->parameters, '=');
    if (cc){
      memmove( var, batch->parameters, cc - batch->parameters );
      var[ cc - batch->parameters ] = 0;
      strcpy( content, cc );
      str_del( content, 1 );

      /* now trim leading spaces and tail spaces */
      cc = var;
      while ((*cc==' ') && (*cc) ) str_del( cc, 1 );
      cc = var;
      while (*cc) cc++;
      cc--;
      while (*cc==' ') { *cc=0; cc--; };
      cc = content;
      while ((*cc==' ') && (*cc) ) str_del( cc, 1 );
      strupr( var );    /* dos and most libraries like it this way */

//      fprintf( batch->output, "%%%s%% = [%s]\n", var, content );
      set_env( var, content );
    }
    else{ /* no '=' found */
      strcpy( content, batch->parameters );
      strcpy( var, get_first_param(content) );
      strupr( var );    /* most DOS libraries like it this way */

      if (*content){
	/* set %var%=content */
//        fprintf( batch->output, "[%%%s%%] = [%s]\n", var, content );
        set_env( var, content );
      }
      else {
	cc = getenv(var);
	if (cc)
          fprintf( batch->output, "%%%s%%=[%s]\n", var, cc );
	else
	  fprintf( batch->output, "%%%s%% not in enviroment.\n", var  );
      }
    }
  }
  else{
    char *c;

    c = get_envlist();

    while (*c) {
      printf( "%s\n", c );
      while (*c) c++;
      c++;
    }
  }

//  printf("\n");

  return;
}
