#include <qtextcodec.h>
#include <qptrlist.h>
#include "editortypes.h"
 
//static QPtrList<QTextCodec> *codecList = 0;
QPtrList<QTextCodec> *CodecList = 0;

MyCodecListEntry MyCodecList[] = {
    // this is the only one which MUST exist
    { QString("System default"),     QString("") },
	    
    // all others are optional and can be removed, the order is not important as well
    { QString("US English"),         QString("ISO 8859-1") },
    { QString("UTF8"),               QString("UTF-8") },
//    { QString("Unicode"),            QString("ISO 8859-1") },
    { QString("Western European"),   QString("ISO 8859-1") },
    { QString("Central European"),   QString("ISO 8859-2") },
    { QString("Southern European"),  QString("ISO 8859-3") },
    { QString("Baltic"),             QString("ISO 8859-4") },
    { QString("Nordic"),             QString("ISO 8859-14") },
    { QString("Celtic"),             QString("ISO 8859-10") },
    { QString("Turkish"),            QString("ISO 8859-9") },
    { QString("Vietnamese"),         QString("CP 1258") },
    { QString("Cryllic"),            QString("ISO 8859-5") },
    { QString("Greek"),              QString("ISO 8859-7") },
    { QString("Arabic"),             QString("ISO 8859-6") },
    { QString("Hebrew"),             QString("ISO 8859-8-I") },
//    { QString("Tahi"),               QString("TIS620") },
    { QString("Chinese"),            QString("Big5") },
    { QString("Japanese"),           QString("eucJP") },
    { QString("Korean"),             QString("eucKR") },
    { QString(""),                   QString("") }
};


void BuildCodecList()
{
    QTextCodec *codec;
    delete CodecList;
    CodecList = new QPtrList<QTextCodec>;
    
    int i;
    for (i = 0; (codec = QTextCodec::codecForIndex(i)); i++)
	CodecList->insert( 0, codec );
}

int GetIndexOfCodecName( QString CodecName )
{
    for  (int i = 0; !MyCodecList[i].CodecName.isEmpty(); i++ )
	if (MyCodecList[i].CodecName.lower() == CodecName.lower()) return i;
    
    return 0;
}
