/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <qtextcodec.h>
#include <qfontdialog.h>
#include "codeclist.h"
#include "editortypes.h"

void ConfigDialog::init()
{
    int n = CodecList->count();
    
    for ( int i = 0; i < n; i++ )
	AdvancedComboBox->insertItem( CodecList->at(i)->name() );
     
    for  (int i = 0; !MyCodecList[i].CodecName.isEmpty(); i++ )
	if (MyCodecList[i].Encoding.isEmpty())
	    EasyComboBox->insertItem( 
		    MyCodecList[i].CodecName + " (" + QTextCodec::codecForLocale()->name() + ")" 
	    );
	else
	    EasyComboBox->insertItem( MyCodecList[i].CodecName );
}
                            
void ConfigDialog::SetData( EditorConfiguration *config )
{
    EasyRadioButton     ->setChecked    ( config->IsEasyConfig  );
    AdvancedRadioButton ->setChecked    ( !config->IsEasyConfig );
    
    EasyComboBox    ->setCurrentItem( config->EasyConfig     );
    AdvancedComboBox->setCurrentItem( config->AdvancedConfig );
    
    FontNameEdit->setText( config->EditorFontName );
    
    BackUpCheck  ->setChecked( config->MakeBackUp );
    WordWrapCheck->setChecked( config->WordWrap   );
    AutoSaveCheck->setChecked( config->AutoSave   );
 }

void ConfigDialog::GetData( EditorConfiguration *config )
{
    config->IsEasyConfig   = EasyRadioButton->isOn();
    config->EasyConfig     = EasyComboBox->currentItem();
    config->AdvancedConfig = AdvancedComboBox->currentItem();
    
    config->EditorFontName = FontNameEdit->text();
    
    config->MakeBackUp = BackUpCheck  ->isOn();
    config->WordWrap   = WordWrapCheck->isOn();
    config->AutoSave   = AutoSaveCheck->isOn();    
}


void ConfigDialog::InputFont()
{

    bool ok;
    QFont somefont = QFont();
    somefont.fromString( FontNameEdit->text()  );
    QFont font = QFontDialog::getFont( &ok, somefont, this );
    
    if ( ok ) 
	 FontNameEdit->setText( font.toString() );
}

