/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qsettings.h>
#include <qapplication.h>

#include "configdialog.h"
#include "codeclist.h"
#include "finddialog.h"
#include "replacedialog.h"
#include "gotolinedialog.h"
#include "aboutbox.h"

EditorConfiguration config;

QTextCodec* GetDefaultCodec()
{
    if (config.IsEasyConfig){
	if (!MyCodecList[config.EasyConfig].Encoding.isEmpty())
	    return QTextCodec::codecForName( MyCodecList[config.EasyConfig].Encoding );
    }
    else {
	return CodecList->at(config.AdvancedConfig );
    }

// this was made like this to shut up gcc, or else you
// get a "function is finish and no return.." error... bah...
    return QTextCodec::codecForLocale ();
}

void MainWindow::init()
{
    QFont f;  
    QString s;

    LoadSettings();

    if (config.BackUpType==999) {
         // this value is the default when no config is found (hack...)
         // need to use the default values
	
         // see if "console" font is found... (from kde konsole)
         f = QFont( "Console", 14 );
         if (f.family() == "Console") 
	    TextEditor->setCurrentFont(f);	
         else	    
	    qDebug("Warning: \"Console\" font family not found. using default." );    
	 
         config.EditorFontName = TextEditor->font().toString();	 
         config.IsEasyConfig   = 1;
	 config.BackUpType     = 0;
         TextEditor->setWordWrap( QTextEdit::NoWrap );
    }
    else {
	ApplySettings();
    }

    //qApp->setReverseLayout( true );
    s = qApp->argv()[ 1 ];
    if (!s.isEmpty())
	LoadBuffer( s );
}

void MainWindow::SettingConfig()
{
  ConfigDialog dlg;
  
  dlg.SetData( &config );
  if (dlg.exec()){
      dlg.GetData( &config );      
      ApplySettings();
  }
}

void MainWindow::LoadBuffer( QString filename )
{	
    QFile f( filename );
    QFileInfo fi( f );
    if (!f.open( IO_ReadOnly ) ) {
	QMessageBox::warning(this,"I/O Error",
		    QString("The file could not be opened.\n\n")
			+filename);
	return;
    }
    
    QTextStream t(&f);
    t.setCodec( GetDefaultCodec() );
    TextEditor->setText( t.read() );
    f.close();
    TextEditor->setModified(FALSE);
//    setCaption( filename );
    EditorFileName = fi.absFilePath() + fi.fileName();
}
void MainWindow::SaveBuffer( QString filename )
{
/*    if (config.MakeBackUps) && QFile::exists(filename){	
	// how the hell do I do it easly????
    }*/    
    
    QFile f( filename );
    if (!f.open( IO_WriteOnly ) ) {
	QMessageBox::warning(this,"I/O Error",
		    QString("The file could not be opened.\n\n")
			+filename);
	return;
    }
    
    QTextStream t(&f);
    t.setCodec( GetDefaultCodec() );
   
    t << TextEditor->text();
    f.close();
    TextEditor->setModified(FALSE);
//    setCaption( filename );
}

void MainWindow::fileNew()
{
    if (!CanCloseEditor())
	return;
    
    TextEditor->setText( "" );     
    TextEditor->setModified(FALSE);
//    setCaption( filename );
    EditorFileName = "";
}

void MainWindow::fileOpen()
{
    if (!CanCloseEditor())
	return;
        
    QString filename = QFileDialog::getOpenFileName( QString::null, QString::null, this );
    if ( filename.isEmpty() )
      return;
    
    LoadBuffer( filename );
}

bool MainWindow::fileSave()
{
   if (EditorFileName.isEmpty())
       return fileSaveAs();
   
   SaveBuffer(EditorFileName);
   return TRUE;
}

bool MainWindow::fileSaveAs()
{
 QString fn = QFileDialog::getSaveFileName( QString::null, QString::null, this );
 if ( fn.isEmpty() )
     return FALSE;
 else
     EditorFileName = fn;
     SaveBuffer(EditorFileName);
     return TRUE;	
}

void MainWindow::filePrint()
{

}

void MainWindow::fileExit()
{
    if (config.AutoSave){
	if (!EditorFileName.isEmpty())
	     fileSave(); 
	SaveSettings(); 
	close(); 
    }
    else
	if (CanCloseEditor()) 
	{ SaveSettings(); close(); }
}

void MainWindow::searchFind()
{
   FindDialog dlg;
   
   dlg.SetTheEditor( TextEditor );
   dlg.exec();
}

void MainWindow::searchReplace()
{
   ReplaceDialog dlg;
   
   dlg.SetTheEditor( TextEditor );
   dlg.exec();
}


void MainWindow::searchGotoLine()
{
   GotoLineDialog dlg;
   
   dlg.SetTheEditor( TextEditor );
   dlg.exec();
}

void MainWindow::helpIndex()
{
}

void MainWindow::helpContents()
{

}

void MainWindow::helpAbout()
{
  AboutBox about;
  
  about.exec();
}


void MainWindow::AboutQT()
{
    QMessageBox::aboutQt( this, "A small QT editor" );
}


// if file has changed:
//    ask for saving,
//       [yes] [no], returns TRUE (if [yes] save file)
//       [cancel]    return  FALSE
// file not changed:
//    return TRUE
bool MainWindow::CanCloseEditor()
{
   if (TextEditor->isModified()){
        QMessageBox mb( "Warning",
			"The file has been changed.\n"
			"Do you want to save?",
			QMessageBox::Information,
			QMessageBox::Yes | QMessageBox::Default,
			QMessageBox::No,
			QMessageBox::Cancel | QMessageBox::Escape );
	switch( mb.exec() ) {
	    case QMessageBox::Yes   : if (!fileSave()) return TRUE;
	    case QMessageBox::No    : return TRUE;
            case QMessageBox::Cancel: return FALSE;
        }
    }
   
   return TRUE;  
}


void MainWindow::SaveSettings()
{
    QSettings settings;
    
    settings.writeEntry( "/QTEDIT/Locale/EasyConfig"        , config.IsEasyConfig );
    if (!config.IsEasyConfig)
	settings.writeEntry( "/QTEDIT/Locale/Encoding", GetDefaultCodec()->name() );
    else{
	if (MyCodecList[config.EasyConfig].Encoding.isEmpty())
	    settings.writeEntry( "/QTEDIT/Locale/Encoding", "SYSTEM_LOCALE" );
	else
	    settings.writeEntry( "/QTEDIT/Locale/Encoding", MyCodecList[config.EasyConfig].CodecName );
    }
    
    
    settings.writeEntry( "/QTEDIT/Editor/EditorFont"        , config.EditorFontName );    
    if (EditorFileName.isEmpty())
	settings.removeEntry ("/QTEDIT/Editor/FileLoaded");
    else 
	settings.writeEntry( "/QTEDIT/Editor/FileLoaded", EditorFileName );    
    
    settings.writeEntry( "/QTEDIT/EditorOptions/WordWrap"   , config.WordWrap );
    settings.writeEntry( "/QTEDIT/EditorOptions/AutoSave"   , config.AutoSave );
    settings.writeEntry( "/QTEDIT/EditorOptions/MakeBackUps", config.MakeBackUp );
    settings.writeEntry( "/QTEDIT/EditorOptions/BackUpStyle", config.BackUpType  );
}



void MainWindow::LoadSettings()
{
    QSettings settings;
    QString s;
    
    config.IsEasyConfig = settings.readBoolEntry( "/QTEDIT/Locale/EasyConfig", true );
    if (!config.IsEasyConfig){
	QString name = settings.readEntry( "/QTEDIT/Locale/Encoding" );
	config.AdvancedConfig = CodecList->findNext( QTextCodec::codecForName(name));
	if (config.AdvancedConfig==-1) {
	    qDebug("Codec not found, reveting to system default");
	    config.IsEasyConfig = true;
	    config.EasyConfig   = 0;
	}
    }
    else
	config.EasyConfig = GetIndexOfCodecName( settings.readEntry( "/QTEDIT/Locale/Encoding" ) );
    
    config.EditorFontName = settings.readEntry( "/QTEDIT/Editor/EditorFont" );
    
    config.WordWrap   = settings.readBoolEntry( "/QTEDIT/EditorOptions/WordWrap"   , false );
    config.AutoSave   = settings.readBoolEntry( "/QTEDIT/EditorOptions/AutoSave"   , false );
    config.MakeBackUp = settings.readBoolEntry( "/QTEDIT/EditorOptions/MakeBackUps", false );
    config.BackUpType = settings.readNumEntry ( "/QTEDIT/EditorOptions/BackUpStyle", 999   );
    
    s = settings.readEntry( "/QTEDIT/Editor/FileLoaded" );
    if (!s.isEmpty()) 
	LoadBuffer( s );
}

void MainWindow::ApplySettings()
{
   // set the new font to the editor
   QFont newfont = QFont();
   newfont.fromString( config.EditorFontName  );   
   TextEditor->setFont( newfont );
      
   // set some options to the editor
   if (config.WordWrap)
       TextEditor->setWordWrap( QTextEdit::WidgetWidth );
   else
       TextEditor->setWordWrap( QTextEdit::NoWrap );
}
