/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <qmessagebox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qtextedit.h>


void ReplaceDialog::DoSearchReplace(bool ReplaceAll)
{
   if (!TheEditor) 
       return;
   
   if (!TheEditor->find ( FindText->text(), 
			  CaseCheck->isOn(), 
			  WordsCheck->isOn(), 
			  ForwardRadio->isOn()
                          /*, int * para = 0, int * index = 0 */)) {
       QMessageBox::information( this, "Search failed", "The text was not found." );
       return;
   }
   
   // first found, great...
   FromCursorCheck->setChecked( true );                   
   
   if (ReplaceAll){
       hide();
       bool found = true;
       int  count = 1;
       
       // replace all the instances of this string
       // without asking the user
       while (found){
	   TheEditor->insert( ReplaceText->text() , FALSE, FALSE );
           found = TheEditor->find ( FindText->text(), 
			  CaseCheck->isOn(), 
			  WordsCheck->isOn(), 
			  ForwardRadio->isOn()
                          /*, int * para = 0, int * index = 0 */);
	   count ++;
       }
       QMessageBox::information( this, "Search replace",
	 QString("Text replaced %1 times.").arg(count) ); 
       close();
   }
   else{
       TheEditor->insert( ReplaceText->text() , FALSE, FALSE );
   }
    
}

void ReplaceDialog::SetTheEditor( QTextEdit *SomeEditor )
{
    TheEditor = SomeEditor;
}


void ReplaceDialog::SeacrhReplace()
{
    DoSearchReplace( false );
}

void ReplaceDialog::SeacrhReplaceAll()
{
    DoSearchReplace( true );
}
