/*
	  NOMBRE: ESTEBAN ANTONIO BADILLO MARTINEZ
	 MATERIA: GRAFICACION POR COMPUTADORA
	PROFESOR: EMANUEL HERNANDEZ HERNANDEZ
	PROGRAMA: GRAFICACION DE CIRCUNFERENCIAS
				 POR EL METODO DE BRESENHAM
*/


/*
		NOTA: Este programa est diseado para ser compilado bajo
				Turbo C++ 3.0 de Borland debido a que utiliza directivas
				del compilador para introducir instrucciones a bajo nivel
				para la manipulacion de la tarjeta de video bajo el
				estandar VESA.

*/

#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<time.h>

void pintapixel(int x, int y, char color);
void video320();
void circulo(int x_c, int y_c, int radio, char color);
void limpia();
char getcolor(int x, int y);
void floodfill(int x, int y, char colornuevo, char colorviejo);
void videotxt();
void pinta(int x_c, int y_c,int radio, char color);

void main()
{
	int i;
	int radio;
	char color;
	video320();
	srand((unsigned int)time(NULL));

	for(i=0;i<5;i++)
	{
		radio=rand()%50 + 10;
		color=rand()%250+5;
		circulo(160,100,radio, color);
		pinta(160,100,radio,color);
		getch();
		limpia();
	}
	videotxt();
}




/* ------------------------------------------------------
pintapixel(); Dibujo de pixels en Video Ram.
Pseudocodigo:
	OFFSET=(320*y)+x
	ES:DI=A000:OFFSET
	ES:[DI]=Color
-------------------------------------------------------*/
void pintapixel(int x, int y, char color)
{
	if((x>=0)&&(x<320)&&(y>=0)&&(y<200))
	{
		unsigned int offset_pixel;
		offset_pixel=(320*y) + x;

		asm PUSH AX
		asm PUSH ES
		asm PUSH DI
		asm MOV AX, 0xA000
		asm MOV ES, AX
		asm MOV DI, [offset_pixel]
		asm MOV AL, [color]
		asm MOV ES:[DI], AL
		asm POP DI
		asm POP ES
		asm POP AX
	}
}

/* ------------------------------------------------------
video320(); Ajuste del modo de video a 320 x 200 pixel
por medio de interrupciones del sistema (video int 10h,
servicio 00, opcion 13h -pantalla de 320 x 200 color
indexado-)
-------------------------------------------------------*/
void video320()
{
	asm PUSH AX
	asm MOV AX, 0x0013
	asm INT 0x10
	asm POP AX
}

void videotxt()
{
	asm PUSH AX
	asm MOV AX, 0x0003
	asm INT 0x10
	asm POP AX
}

void circulo(int x_c, int y_c, int radio, char color)
{
	/*los argumentos x_c, y_c se refieren a las
	coordenadas de el centro de nuestra circulo     */

	int i,fin;


	int d0, x, y;
	/*las coordenadas x,y se refieren a la ubicacion
	actual del trazado del punto en la pantalla.    */

	d0=1-radio;
	/*d0 se refiere al primer discriminante del
	algoritmo de Bresenham para trazado de circulos.*/


	x=0;
	y=radio;


	pintapixel(x_c,y_c+radio,color);
	pintapixel(x_c,y_c-radio,color);
	pintapixel(x_c+radio,y_c,color);
	pintapixel(x_c-radio,y_c,color);
	/*se pintan los pixeles que estan arriba y abajo del
	centro de nuestra circunferencia, asi como a los lados
	de la misma*/


	for(i=0;x<y;i++)
	{
		x++;
		if(d0<0)
		{
			d0 = d0 + 2 * x + 3;
			/*se calculan el discriminante para el movimiento
			  hacia el este  */
		}
		else
		{
			y--;
			d0 = d0 + 2 * ( x - y ) + 5;
			/*se calcula el discriminante para el movimiento
			  hacia el sureste*/
		}
		pintapixel(x_c+x,y_c+y,color);
		pintapixel(x_c+x,y_c-y,color);
		pintapixel(x_c-x,y_c+y,color),
		pintapixel(x_c-x,y_c-y,color);
		pintapixel(x_c+y,y_c+x,color);
		pintapixel(x_c+y,y_c-x,color);
		pintapixel(x_c-y,y_c+x,color),
		pintapixel(x_c-y,y_c-x,color);
			/*se aprovecha para pintar los puntos simetricos
			del punto calculado dentro del ciclo for y evitarnos
			calculos innecesarios*/


	}
}


/*-------------------------------------------------------------------
  esta funcion se utiliza para limpiar la pantalla grafica cuando
  se necesita pintar una nueva circunferencia. Se hace por medio
  del pintado de pixeles en color 0, el cual es negro en la pantalla
-------------------------------------------------------------------*/
void limpia()
{
	int x,y;
	for(x=0;x<320; x++)
	{
		for(y=0;y<200;y++)
			pintapixel(x,y,0);
	}
}

/*-----------------------------------------------------------------
  La funcion getcolor obtiene el color de un pixel en una ubicacion
  (x,y) de la pantalla
-----------------------------------------------------------------*/
char getcolor(int x, int y)
{
	char color;
	if((x>=0)&&(x<320)&&(y>=0)&&(y<200))
	{
		unsigned int offset_pixel;
		offset_pixel=(320*y) + x;
		asm PUSH AX
		asm PUSH ES
		asm PUSH DI
		asm MOV AX, 0xA000
		asm MOV ES, AX
		asm MOV DI, [offset_pixel]
		asm MOV AL, ES:[DI]
		asm MOV [color], AL
		asm POP DI
		asm POP ES
		asm POP AX
	}
	return(color);
}

/*---------------------------------------------------------------
  La funcion floodfill es la parte principal del rellenado de
  nuestro programa. Lo hace de manera recursiva, y para ello la
  figura se divide en 4 secciones previamente desde su trazado
  para evitar que el floodfill tenga problemas de desbordamiento
  de pila al momento de llamar a las funciones recursivas
----------------------------------------------------------------*/
void floodfill(int x, int y, char colornuevo, char colorviejo)
{
	if(getcolor(x,y)==colorviejo)
	{
		pintapixel(x,y,colornuevo);
		floodfill(x-1, y, colornuevo, colorviejo);
		floodfill(x+1, y, colornuevo, colorviejo);
		floodfill(x, y-1, colornuevo, colorviejo);
		floodfill(x, y+1, colornuevo, colorviejo);
	}
}

void pinta(int x_c,int y_c, int radio, char color)
{
	int i;
	for(i=0;i<(radio*2);i++)
	{
		pintapixel(x_c,y_c+i-radio,color);
		pintapixel(x_c+i-radio,y_c,color);
	}
	/*Se pintan lineas de extremo a extremo de la circunferencia*/
	/*para dividir la circunferencia en 4 partes y hacer el tra-
	  bajo de la funcion floodfill menos pesada y evitar
	  desbordamientos de pila al llamar a las funciones
	  recursivas */
	floodfill(159,99,color,0);
	floodfill(159,101,color,0);
	floodfill(161,99,color,0);
	floodfill(161,101,color,0);
}