/*Programa para obtener numeros primos, desde el 2 hasta el numero que el
  usuario indique. Cada numero primo se determinara con el residuo de sus
  numeros anteriores. Por ejemplo:

	Para determinar si 5 es primo, se comprobara el residuo de 5 entre
	2, 3 y 4.

	Para determinar si 20 es primo, se comprobara el residuo de 20 entre
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 y 19. Si
	hay alguno cuyo residuo de la division sea cero, este se verificara
	hasta que se haya terminado con todos los numeros.

	Y asi sucesivamente para cualquier numero que se desee.

	Este metodo requiere de la implementacion de dos ciclos anidados For.


  Autor: Esteban Antonio Badillo Martinez
  Ing. en Computacion
  Facultad de Ingenieria
  Universidad Nacional Autonoma de Mexico.

  Nombre del Programa: "MisPrimos"
  Version: 0.2
  Fecha: 28/Enero/2007

  Nota:
	
  Este programa fue una idea original de una tarea escolar de la
  materia Computadoras y Programacion (Plan de estudios 1996 de
  la carrera de Ing. en Computacion de la Facultad de Ingenieria
  de la UNAM. Originalmente pretendia ensear los primeros pasos
  dentro de la programacion a los alumnos en el lenguaje C, utili-
  zando estructuras de control simples, sin el conocimiento de
  estructuras de datos como las listas enlazadas y sin una buena
  planeacion para hacer el programa mas eficiente.

  Al tratar de calcular todos los numeros primos que hay entre el
  numero 2 hasta un numero muy grande (p. e. 30,000) el programa
  tardara bastante en determinar dichos numeros primos, ademas de
  que solo los muestra en la pantalla, sin almacenarlos en algun
  tipo de arreglo de memoria o estructura autorreferenciada
  (o estructura de datos).

  Al entender el funcionamiento de una estructura de datos como
  una lista ligada o lista enlazada, se penso en mejorar este
  programa, haciendo uso del concepto de descomposicion en factores
  primos de cualquier numero y almacenar dichos numeros en una
  estructura de datos para agilizar la posterior obtencion de otros
  numeros primos.

  Este programa ("MisPrimos") esta acompaado de su version mejorada
  llamado "MisPrimosMejorado", el cual agiliza la obtencion de
  numeros primos con la utilizacion de una lista enlazada ya antes
  mencionada.

*/

#include <stdio.h>
#include <stdlib.h>

void main(void)
{
	int i=0, j=0, k=0;
	int NumEntrada=0;
	int CuentaPrimos=0;
	int Residuo=1;

	printf("Programa disque para obtener numeros primos\n"
	       "De antemano sabemos que 2 es primo, por lo tanto\n"
	       "se agregan 2 a la lista de numeros primos:\n\n"
	       "Hasta que numero deseas determinar si hay primos? ");
	
	scanf("%d",&NumEntrada);


	for(i=2; i<=NumEntrada; i++){
		//printf("Para %d:\n",i);
		for(j=2, k=0; j<i; j++){
			Residuo = i % j;
			//printf("  Residuo de %d / %d es: %d\n", i, j, Residuo);
			if(Residuo == 0)
				k = 1;
		}
		if(k==0){
			printf("Primo: %d\n", i);
			CuentaPrimos++;
		}
	}
	printf("Total de numeros primos obtenidos: %d\n\n", CuentaPrimos);
}
