/*Programa para obtener numeros primos, desde el 2 hasta el numero que el
  usuario indique. El programa almacena los numeros primos obtenidos a lo
  largo de su ejecucion en una lista ligada. Esta lista ligada tendra solo
  numeros primos y se utilizaran los valores almacenados en dicha lista
  para determinar la existencia de otros numeros primos y descartar
  aquellos numeros que no sean primos.

  Autor: Esteban Antonio Badillo Martinez
  Ing. en Computacion
  Facultad de Ingenieria
  Universidad Nacional Autonoma de Mexico.

  Nombre del Programa: "MisPrimosMejorado"
  Version: 0.2
  Fecha: 28/Enero/2007

  Nota:

  Este programa es una version mejorada de otro llamado "MisPrimos". Ofrece
  una forma mas eficiente en cuanto a la obtencion de un listado de numeros
  primos. El programa original (MisPrimos) fue hecho como un ejercicio de
  clase de la materia Computadoras Y Programacion del plan de estudios 1996
  de la carrera de Ingenieria en Computacion de la Facultad de Ingenieria
  de la Universidad Nacional Autonoma de Mexico.

  En su momento, la solucion propuesta al problema planteado en clase (la
  obtencion de un listado de numeros primos) y cuyo codigo se presenta en el
  codigo de "MisPrimos.c", era muy lento al tratar de obtener el listado
  de los numeros primos que hay entre el 2 y un numero muy grande como
  30,000. Al ser este un ejercicio del segundo semestre de la carrera, no
  hubo mucho disenio en su solucion, limitandose a utilizar simples
  estructuras de control vistas en cualquier curso de programacion
  estructurada (en este caso, con el lenguaje C). Posteriormente, al aprender
  el uso de las estructuras autorreferenciadas (o estructuras de datos) se
  decidio hacer mas eficiente el programa, guardando en una lista ligada
  los numeros que se vayan determinando en cada caso, para ayudar a la
  obtencion de otros numeros primos mayores, eliminando asi una gran
  cantidad de calculos innecesarios que tenia el programa original.

  La idea de este programa es que cualquier numero x que no es primo se puede
  descomponer en sus factores primos. Por lo tanto, cualquier numero x tiene que
  ser evaluado con un listado de numeros primos ya previamente obtenidos y
  almacenados en la lista enlazada ya antes mencionada. Si el residuo de la
  division del numero x con un numero primo de la lista enlazada es igual a cero
  entonces el numero x es considerado como no primo, por lo tanto, se descarta
  automaticamente y no es almacenado en la lista enlazada.
*/

#include <stdio.h>
#include <stdlib.h>

struct Primo{
	struct Primo *PtrSigPrimo;
	int NumPrimo;
};

typedef struct Primo PRIMO;
typedef PRIMO *PRIMOPTR;

void AgregaPrimo(PRIMOPTR *, int);
void EliminaPrimos(PRIMOPTR *);
void MuestraPrimos(PRIMOPTR);
int EsPrimo(PRIMOPTR, int);

void main(void)
{
	PRIMOPTR MisPrimos=NULL;
	int i=0, k=0;
	int NumEntrada=0;
	int CuentaPrimos=1;

	printf("Programa disque para obtener numeros primos\n"
	       "De antemano sabemos que 2 es primo, por lo tanto\n"
	       "se agregan 2 a la lista de numeros primos:\n\n"
	       "Hasta que numero deseas determinar si hay primos? ");
	
	scanf("%d",&NumEntrada);

	AgregaPrimo(&MisPrimos,2);
	for(i=3; i<=NumEntrada; i++){

		k = EsPrimo(MisPrimos, i);
		if(k!=0){
			AgregaPrimo(&MisPrimos, i);
			CuentaPrimos++;
		}
	}
	printf("Total de numeros primos obtenidos: %d\n\n", CuentaPrimos);
	MuestraPrimos(MisPrimos);
	printf("Total de numeros primos obtenidos: %d\n\n", CuentaPrimos);
	
	/*Al final, se deshace de tooooda la lista de primos*/
	EliminaPrimos(&MisPrimos);
	
	free(MisPrimos);
		
}

void AgregaPrimo(PRIMOPTR *PtrListaPrimos, int Numero)
{
	PRIMOPTR PtrCurPrimo;
	PRIMOPTR PtrNewPrimo;
	PRIMOPTR PtrPrvPrimo;

	PtrNewPrimo = (PRIMOPTR)malloc(sizeof(PRIMO));

	if(PtrNewPrimo != NULL){	/*Hay espacio disponible en memoria*/
		PtrNewPrimo->NumPrimo = Numero;
		PtrNewPrimo->PtrSigPrimo = NULL;
		
		PtrPrvPrimo=NULL;
		PtrCurPrimo = *PtrListaPrimos;
			
		while(PtrCurPrimo != NULL){
			PtrPrvPrimo = PtrCurPrimo;
			PtrCurPrimo = PtrCurPrimo->PtrSigPrimo;
		}
		
		if( PtrPrvPrimo == NULL ){
			PtrNewPrimo->PtrSigPrimo = *PtrListaPrimos;
			*PtrListaPrimos = PtrNewPrimo;
		}
		else{
			PtrPrvPrimo->PtrSigPrimo = PtrNewPrimo;
			PtrNewPrimo->PtrSigPrimo = PtrCurPrimo;
		}
			
	}
	else
		printf("No se puede agregar el numero %d. No hay suficiente memofia", Numero);
	
}

void EliminaPrimos(PRIMOPTR *PtrListaPrimos)
{
	PRIMOPTR PtrTmpPrimo=NULL;
	PtrTmpPrimo=*PtrListaPrimos;
	while(PtrTmpPrimo != NULL){
		(*PtrListaPrimos)=PtrTmpPrimo->PtrSigPrimo;
		free(PtrTmpPrimo);
		PtrTmpPrimo=(*PtrListaPrimos);
	}
	printf("La lista esta vacia\n\n");
}

void MuestraPrimos(PRIMOPTR PtrListaPrimos)
{
	if(PtrListaPrimos==NULL)
		printf("La lista esta vacia\n\n");
	else{
		printf("La lista de primos es:\n");

		while(PtrListaPrimos != NULL){
			printf("%d -> ", PtrListaPrimos->NumPrimo);
			PtrListaPrimos=PtrListaPrimos->PtrSigPrimo;
		}
		printf("FIN\n\n");
	}
}

int EsPrimo(PRIMOPTR PtrListaPrimos, int Numero)
{
	int Residuo=1, Primo=0;
	
	/*printf("Numeros evaluados para %d:\n", Numero);*/

	while( (PtrListaPrimos != NULL) && (Residuo) ){		
			/*Obtiene el residuo de la division entera*/
			Primo = PtrListaPrimos->NumPrimo;
			Residuo = Numero % Primo;

			/*Pasa al siguiente primo*/
			PtrListaPrimos=PtrListaPrimos->PtrSigPrimo;

			/*printf("  Residuo de %d / %d es %d\n", Numero, Primo, Residuo);*/
	}
	
	if(Residuo!=0)
		return 1; /*Verdadero, si es primo*/
	else
		return 0; /*Falso, no es primo*/
}
