/*-----------------------------------------------------------------
*  FlowClockApp 1.0.
*  Author:  Ivan 'MCG' Boldyrev <bii714@cclib.nsu.ru>
*      http://members.tripod.com/~ivan_mcg/    (Eng)
*      http://www.halyava.ru/applet            (Rus)
*------------------------------------------------------------------
*   This is a last comment in this file. I have no own computer,
* and I have no time to comment my programs. I am sorry.
*----------------------------------------------------------------*/


import java.awt.*;
import java.util.*;

final public class GrimaceClockApp extends java.applet.Applet implements Runnable
{  volatile boolean md, over;
   long startTime=System.currentTimeMillis()<<1;
   int drawMode, countMode;
   Image buff;
   Dimension oldSz;
   Color fore, back, shad, high, low;
   int nl=0;
   final int [][] destx=new int[6][8],
          desty=new int[6][8],
          signx=new int[6][8],
          signy=new int[6][8],
          currx=new int[6][8],
          curry=new int[6][8],
          stepx=new int[6][8],
          stepy=new int[6][8];
   final int[] vdisp=new int[6], vdest=new int[6], vsign=new int[6], vstep=new int[6];

   static final protected int font[]={ 0x3F, 0x18, 0x76, 0x7C, 0x59, 0x6D, 0x6F, 0x38, 0x7F, 0x7D };
   static Random rnd=new Random();

   public String getAppletInfo()
   {  return "GrimaceClock v1.0. Author: Ivan Boldyrev <bii714@cclib.nsu.ru>\n"
         +"http://members.tripod.com/~ivan_mcg\t(Eng)\n"
         +"http://www.halyava.ru/applet\t\t(Rus)";
   }

   final void drawDigit(Graphics gr, int n, int x, int y, int s)
   {  int p1, p2;
      gr.translate(0, vdisp[p1=nl++]);
      drawSymbol(gr, font[n/10], x, y, s, fore, high, null,
            (drawMode>>4)&0x0F, p1);
      drawSymbol(gr, font[n/10]^0xFF, x, y, s, shad, null, low,
            (drawMode>>8)&0x0F, p1);
      gr.translate(0, -vdisp[p1]);
      gr.translate(0, vdisp[p2=nl++]);
      drawSymbol(gr, font[n%10], x+s+(s>>1), y, s, fore, high, null,
            (drawMode>>4)&0x0F, p2);
      drawSymbol(gr, font[n%10]^0xFF, x+s+(s>>1), y, s, shad, null, low,
            (drawMode>>8)&0x0F, p2);
      gr.translate(0, -vdisp[p2]);
   }

   final void drawSymbol(Graphics gr, int map, int x1, int y1, int h,
         Color n, Color hi, Color lo, int md, int nl)
   {  int d=h>>3, r=(d>>1)+(d>>2), x2, x3;
      int [] xx=currx[nl], yy=curry[nl];
      switch(drawMode & 0x0F)
      {  default:
         case 0:
            x3=x2=x1;
            break;
         case 1:
            x2=x1+d;
            x3=x1-d;
            break;
         case 2:
            x3=x2=x1+(h>>2);
            break;
         case 3:
            x3=x2=x1-(h>>2);
            break;
      }

      for (int count=0; map!=0; ++count, map>>=1)
      {  gr.setColor(n);
         if ((map&1) != 0)
            switch (count)
            {  case 0:
                  drawVLine(gr, x2+xx[0], y1+yy[0], x1+xx[1], y1+h+yy[1], d, hi, lo, md);
                  break;
               case 1:
                  drawVLine(gr, x1+xx[1], y1+h+yy[1], x3+xx[2], y1+h+h+yy[2], d, hi, lo, md);
                  break;
               case 2:
                  drawHLine(gr, x3+xx[2], y1+h+h+yy[2], x3+h+xx[3], y1+h+h+yy[3], d, hi, lo, md);
                  break;
               case 3:
                  drawVLine(gr, x1+h+xx[4], y1+h+yy[4], x3+h+xx[3], y1+h+h+yy[3], d, hi, lo, md);
                  break;
               case 4:
                  drawVLine(gr, x2+h+xx[5], y1+yy[5], x1+h+xx[4], y1+h+yy[4], d, hi, lo, md);
                  break;
               case 5:
                  drawHLine(gr, x2+xx[0], y1+yy[0], x2+h+xx[5], y1+yy[5], d, hi, lo, md);
                  break;
               case 6:
                  drawHLine(gr, x1+xx[1], y1+h+yy[1], x1+h+xx[4], y1+h+yy[4], d, hi, lo, md);
            }
      }
      for (int i=0; i<8; ++i)
      {  if (signx[nl][i]*(xx[i]-destx[nl][i])>=0)
         {  int xn=(int)(r*rnd.nextGaussian());
            destx[nl][i]=xn;
            signx[nl][i]=sign(xn-xx[i]);
            stepx[nl][i]=signx[nl][i]*(((int)(Math.abs(r*rnd.nextGaussian()))>>2)+1);
         }
         if (signy[nl][i]*(yy[i]-desty[nl][i])>=0)
         {  int yn=(int)(r*rnd.nextGaussian());
            desty[nl][i]=yn;
            signy[nl][i]=sign(yn-yy[i]);
            stepy[nl][i]=signy[nl][i]*(((int)(Math.abs(r*rnd.nextGaussian()))>>2)+1);
         }
     }
  }

   final private void drawVLine(Graphics gr, int x1, int y1, int x2, int y2, int d,
         Color hi, Color lo, int mode)
   {  int s=(y2-y1)>>3;
      final int[] xp=new int[7], yp=new int[7];
      xp[6]=xp[0]=x1; yp[6]=yp[0]=y1+s;
      xp[1]=x1-d; yp[1]=y1+s+s;
      xp[2]=x2-d; yp[2]=y2-s-s;
      xp[3]=x2; yp[3]=y2;
      xp[4]=x2+d; yp[4]=y2-s-s;
      xp[5]=x1+d; yp[5]=y1+s+s;
      if (0 == mode)
      {  gr.fillPolygon(xp, yp, 6);
         gr.drawLine(xp[0], yp[0], xp[3], yp[3]);
      }
      else
         gr.drawPolygon(xp, yp, 7);
      if (null != hi)
      {  gr.setColor(hi);
         gr.drawLine(xp[0], yp[0], xp[1], yp[1]);
         gr.drawLine(xp[1], yp[1], xp[2], yp[2]);
      }
      if (null != lo)
      {  gr.setColor(lo);
         gr.drawLine(xp[3], yp[3], xp[4], yp[4]);
         gr.drawLine(xp[4], yp[4], xp[5], yp[5]);
      }
   }

   final static private void drawHLine(Graphics gr, int x1, int y1, int x2, int y2, int d,
         Color hi, Color lo, int mode)
   {  int s=(x2-x1)>>3;
      final int[] xp=new int[7], yp=new int[7];
      xp[6]=xp[0]=x1+s; yp[6]=yp[0]=y1;
      xp[1]=x1+s+s; yp[1]=y1+d;
      xp[2]=x2-s-s; yp[2]=y2+d;
      xp[3]=x2-s; yp[3]=y2;
      xp[4]=x2-s-s; yp[4]=y2-d;
      xp[5]=x1+s+s; yp[5]=y2-d;
      if (0==mode)
      {  gr.fillPolygon(xp, yp, 6);
         gr.drawLine(xp[0], yp[0], xp[3], yp[3]);
      }
      else
         gr.drawPolygon(xp, yp, 7);
      if (null != hi)
      {  gr.setColor(hi);
         gr.drawLine(xp[0], yp[0], xp[1], yp[1]);
         gr.drawLine(xp[1], yp[1], xp[2], yp[2]);
      }
      if (null != lo)
      {  gr.setColor(lo);
         gr.drawLine(xp[3], yp[3], xp[4], yp[4]);
         gr.drawLine(xp[4], yp[4], xp[5], yp[5]);
      }
   }

   public void start()
   {  fore=parceColor(getParameter("FORE"), Color.green);
      back=parceColor(getParameter("BACK"), Color.black);
      setForeground(fore);
      setBackground(back);
      shad=parceColor(getParameter("SHAD"), darkColor(fore, back));
      high=parceColor(getParameter("HIGH"), null);
      low=parceColor(getParameter("LOW"), null);
      try
      {  drawMode=Integer.parseInt(getParameter("MODE"), 16);
      }
      catch (Exception ex)
      {  drawMode=0;
      }
      String mod=getParameter("COUNTMODE");
      countMode=(mod!=null && mod.length()==1) ? mod.charAt(0)-'0' : 0;
      over=false;
      new Thread(this).start();
   }

   public void run()
   {  Graphics pen=getGraphics();
      boolean z;
      while (!over)
      {  update(pen);
         try
         {  Thread.sleep(60);
         }
         catch (InterruptedException ex)
         {  over=true;
            continue;
         }
         for (int n=0; n<6; ++n)
         {  vdisp[n]+=vstep[n];
            if (vsign[n]*(vdisp[n]-vdest[n])>=0)
            {  vdest[n]=(int)(rnd.nextGaussian()*4);
               vsign[n]=sign(vdest[n]-vdisp[n]);
               vstep[n]=vsign[n]*((int)Math.abs(rnd.nextGaussian()*2)+1);
            }
            for (int i=0; i<8; ++i)
            {  currx[n][i]+=stepx[n][i];
               curry[n][i]+=stepy[n][i];
            }
         }
      }
      pen.dispose();
   }

   public void stop()
   {  over=true;
   }

   public final void update(Graphics g)
   {  paint(g);
   }

   public final synchronized void paint(Graphics g)
   {  Dimension s=size();
      int h=Math.min(s.width/12, s.height/3);
      Date now;
      switch (countMode)
      {  default:
         case 0:
            now = new Date();
            break;
         case 1:
            now = new Date(startTime - System.currentTimeMillis());
            break;
      }
      if (buff==null || s.width!=oldSz.width || s.height!=oldSz.height)
      {  buff=createImage(s.width, s.height);
         oldSz=s;
         System.gc();
      }
      Graphics bGr=buff.getGraphics();
      bGr.setColor(getBackground());
      bGr.fillRect(0, 0, s.width, s.height);
      bGr.translate((oldSz.width-h*9)>>1, (oldSz.height-(h<<2))>>1);
      nl=0;
      drawDigit(bGr, now.getHours(), 0, h>>1, h);
      drawDigit(bGr, now.getMinutes(), 4*h, h>>1, h);
      drawDigit(bGr, now.getSeconds(), 7*h, h, (h>>1)+(h>>2));
      g.drawImage(buff, 0, 0, null);
      bGr.dispose();
   }

   final static private Color parceColor(String src, Color def)
   {  if (src==null || src.length()<2)
         return def;
      try
      {  if (src.charAt(0)=='#')
            return new Color(Integer.parseInt(src.substring(1), 16)
                  | 0xFF000000);
         else
         {  StringTokenizer stt=new StringTokenizer(src, " ;,");
            int res=0xFF;
            for (int i=0; i<3; ++i)
            {  res <<= 8;
               res |= Integer.parseInt(stt.nextToken());
            }
            return new Color(res);
         }
      }
      catch (Exception e)
      {  return def;
      }
   }

   final static Color darkColor(Color f, Color b)
   {  int dr=f.getRed()-b.getRed(), dg=f.getGreen()-b.getGreen(),
               db=f.getBlue()-b.getBlue();
      return new Color(b.getRed()+(dr>>2), b.getGreen()+(dg>>2),
            b.getBlue()+(db>>2));
   }

   final static int sign(int n)
   {  return (n>0) ? 1 : ((n<0) ? -1 : 0);
   }
}
