/*-----------------------------------------------------------------
*  WaveClockApp 1.0.
*  Author:  Ivan 'MCG' Boldyrev <bii714@cclib.nsu.ru>
*	http://members.tripod.com/~ivan_mcg/    (Eng)
*       http://www.halyava.ru/applet            (Rus)
*------------------------------------------------------------------
*   This is a last comment in this file. I have no own computer,
* and I have no time to comment my programs. I am sorry.
*----------------------------------------------------------------*/

import java.awt.*;
import java.util.Date;
import java.util.StringTokenizer;

final public class WaveClockApp extends java.applet.Applet implements Runnable
{  volatile boolean md, over;
   long startTime=System.currentTimeMillis()<<1;
   int drawMode, countMode;
   Image buff;
   Dimension oldSz;
   Color fore, shad, high, low, back;
   int dateVSize;
   volatile double alpha;
   volatile Date time=new Date();

   public String getAppletInfo()
   {  return "WaveClock v1.0. Author: Ivan Boldyrev <bii714@cclib.nsu.ru>\n"
         +"http://members.tripod.com/~ivan_mcg\t(Eng)\n"
         +"http://www.halyava.ru/applet\t\t(Rus)";
   }

   private static final int font[]={ 0x3F, 0x18, 0x76, 0x7C, 0x59, 0x6D, 0x6F, 0x38, 0x7F, 0x7D };

   private static final String days[]={ "Sun", "Mon", "Tue", "Wed", "Thi", "Fri",
         "Sat" };

   private static final int PERIOD=1456;

   final void drawDigit(Graphics gr, int n, int x, int y, int s)
   {  drawSymbol(gr, font[n/10], x, y, s, fore, high, null,
            drawMode&0x0F);
      drawSymbol(gr, font[n%10], x+s+(s>>1), y, s, fore, high, null,
            drawMode&0x0F);
      drawSymbol(gr, font[n/10]^0xFF, x, y, s, shad, null, low,
            (drawMode>>4)&0x0F);
      drawSymbol(gr, font[n%10]^0xFF, x+s+(s>>1), y, s, shad, null, low,
            (drawMode>>4)&0x0F);
   }

   final void drawSymbol(Graphics gr, int map, int x, int y, int h,
         Color n, Color hi, Color lo, int md)
   {  int d, x2, x3, r;
      r=h>>2;
      x3=x+(int)(r*Math.sin(alpha-1.1));
      x2=x+(int)(r*Math.sin(alpha)*.7);
      x+=(int)(r*Math.sin(alpha-0.4)*.9);

      for (int count=0; map!=0; ++count, map>>=1)
      {  gr.setColor(n);
         if ((map&1) != 0)
            switch (count)
            {  case 0:
                  drawVLine(gr, x2, y, x, h, hi, lo, md);
                  break;
               case 1:
                  drawVLine(gr, x, y+h, x3, h, hi, lo, md);
                  break;
               case 2:
                  drawHLine(gr, x3, y+h+h, h, hi, lo, md);
                  break;
               case 3:
                  drawVLine(gr, x+h, y+h, x3+h, h, hi, lo, md);
                  break;
               case 4:
                  drawVLine(gr, x2+h, y, x+h, h, hi, lo, md);
                  break;
               case 5:
                  drawHLine(gr, x2, y, h, hi, lo, md);
                  break;
               case 6:
                  drawHLine(gr, x, y+h, h, hi, lo, md);
            }
      }
   }

   final private void drawVLine(Graphics gr, int x1, int y, int x2, int h,
         Color hi, Color lo, int mode)
   {  int d=h>>3;
      int yy=y+d, hh=h-d-d;
      int[] xp=new int[7], yp=new int[7];
      xp[6]=xp[0]=x1; yp[6]=yp[0]=yy;
      xp[1]=x1-d; yp[1]=yy+d;
      xp[2]=x2-d; yp[2]=yy+hh-d;
      xp[3]=x2; yp[3]=yy+hh;
      xp[4]=x2+d; yp[4]=yy+hh-d;
      xp[5]=x1+d; yp[5]=yy+d;
      if (0 == mode)
      {  gr.fillPolygon(xp, yp, 6);
         gr.drawLine(xp[0], yp[0], xp[3], yp[3]);
      }
      else
         gr.drawPolygon(xp, yp, 7);
      if (null != hi)
      {  gr.setColor(hi);
         gr.drawLine(xp[0], yp[0], xp[1], yp[1]);
         gr.drawLine(xp[1], yp[1], xp[2], yp[2]);
      }
      if (null != lo)
      {  gr.setColor(lo);
         gr.drawLine(xp[3], yp[3], xp[4], yp[4]);
         gr.drawLine(xp[4], yp[4], xp[5], yp[5]);
      }
   }

   final static private void drawHLine(Graphics gr, int x, int y, int w,
         Color hi, Color lo, int mode)
   {  int d=w>>3;
      int xx=x+d, ww=w-d-d;
      int[] xp=new int[7], yp=new int[7];
      xp[6]=xp[0]=xx; yp[6]=yp[0]=y;
      xp[1]=xx+d; yp[1]=y-d;
      xp[2]=xx+ww-d; yp[2]=y-d;
      xp[3]=xx+ww; yp[3]=y;
      xp[4]=xx+ww-d; yp[4]=y+d;
      xp[5]=xx+d; yp[5]=y+d;
      if (0==mode)
      {  gr.fillPolygon(xp, yp, 6);
         gr.drawLine(xp[0], yp[0], xp[3], yp[3]);
      }
      else
         gr.drawPolygon(xp, yp, 7);
      if (null != hi)
      {  gr.setColor(hi);
         gr.drawLine(xp[0], yp[0], xp[1], yp[1]);
         gr.drawLine(xp[1], yp[1], xp[2], yp[2]);
      }
      if (null != lo)
      {  gr.setColor(lo);
         gr.drawLine(xp[3], yp[3], xp[4], yp[4]);
         gr.drawLine(xp[4], yp[4], xp[5], yp[5]);
      }
   }

   public void init()
   {  Font f=new Font("Courier", Font.BOLD, 20);
      FontMetrics fm=getFontMetrics(f);
      dateVSize=10+fm.getHeight();
      setFont(f);
   }


   public void start()
   {  fore=parceColor(getParameter("FORE"), Color.green);
      back=parceColor(getParameter("BACK"), Color.black);
      shad=parceColor(getParameter("SHAD"), darkColor(fore, back));
      high=parceColor(getParameter("HIGH"), null);
      low=parceColor(getParameter("LOW"), null);
      try
      {  drawMode=Integer.parseInt(getParameter("MODE"), 16);
      }
      catch (Exception ex)
      {  drawMode=0;
      }
      String mod=getParameter("COUNTMODE");
      countMode=(mod!=null && mod.length()==1) ? mod.charAt(0)-'0' : 0;
      (new Thread(this)).start();
   }

   public void run()
   {  Graphics gr=getGraphics();
      long old=System.currentTimeMillis();
      over=false;
      time=new Date();
      try
      {  while (!over)
         {  long tm=System.currentTimeMillis();
            int per=(int)(tm%PERIOD);
            int ms=(int)(tm%1000);
            if ((tm-=ms)-old>=1000)
            {  old=tm;
               switch (countMode)
               {  default:
                  case 0:
                     time = new Date();
                     break;
                  case 1:
                     time = new Date(startTime - System.currentTimeMillis());
                     break;
               }
            }
            md=650<ms;
            alpha=per*2.*Math.PI/PERIOD;
            paint(gr, time);
            Thread.yield();
         }
      }
      finally
      {  gr.dispose();
      }
   }

   public void stop()
   {  over=true;
   }

   public void update(Graphics g)
   {  paint(g, time);
   }

   public void paint(Graphics g)
   {  paint(g, time);
   }

   public void paint(Graphics g, Date now)
   {  Dimension s=size();
      int h=Math.min(s.width/12, s.height/3);
      if (buff==null || s.width!=oldSz.width || s.height!=oldSz.height)
      {  buff=null;
         System.gc();
         buff=createImage(s.width, s.height);
         oldSz=s;
      }
      Graphics bGr=buff.getGraphics();
      bGr.setColor(back);
      bGr.fillRect(0, 0, s.width, s.height);
      String day=days[now.getDay()];
      if (null != high)
      {  bGr.setColor(high);
         bGr.drawString(day, 9, dateVSize-6);
      }
      bGr.setColor(fore);
      bGr.drawString(day, 10, dateVSize-5);
      bGr.translate((oldSz.width-h*9)>>1, dateVSize);
      drawDigit(bGr, now.getHours(), 0, h>>1, h);
      drawDigit(bGr, now.getMinutes(), 4*h, h>>1, h);
      drawDigit(bGr, now.getSeconds(), 7*h, h, (h>>1)+(h>>2));
      g.drawImage(buff, 0, 0, null);
      bGr.dispose();
   }

   final static private Color parceColor(String src, Color def)
   {  if (src==null || src.length()<2)
         return def;
      try
      {  if (src.charAt(0)=='#')
            return new Color(Integer.parseInt(src.substring(1), 16)
                  | 0xFF000000);
         else
         {  StringTokenizer stt=new StringTokenizer(src, " ;,");
            int res=0xFF;
            for (int i=0; i<3; ++i)
            {  res <<= 8;
               res |= Integer.parseInt(stt.nextToken());
            }
            return new Color(res);
         }
      }
      catch (Exception e)
      {  return def;
      }
   }

   final static Color darkColor(Color f, Color b)
   {  int dr=f.getRed()-b.getRed(), dg=f.getGreen()-b.getGreen(),
               db=f.getBlue()-b.getBlue();
      return new Color(b.getRed()+(dr>>2), b.getGreen()+(dg>>2),
            b.getBlue()+(db>>2));
   }
}
