function colorname(code) {
    if(code ~ "0") color = "Black"; else
    if(code ~ "1") color = "Navy"; else
    if(code ~ "2") color = "Green"; else
    if(code ~ "3") color = "Teal"; else
    if(code ~ "4") color = "Maroon"; else
    if(code ~ "5") color = "Purple"; else
    if(code ~ "6") color = "Olive"; else
    if(code ~ "7") color = "Silver"; else
    if(code ~ "8") color = "Gray"; else
    if(code ~ "9") color = "Blue"; else
    if(code ~ "[Aa]") color = "Lime"; else
    if(code ~ "[Bb]") color = "Aqua"; else
    if(code ~ "[Cc]") color = "Red"; else
    if(code ~ "[Dd]") color = "Fuchsia"; else
    if(code ~ "[Ee]") color = "Yellow"; else
    if(code ~ "[Ff]") color = "White"; else
}

function digit(c) {
    if(c ~ "0") k = 0; else
    if(c ~ "1") k = 1; else
    if(c ~ "2") k = 2; else
    if(c ~ "3") k = 3; else
    if(c ~ "4") k = 4; else
    if(c ~ "5") k = 5; else
    if(c ~ "6") k = 6; else
    if(c ~ "7") k = 7; else
    if(c ~ "8") k = 8; else
    if(c ~ "9") k = 9; else
    if(c ~ "[Aa]") k = 10; else
    if(c ~ "[Bb]") k = 11; else
    if(c ~ "[Cc]") k = 12; else
    if(c ~ "[Dd]") k = 13; else
    if(c ~ "[E]") k = 14; else
    if(c ~ "[Ff]") k = 15
    return k
}

function atoi(str) {
    k = 0
    for(i = 1; i <= length(str); i++) {
        c = substr(str, i, 1)
        k = k * 16 + digit(c)
    }
    return k;
}

BEGIN {
    print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">"
    print "<HTML>"
    print "<!-- Converted by ngs2html. http://members.tripod.com/Vitaly_Filatov -->"
    print "<HEAD>"
    print "<TITLE>"
    print title
    print "</TITLE>"
    printf("<META NAME=\"KEYWORDS\" CONTENT=\"%s\">\n", content)
    printf("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;")
    if(charset != "") printf(" charset=%s\">\n", charset); else print "\">"
    print "</HEAD>"
    print "<BODY>"
    if(basefontsize != 0) printf("<BASEFONT SIZE=\"%d\">\n", basefontsize)
    print "<PRE>"
}

/^!seealso:/ {
    print "<EM><B>"
    print "Seealso:"
    print "</B></EM>"
    print "<UL>"

    sub("^!seealso: ", "")

    while(length) {
      f2 = ""
      match($0, "\^[^ \t]*\.[nN][gG][oO]:\"[^\"]*\"[ \t]*")
      if(RLENGTH != -1) {
        item = substr($0, RSTART, RLENGTH)
        sub("[^:]*:.", "", item)
        sub(".[ \t]*$", "", item)
        file = substr($0, RSTART, RLENGTH)
        sub(":.*", "", file)
        sub(".[nN][gG][oO]", "", file)
        item1 = item;
        gsub("\\\\", "\\\\\\\\", item1)
        gsub("\\*", "\\*", item1)
        gsub("\\.", "\\.", item1)

        command=sprintf("grep \"^%s[^!]*!%s\" _ngxxx", file, item1)
#print command >> "../temp/aaa"
        command | getline f2
#print "<!--1:" command ":" f2 ":-->"
        sub("!.*$", "", f2)
        if(length(f2) == 0) f2 = file ".html"

          gsub("\\^\\^", "^", item)
          printf("<LI><A HREF=\"%s\"> %s </A></LI>\n", f2, item)

        } else {
          match($0, "\^[^ \t]*\.[nN][gG][oO]:[^ \t]*[ \t]*")
          if(RLENGTH != -1) {
            item = substr($0, RSTART, RLENGTH)
            sub("[^:]*:", "", item)
            file = substr($0, RSTART, RLENGTH)
            sub(":.*", "", file)
            sub(".[nN][gG][oO]", "", file);
            item1 = item;
            gsub("\\\\", "\\\\\\\\", item1)
            gsub("\\*", "\\*", item1)
            gsub("\\.", "\\.", item1)

            command=sprintf("grep \"^%s[^!]*!%s\" _ngxxx", file, item1)
#print command >> "../temp/aaa"
            command | getline f2
#print "<!--2:" command ":" f2 ":-->"
            sub("!.*$", "", f2)
            if(length(f2) == 0) f2 = file ".html"

              gsub("\\^\\^", "^", item)
              printf("<LI><A HREF=\"%s\"> %s </A></LI>\n", f2, item)


            } else {

              match($0, "\"[^\"]*\"[ \t]*")
              if(RLENGTH != -1) {
                item = substr($0, RSTART + 1, RLENGTH - 1)
                sub(".[ \t]*$", "", item)
                item1 = item;
                gsub("\\\\", "\\\\\\\\", item1)
                gsub("\\*", "\\*", item1)
                gsub("\\.", "\\.", item1)

                command=sprintf("grep \"^%s[^!]*!%s\" _ngxxx", procfile, item1)
#print command >> "../temp/aaa"
                command | getline f2
#print "<!--3:" command ":" f2 ":-->"
                sub("!.*$", "", f2)

                gsub("\\^\\^", "^", item)
                printf("<LI><A HREF=\"%s\"> %s </A></LI>\n", f2, item)

              } else {
                match($0, "[^ \t]*[ \t]*")
                if(RLENGTH != -1) {
                  item = substr($0, RSTART, RLENGTH)
                  item1 = item;
                  gsub("\\\\", "\\\\\\\\", item1)
                  gsub("\\*", "\\*", item1)
                  gsub("\\.", "\\.", item1)

                  command=sprintf("grep \"^%s[^!]*!%s\" _ngxxx", procfile, item1)
#print command >> "../temp/aaa"
                  command | getline f2
#print "<!--4:" command ":" f2 ":-->"
                  sub("!.*$", "", f2)

                  gsub("\\^\\^", "^", item)
                  printf("<LI><A HREF=\"%s\"> %s </A></LI>\n", f2, item)

              }
            }
          }
        }
      $0 = substr($0, RLENGTH + 1)
    }
    print "</UL>"
    next
}

{
    gsub("<", "\\&lt;")
    gsub(">", "\\&gt;")
    gsub("\\^\\^", "\\^\\^\\")
}

/^'/ {
    print "<!-- " $0 " -->"
}

/\^[Bb]/ {
    while(match($0, "\\^[Bb]") != 0) {
        r1 = sub("\\^[Bb]", "<B>")
        r2 = sub("\\^[Bb]", "</B>")
    }
    if(r1 + r2 == 1) sub("$", "</B>")
}

/\^[Uu]/ {
    while(match($0, "\\^[Uu]") != 0) {
        r1 = sub("\\^[Uu]", "<U>")
        r2 = sub("\\^[Uu]", "</U>")
    }
    if(r1 + r2 == 1) sub("$", "</U>")
}

/\^[Rr]/ {
    while(match($0, "\\^[Rr]") != 0) {
        r1 = sub("\\^[Rr]", "<EM>")
        r2 = sub("\\^[Rr]", "</EM>")
    }
    if(r1 + r2 == 1) sub("$", "</EM>")
}

/\^[Cc]/ {
    while(match($0, "\\^[Cc]..") != 0) {
        s = substr($0, RSTART+2, RLENGTH-2);
        k = atoi(s);
        if(k < 32) st = " "; else st = sprintf("&#%d;", k)
        sub("\\^[Cc]..", st)
    }
}

/\^[Aa]/ {
    while(match($0, "\\^[Aa]..") != 0) {
        colorname(substr($0, RSTART+2, 1)); background = color;
        colorname(substr($0, RSTART+3, 1)); foreground = color; 
        str = sprintf("<FONT COLOR=\"%s\">", foreground)
        sub("\\^[Aa]..", str)
    }
}

/\^[Nn]/ {
    while(match($0, "\\^[Nn]") != 0) {
        sub("\\^[Nn]", "</FONT>")
    }
}

{
    gsub("\\\\\\^\\\\\\^\\\\", "^")
    print $0
}

END {
    print "</PRE>"
    print "<HR>"
    print "<CENTER><FONT SIZE=-2>This page last updated on", date ,"</FONT><BR>"
    print "<CENTER><FONT SIZE=-2>Copyright &copy; 1992-2001, Vitaly Filatov, Moscow, Russia<BR>"
    print "<I><A HREF=\"mailto:vitaly@royint.com\">Webmaster</A></I></FONT></CENTER>"
    print "</BODY>"
    print "</HTML>"
}
