// CommentVisitor.cpp: Implementierung der Klasse CGCommentVisitor.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CommentVisitor.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CGCommentVisitor::CGCommentVisitor(CString spSearch)
{
	sSearch = spSearch;
}

CGCommentVisitor::~CGCommentVisitor()
{

}

// This is called for every "visit"
// Set m_Done to TRUE to "stay"
//
void CGCommentVisitor::Visit(CGItem &Item)
{	
	m_Done = FALSE;
	// get some information about the item
	BOOL bComment = Item.GetItemType () == kIT_Comment;
	CString sText = Item.GetTitle () + " " + Item.GetText ();

	// in this sample, we are searching for a
	// text in a comment only

	if (bComment && sText.Find (sSearch) > -1)
		m_Done = TRUE;
	
	CGVisitor::Visit (Item);
}
