unit GridFrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Editbtn, CellEdit, Fixselgd, Menus, ExtCtrls;

type
  TDemoForm = class(TForm)
    Button1: TButton;
    CellEdit1: TCellEdit;
    FixSelDrawGrid1: TFixSelDrawGrid;
    EditParameterMenu: TPopupMenu;
    test1: TMenuItem;
    Panel1: TPanel;
    HintLabel: TLabel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    FixSelDrawGrid2: TFixSelDrawGrid;
    WordWrapCheckBox: TCheckBox;
    FixSelDrawGrid3: TFixSelDrawGrid;
    FixStringGrid1: TFixStringGrid;
    procedure Button1Click(Sender: TObject);
    procedure FixSelDrawGrid1GetEditButtonType(Sender: TObject; ACol,
      ARow: Longint; var ButtonType: TEditButtonType);
    procedure FixSelDrawGrid1EditorStop(Sender: TObject; ACol,
      ARow: Longint; const Value: String; Confirmed: Boolean;
      var Valid: Boolean);
    procedure FixSelDrawGrid1GetEditText(Sender: TObject; ACol,
      ARow: Longint; var Value: OpenString);
    procedure FixSelDrawGrid1EditButtonClick(Sender: TObject; Col,
      Row: Longint);
    procedure FixSelDrawGrid1EditDownClick(Sender: TObject; Col,
      Row: Longint);
    procedure FixSelDrawGrid1EditUpClick(Sender: TObject; Col,
      Row: Longint);
    procedure FixSelDrawGrid1DrawCell(Sender: TObject; ACol, ARow,
      AColIndex, ARowIndex: Longint; ARect: TRect;
      AState: TFixSelGridDrawState);
    procedure FixSelDrawGrid1EditDropButtonClick(Sender: TObject; Col,
      Row: Longint);
    procedure EditParameterMenuClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FixSelDrawGrid1SetEditorProperties(Sender: TObject; ACol,
      ARow: Longint; var InplaceEditor: TCellInplaceEdit);
    procedure OnHint(Sender: TObject);
    procedure FixSelDrawGrid1SelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure FixSelDrawGrid1ExtDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean;
      Shift: TShiftState);
    procedure FixSelDrawGrid1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Label2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FixSelDrawGrid2MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FixSelDrawGrid2ExtDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean;
      Shift: TShiftState);
    procedure FixSelDrawGrid2DrawCell(Sender: TObject; ACol, ARow,
      AColIndex, ARowIndex: Longint; ARect: TRect;
      AState: TFixSelGridDrawState);
    procedure FixSelDrawGrid1ExtDragDrop(Sender, Source: TObject; X,
      Y: Integer; Shift: TShiftState);
    procedure FixSelDrawGrid2ExtDragDrop(Sender, Source: TObject; X,
      Y: Integer; Shift: TShiftState);
    procedure WordWrapCheckBoxClick(Sender: TObject);
    procedure FixSelDrawGrid3DrawCell(Sender: TObject; ACol, ARow,
      AColIndex, ARowIndex: Longint; ARect: TRect;
      AState: TFixSelGridDrawState);
    procedure FixSelDrawGrid1DblClick(Sender: TObject);
    procedure FixStringGrid1GetEditButtonType(Sender: TObject; ACol,
      ARow: Longint; var ButtonType: TEditButtonType);
    procedure FixStringGrid1SetEditorProperties(Sender: TObject; ACol,
      ARow: Longint; var InplaceEditor: TCellInplaceEdit);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;

implementation

var
  TestText: String;

{$R *.DFM}

{$R DemoCrs.res}

procedure TDemoForm.Button1Click(Sender: TObject);
begin
  if CellEdit1.EditButtonType = High(TEditButtonType) then
    CellEdit1.EditButtonType := Low(TEditButtonType)
  else
    CellEdit1.EditButtonType := Succ(CellEdit1.EditButtonType);
  if CellEdit1.EditButton <> nil then
    CellEdit1.EditButton.WordWrap := WordWrapCheckBox.Checked;
end;

procedure TDemoForm.FixSelDrawGrid1GetEditButtonType(Sender: TObject; ACol,
  ARow: Longint; var ButtonType: TEditButtonType);
begin
  ButtonType := CellEdit1.EditButtonType;
end;

procedure TDemoForm.FixSelDrawGrid1EditorStop(Sender: TObject; ACol,
  ARow: Longint; const Value: String; Confirmed: Boolean;
  var Valid: Boolean);
begin
  Valid := True;
  if Confirmed then
    try
      TestText := IntToStr(StrToInt(Value));
      FixSelDrawGrid1.Refresh;
    except
      MessageDlg('''' + Value + ''' is not an integer value.', mtError, [mbOk], 0);
      Valid := False;
    end;
end;

procedure TDemoForm.FixSelDrawGrid1GetEditText(Sender: TObject; ACol,
  ARow: Longint; var Value: OpenString);
begin
  Value := TestText;
end;

procedure TDemoForm.FixSelDrawGrid1EditButtonClick(Sender: TObject; Col,
  Row: Longint);
var
  Tst:  String;
begin
  Tst := FixSelDrawGrid1.InplaceEditor.Text;
  InputQuery('External input', 'Value:', Tst);
  FixSelDrawGrid1.InplaceEditor.Text := Tst;
end;

procedure TDemoForm.FixSelDrawGrid1EditDownClick(Sender: TObject; Col,
  Row: Longint);
begin
  FixSelDrawGrid1.InplaceEditor.Text := IntToStr(StrToInt(FixSelDrawGrid1.InplaceEditor.Text) - 1);
end;

procedure TDemoForm.FixSelDrawGrid1EditUpClick(Sender: TObject; Col,
  Row: Longint);
begin
  FixSelDrawGrid1.InplaceEditor.Text := IntToStr(StrToInt(FixSelDrawGrid1.InplaceEditor.Text) + 1);
end;

procedure TDemoForm.FixSelDrawGrid1DrawCell(Sender: TObject; ACol, ARow,
  AColIndex, ARowIndex: Longint; ARect: TRect;
  AState: TFixSelGridDrawState);
var
  Offset: Integer;
begin
  Offset := 0;
  with FixSelDrawGrid1 do
    if (ACol >= FixedCols) and (ACol < SelFixedCols + FixedCols) then
      Offset := GetSelFixScrollBarPosition(ACol - FixedCols);

  if sfgdFixed in AState then
    FixSelDrawGrid1.Canvas.TextRect(ARect, ARect.Left, ARect.Top,
      'Fixed (' + IntToStr(AColIndex) + ',' + IntToStr(ARowIndex) + ')')
  else
    FixSelDrawGrid1.Canvas.TextRect(ARect, ARect.Left - Offset, ARect.Top, TestText);
end;

procedure TDemoForm.FixSelDrawGrid1EditDropButtonClick(Sender: TObject; Col,
  Row: Longint);
var
  P:	TRect;
  procedure EditParamMenuAdd(const Caption: String);
  var
    MenuItem: TMenuItem;
  begin
    MenuItem := TMenuItem.Create(EditParameterMenu);
    MenuItem.Caption := Caption;
    MenuItem.OnClick := EditParameterMenuClick;
    EditParameterMenu.Items.Add(MenuItem);
  end;
begin
  with FixSelDrawGrid1 do
  begin
    P := CellRect(Col, Row);
    P.TopLeft := ClientToScreen(P.TopLeft);
    P.BottomRight := ClientToScreen(P.BottomRight);
  end;
  while EditParameterMenu.Items.Count > 0 do
	  EditParameterMenu.Items.Delete(0);
  EditParamMenuAdd('1111');
  EditParamMenuAdd('2222');
  EditParamMenuAdd('3333');
  EditParameterMenu.Popup(P.Left, P.Bottom);
end;

procedure TDemoForm.EditParameterMenuClick(Sender: TObject);
begin
  FixSelDrawGrid1.InplaceEditor.Text := TMenuItem(Sender).Caption;
end;

const
  crDragIn:	TCursor = 0;
  crDragInShift:	TCursor = 0;
  crDragInCtrl:	TCursor = 0;
  crDragInCtrlShift:	TCursor = 0;
  crDragOut:	TCursor = 0;
  crDragOutShift:	TCursor = 0;
  crDragOutCtrl:	TCursor = 0;
  crDragOutCtrlShift:	TCursor = 0;

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  Application.ShowHint := True;
  Application.OnHint := OnHint;
  TestText := '1234';
  FixSelDrawGrid1.SetSelFixScrollBarMinMax(0, 0, 25);

  crDragIn := TCursor(LoadCursor(HInstance, 'DRAG_IN'));
  Screen.Cursors[crDragIn] := HCursor(crDragIn);
  crDragInCtrl := TCursor(LoadCursor(HInstance, 'DRAG_IN_CTRL'));
  Screen.Cursors[crDragInCtrl] := HCursor(crDragInCtrl);
  crDragInShift := TCursor(LoadCursor(HInstance, 'DRAG_IN_SHIFT'));
  Screen.Cursors[crDragInShift] := HCursor(crDragInShift);
  crDragInCtrlShift := TCursor(LoadCursor(HInstance, 'DRAG_IN_CTRL_SHIFT'));
  Screen.Cursors[crDragInCtrlShift] := HCursor(crDragInCtrlShift);
  crDragOut := TCursor(LoadCursor(HInstance, 'DRAG_OUT'));
  Screen.Cursors[crDragOut] := HCursor(crDragOut);
  crDragOutShift := TCursor(LoadCursor(HInstance, 'DRAG_OUT_SHIFT'));
  Screen.Cursors[crDragOutShift] := HCursor(crDragOutShift);
  crDragOutCtrl := TCursor(LoadCursor(HInstance, 'DRAG_OUT_CTRL'));
  Screen.Cursors[crDragOutCtrl] := HCursor(crDragOutCtrl);
  crDragOutCtrlShift := TCursor(LoadCursor(HInstance, 'DRAG_OUT_CTRL_SHIFT'));
  Screen.Cursors[crDragOutCtrlShift] := HCursor(crDragOutCtrlShift);

  with FixSelDrawGrid1 do
  begin
    ExtDragCursor := TCursor(Screen.Cursors[crDragIn]);
    ExtDragCtrlCursor := TCursor(Screen.Cursors[crDragInCtrl]);
    ExtDragShiftCursor := TCursor(Screen.Cursors[crDragInShift]);
    ExtDragCtrlShiftCursor := TCursor(Screen.Cursors[crDragInCtrlShift]);

    ExtDragOutCursor := TCursor(Screen.Cursors[crDragOut]);
    ExtDragOutCtrlCursor := TCursor(Screen.Cursors[crDragOutCtrl]);
    ExtDragOutShiftCursor := TCursor(Screen.Cursors[crDragOutShift]);
    ExtDragOutCtrlShiftCursor := TCursor(Screen.Cursors[crDragOutCtrlShift]);
  end;

  with FixStringGrid1 do
  begin
    Cells[0, 0] := 'This';
    Cells[1, 0] := 'is';
    Cells[2, 0] := 'string';
    Cells[0, 1] := 'grid';
    Cells[1, 1] := 'based';
    Cells[2, 1] := 'on';
    Cells[0, 2] := 'the';
    Cells[1, 2] := 'TFixSel';
    Cells[2, 2] := 'DrawGrid';
  end;
end;

procedure TDemoForm.OnHint(Sender: TObject);
begin
  HintLabel.Caption := Application.Hint;
end;

procedure TDemoForm.FixSelDrawGrid1SetEditorProperties(Sender: TObject; ACol,
  ARow: Longint; var InplaceEditor: TCellInplaceEdit);
begin
  with InplaceEditor do
  begin
    ShowHint := True;
    case EditButtonType of
      etComboBox:
        begin
          if (InplaceEditor.ComboBox <> nil) then
          begin
            ComboBox.Items.Clear;
            ComboBox.Items.Add(Text);
            ComboBox.Items.Add('4444');
            ComboBox.Items.Add('5555');
            ComboBox.Items.Add('6666');
            ComboBox.ItemIndex := 0;
          end;
          Hint := 'Combo Box| Use Alt+Down to show items list. ' +
            'Enter/Esc to confirm/reject changes. ' +
            'This Combo Box supports all functionality of standard Combo Box.';
        end;
      etNone:
        Hint := 'Edit Box| Use Enter/Esc to confirm/reject changes. ' +
            'This Edit Box supports all functionality of standard Edit Box.';
      etButton:
        Hint := 'Edit Box with Button| Use Alt+Enter to call external dialog. ' +
            'Enter/Esc to confirm/reject changes. ' +
            'This Edit Box supports all functionality of standard Edit Box. ' +
            'The Button is customisable.';
      etSpin:
        Hint := 'Edit Box with Spin Button| Use Up/Down arrows to change value. ' +
            'Enter/Esc to confirm/reject changes. ' +
            'This Edit Box supports all functionality of standard Edit Box.';
      etDropButton:
        Hint := 'Edit Box with Drop Button| Use Alt+Down to show pop up menu. ' +
            'Enter/Esc to confirm/reject changes. ' +
            'This Edit Box supports all functionality of standard Edit Box. ' +
            'The Drop Button is customisable.';
    end;
    if EditButton <> nil then
      EditButton.WordWrap := WordWrapCheckBox.Checked;
  end;
end;

procedure TDemoForm.FixSelDrawGrid1SelectCell(Sender: TObject; Col,
  Row: Longint; var CanSelect: Boolean);
begin
  if (Col >= FixSelDrawGrid1.FixedCols) and
    (Col < FixSelDrawGrid1.SelFixedCols + FixSelDrawGrid1.FixedCols) then
    FixSelDrawGrid1.Hint := '| Selectable fixed column. ' +
      'Use Ctrl+Left/Right to scroll content. Use F2 to edit cell.'
  else
    if (Row >= FixSelDrawGrid1.FixedRows) and
      (Row < FixSelDrawGrid1.SelFixedRows + FixSelDrawGrid1.FixedRows) then
      FixSelDrawGrid1.Hint := '| Selectable fixed row. Use F2 to edit cell.'
    else
      FixSelDrawGrid1.Hint := '| Selectable movable cell. Use F2 to edit cell.';
end;

procedure TDemoForm.FixSelDrawGrid1ExtDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean; Shift: TShiftState);
begin
  Accept := True;
  FixSelDrawGrid1.Hint := '| Custimizeable drag cursor. ' +
    'Use Ctrl/Shift or Stlr+Shift to modify the cursor.';
end;

procedure TDemoForm.FixSelDrawGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
	Col:	Longint;
  Row:	Longint;
begin
  if Button = mbLeft then
  begin
  	FixSelDrawGrid1.MouseToCell(X, Y, Col, Row);
    if (Row >= FixSelDrawGrid1.FixedRows) and (Row < FixSelDrawGrid1.RowCount - 1) and
       (Col >= FixSelDrawGrid1.FixedCols) and (Col < FixSelDrawGrid1.ColCount - 1) then
    begin
	    FixSelDrawGrid1.ExtBeginDrag(False, X, Y);
    end;
  end;
end;

procedure TDemoForm.Label2DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := True;
end;

procedure TDemoForm.FixSelDrawGrid2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
	Col:	Longint;
  Row:	Longint;
begin
  if Button = mbLeft then
  begin
  	FixSelDrawGrid2.MouseToCell(X, Y, Col, Row);
    if (Row >= FixSelDrawGrid2.FixedRows) and (Row < FixSelDrawGrid2.RowCount - 1) and
       (Col >= FixSelDrawGrid2.FixedCols) and (Col < FixSelDrawGrid2.ColCount - 1) then
    begin
	    FixSelDrawGrid2.ExtBeginDrag(False, X, Y);
    end;
  end;
end;

procedure TDemoForm.FixSelDrawGrid2ExtDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean; Shift: TShiftState);
begin
  Accept := True;
  FixSelDrawGrid2.Hint := '| Custimizeable drag cursor. ' +
    'Use Ctrl/Shift or Stlr+Shift to modify the cursor.';
end;

procedure TDemoForm.FixSelDrawGrid2DrawCell(Sender: TObject; ACol, ARow,
  AColIndex, ARowIndex: Longint; ARect: TRect;
  AState: TFixSelGridDrawState);
begin
  if ARow = 0 then
  begin
    if ACol = 0 then
      FixSelDrawGrid2.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'Drag')
    else
      FixSelDrawGrid2.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'over me')
  end
  else
  begin
    if ACol = 0 then
      FixSelDrawGrid2.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'from the')
    else
      FixSelDrawGrid2.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'sample grid')
  end;
end;

procedure TDemoForm.FixSelDrawGrid1ExtDragDrop(Sender, Source: TObject; X,
  Y: Integer; Shift: TShiftState);
begin
  if (ssShift in Shift) and (ssCtrl in Shift) then
    MessageDlg('Internal drop with pressed Ctrl and Shift buttons.', mtInformation, [mbOk], 0)
  else if ssCtrl in Shift then
    MessageDlg('Internal drop with pressed Ctrl button.', mtInformation, [mbOk], 0)
  else if ssShift in Shift then
    MessageDlg('Internal drop with pressed Shift button.', mtInformation, [mbOk], 0)
  else
    MessageDlg('Internal drop without pressed Ctrl or Shift buttons.', mtInformation, [mbOk], 0);
end;

procedure TDemoForm.FixSelDrawGrid2ExtDragDrop(Sender, Source: TObject; X,
  Y: Integer; Shift: TShiftState);
begin
  if (ssShift in Shift) and (ssCtrl in Shift) then
    MessageDlg('External drop with pressed Ctrl and Shift buttons.', mtInformation, [mbOk], 0)
  else if ssCtrl in Shift then
    MessageDlg('External drop with pressed Ctrl button.', mtInformation, [mbOk], 0)
  else if ssShift in Shift then
    MessageDlg('External drop with pressed Shift button.', mtInformation, [mbOk], 0)
  else
    MessageDlg('External drop without pressed Ctrl or Shift buttons.', mtInformation, [mbOk], 0);
end;

procedure TDemoForm.WordWrapCheckBoxClick(Sender: TObject);
begin
  if CellEdit1.EditButton <> nil then
    CellEdit1.EditButton.WordWrap := WordWrapCheckBox.Checked;
  FixStringGrid1.WordWrap := WordWrapCheckBox.Checked;
  FixStringGrid1.Invalidate;
end;

procedure TDemoForm.FixSelDrawGrid3DrawCell(Sender: TObject; ACol, ARow,
  AColIndex, ARowIndex: Longint; ARect: TRect;
  AState: TFixSelGridDrawState);
begin
  if ARowIndex = 0 then
  begin
    if AColIndex = 0 then
      FixSelDrawGrid3.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'Look')
    else if AColIndex = 1 then
      FixSelDrawGrid3.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'at the IsPseudoCol')
    else
      FixSelDrawGrid3.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'property usage:');
  end
  else
  begin
    if AColIndex = 0 then
      FixSelDrawGrid3.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'On resizing of any')
    else if AColIndex = 1 then
      FixSelDrawGrid3.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'column there is no empty')
    else
      FixSelDrawGrid3.Canvas.TextRect(ARect, ARect.Left, ARect.Top, 'space to the right');
  end;
end;

procedure TDemoForm.FixSelDrawGrid1DblClick(Sender: TObject);
begin
  MessageDlg('Double Click event occured.', mtInformation, [mbOk], 0)
end;

procedure TDemoForm.FixStringGrid1GetEditButtonType(Sender: TObject; ACol,
  ARow: Longint; var ButtonType: TEditButtonType);
begin
  ButtonType := CellEdit1.EditButtonType;
end;

procedure TDemoForm.FixStringGrid1SetEditorProperties(Sender: TObject;
  ACol, ARow: Longint; var InplaceEditor: TCellInplaceEdit);
begin
    if InplaceEditor.EditButton <> nil then
      InplaceEditor.EditButton.WordWrap := WordWrapCheckBox.Checked;
end;

end.
