unit SetColor;

interface

uses
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCal, FixSelGd, Tclrgrd;

type
  TSimpleSetColorDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    TextFBColorGrid1: TTextFBColorGrid;
    Label1: TLabel;
    procedure SetDateExtCalendarDblClick(Sender: TObject);
  private
  public
    procedure SetColor(newColor: TColor);
    function GetColor: TColor;
  end;

function GetColorDlg(var AColor: TColor): Boolean;

implementation

{$R *.DFM}

uses
  SysUtils;

function GetColorDlg(var AColor: TColor): Boolean;
var
  SimpleSetColorDlg: TSimpleSetColorDlg;
begin
	SimpleSetColorDlg := TSimpleSetColorDlg.Create(Application);
  try
    try
      SimpleSetColorDlg.SetColor(AColor);
    except
      SimpleSetColorDlg.SetColor(clBlack);
    end;
    if SimpleSetColorDlg.ShowModal = mrOk then
    begin
      AColor := SimpleSetColorDlg.GetColor;
      Result := True;
    end
    else
    	Result := False;
  finally
  	SimpleSetColorDlg.Destroy;
  end;
end;

procedure TSimpleSetColorDlg.SetColor(newColor: TColor);
begin
  TextFBColorGrid1.ForegroundColor := newColor;
end;

function TSimpleSetColorDlg.GetColor: TColor;
begin
  Result := TextFBColorGrid1.ForegroundColor;
end;

procedure TSimpleSetColorDlg.SetDateExtCalendarDblClick(Sender: TObject);
begin
	OKBtn.Click;
end;

end.
