unit Treefrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TreeGrd, Fixselgd, SFETree, DemoTree, StdCtrls, EditBtn,
  Spin;

type
  TForm1 = class(TForm)
    TreeDrawGrid1: TTreeDrawGrid;
    GroupBox1: TGroupBox;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    GroupBox2: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    ScrollBar1: TScrollBar;
    CheckBox4: TCheckBox;
    CheckBox1: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox2: TCheckBox;
    GroupBox4: TGroupBox;
    Button7: TButton;
    Button8: TButton;
    Label2: TLabel;
    Label3: TLabel;
    FixedSpinEdit: TSpinEdit;
    FixSelSpinEdit: TSpinEdit;
    procedure FixSelDrawGrid1DrawCell(Sender: TObject; ACol, ARow,
      AColIndex, ARowIndex: Longint; ARect: TRect;
      AState: TFixSelGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TreeDrawGrid1DrawCell(Sender: TObject; ACol, ARow, AColIndex,
      ARowIndex: Longint; ARect: TRect; AState: TFixSelGridDrawState;
      ItemColor: TColor; SFETreeNode: TSFETreeNode);
    procedure ScrollBar1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure TreeDrawGrid1GetCellEditable(Sender: TObject; ACol,
      ARow: Longint; var Editable: Boolean);
    procedure TreeDrawGrid1GetEditText(Sender: TObject; ACol,
      ARow: Longint; var Value: OpenString);
    procedure TreeDrawGrid1GetEditButtonType(Sender: TObject; ACol,
      ARow: Longint; var ButtonType: TEditButtonType);
    procedure TreeDrawGrid1SetEditorProperties(Sender: TObject; ACol,
      ARow: Longint; var InplaceEditor: TCellInplaceEdit);
    procedure TreeDrawGrid1EditorStop(Sender: TObject; ACol, ARow: Longint;
      const Value: String; Confirmed: Boolean; var Valid: Boolean);
    procedure TreeDrawGrid1EditDownClick(Sender: TObject; Col,
      Row: Longint);
    procedure TreeDrawGrid1EditUpClick(Sender: TObject; Col, Row: Longint);
    procedure TreeDrawGrid1EditButtonClick(Sender: TObject; Col,
      Row: Longint);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure FixedSpinEditChange(Sender: TObject);
    procedure FixSelSpinEditChange(Sender: TObject);
    procedure TreeDrawGrid1GetEditorEnabled(Sender: TObject; ACol,
      ARow: Longint; var Enabled: Boolean);
  private
    FTreeManager: TDemoTreeManager;
    FTree:        TDemoTree;
    procedure CreateTree;
    function GetCellText(SFETreeNode: TSFETreeNode; ACol, ARow: Longint): String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  Grids, Ssetdate, SetColor;

const
  YesStr  = 'Yes';
  NoStr   = 'No';
var
  IDsCounter:   Longint;

{$R *.DFM}

function MyInc(var Num: Longint): Longint;
begin
  Inc(Num);
  Result := Num;
end;

procedure TForm1.FixSelDrawGrid1DrawCell(Sender: TObject; ACol, ARow,
  AColIndex, ARowIndex: Longint; ARect: TRect;
  AState: TFixSelGridDrawState);
begin
  ARect := ARect;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FTreeManager := TDemoTreeManager.Create;
  FTree := TDemoTree.Create(FTreeManager);
  FTree.UsersOrder := True; 
  TreeDrawGrid1.Tree := FTree;
  CreateTree;
  if TreeDrawGrid1.Marking then
    TreeDrawGrid1.ColWidths[TreeDrawGrid1.MarkingColumn] :=
      TreeDrawGrid1.RowHeights[0];
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if FTree <> nil then
    FTree.Destroy;
  if FTreeManager <> nil then
    FTreeManager.Destroy;
end;

procedure TForm1.CreateTree;
  procedure AddLevelItems(MaxLevel: Integer; CurrLevel: Integer;
    ParentId: Longint);
  var
    DemoTreeItem: TDemoTreeItem;
    I:  Integer;
  begin
    if MaxLevel < CurrLevel then
      Exit;
    for I := 1 to 3 do
    begin
      DemoTreeItem := TDemoTreeItem.Create;
      DemoTreeItem.FItemId := MyInc(IDsCounter);
      DemoTreeItem.FParentId := ParentId;
      DemoTreeItem.ItemName := 'Item No ' + IntToStr(DemoTreeItem.FItemId);
      DemoTreeItem.Attribute1 := DemoTreeItem.ItemName;
      FTreeManager.AddItem(DemoTreeItem);
      AddLevelItems(MaxLevel, CurrLevel + 1, DemoTreeItem.FItemId);
    end;
  end;
var
  I : Integer;
begin
    AddLevelItems(5, 0, RootId);
    FTree.Recalc;
    for I := 0 to FTree.CountNodes - 1 do
      if (I mod 3) = 1 then
        FTree.Nodes[I].Hidden := True;
  TreeDrawGrid1.RefreshFromData;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TreeDrawGrid1.MarkItemSubTree(TreeDrawGrid1.GetItemIdFromRow(TreeDrawGrid1.Row));
end;

function TForm1.GetCellText(SFETreeNode: TSFETreeNode; ACol, ARow: Longint): String;
begin
  Result := '';
  if SFETreeNode <> nil then
  with SFETreeNode.Item as TDemoTreeItem do
  begin
    if TreeDrawGrid1.ColIndexes[ACol] = TreeDrawGrid1.TreeColumn then
      Result := ItemName
    else
    begin
      case TreeDrawGrid1.GetAttributeNumFromColumn(ACol) of
        0: Result := Attribute1;
        1: Result := IntToStr(Attribute2);
        2:
        begin
          if Attribute3 then Result := YesStr else Result := NoStr;
{          TreeDrawGrid1.InplaceEditor.ComboBox.ItemIndex :=
            TreeDrawGrid1.InplaceEditor.ComboBox.Items.IndexOf(Result);}
        end;
        3: Result := DateToStr(Attribute4);
        4: Result := '';
      end;
    end;
  end;
  if TreeDrawGrid1.RowIndexes[ARow] = 0 then
  begin
    if TreeDrawGrid1.ColIndexes[ACol] =  TreeDrawGrid1.TreeColumn then
      Result := 'Tree'
    else
      if TreeDrawGrid1.Marking and (TreeDrawGrid1.ColIndexes[ACol] = TreeDrawGrid1.MarkingColumn) then
        Result := ''
      else
      begin
        case TreeDrawGrid1.GetAttributeNumFromColumn(ACol) of
          0: Result := 'String';
          1: Result := 'Numeric';
          2: Result := 'Logical';
          3: Result := 'Date';
          4: Result := 'Colour';
        end;
      end;
  end;
end;

procedure TForm1.TreeDrawGrid1DrawCell(Sender: TObject; ACol, ARow,
  AColIndex, ARowIndex: Longint; ARect: TRect;
  AState: TFixSelGridDrawState; ItemColor: TColor;
  SFETreeNode: TSFETreeNode);
var
  Buff:       PChar;
  CellText:   String;
begin
  if (TreeDrawGrid1.GetAttributeNumFromColumn(ACol) = 4) and (SFETreeNode <> nil) then
  begin
    TreeDrawGrid1.Canvas.Brush.Color := TDemoTreeItem(SFETreeNode.Item).Attribute5;
    TreeDrawGrid1.Canvas.FillRect(ARect);
  end
  else
  begin
    CellText := GetCellText(SFETreeNode, ACol, ARow);
    if (CellText = '') then
      Exit;
    Buff := StrAlloc(Length(CellText) + 1);
    try
      StrPCopy(Buff, CellText);
      ARect.Top := ARect.Top + 2;
      DrawText(TreeDrawGrid1.Canvas.Handle, Buff, StrLen(Buff), ARect,
        DT_LEFT or DT_NOPREFIX or DT_EXPANDTABS);
    finally
      StrDispose(Buff)
    end;
  end;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  TreeDrawGrid1.TreeLevelMargin := ScrollBar1.Position;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  TreeDrawGrid1.ShowTreeLines := CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  FTree.ShowHidden := CheckBox2.Checked;
  TreeDrawGrid1.RefreshFromData;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  TreeDrawGrid1.UnmarkItemSubTree(TreeDrawGrid1.GetItemIdFromRow(TreeDrawGrid1.Row));
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  TreeDrawGrid1.ShowTreeSigns := CheckBox3.Checked;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  if goHorzLine in TreeDrawGrid1.Options then
    TreeDrawGrid1.Options := TreeDrawGrid1.Options - [goHorzLine]
  else
    TreeDrawGrid1.Options := TreeDrawGrid1.Options + [goHorzLine];
end;

procedure TForm1.TreeDrawGrid1GetCellEditable(Sender: TObject; ACol,
  ARow: Longint; var Editable: Boolean);
var
  Node: TSFETreeNode;
begin
  Editable := (not TreeDrawGrid1.Marking) or
    (TreeDrawGrid1.ColIndexes[ACol] <> TreeDrawGrid1.MarkingColumn);
  if Editable then
  begin
{    if (TreeDrawGrid1.GetAttributeNumFromColumn(ACol) = 4) then
      Editable := False
    else}
      if (TreeDrawGrid1.GetAttributeNumFromColumn(ACol) = 1) then
      begin
        Node := TreeDrawGrid1.GetNodeFromRow(TreeDrawGrid1.RowIndexes[ARow]);
        if Node <> nil then
          Editable := not Node.HasChildren;
        if not Editable then
          MessageDlg('This parameter may be edited for a leaf item only', mtError, [mbOk], 0);
      end;
  end;
end;

procedure TForm1.TreeDrawGrid1GetEditText(Sender: TObject; ACol,
  ARow: Longint; var Value: OpenString);
begin
  Value := GetCellText(TreeDrawGrid1.GetNodeFromRow(ARow), ACol, ARow);
end;

procedure TForm1.TreeDrawGrid1GetEditButtonType(Sender: TObject; ACol,
  ARow: Longint; var ButtonType: TEditButtonType);
begin
  if TreeDrawGrid1.ColIndexes[ACol] = TreeDrawGrid1.TreeColumn then
    ButtonType := etNone
  else
  begin
    case TreeDrawGrid1.GetAttributeNumFromColumn(ACol) of
      0: ButtonType := etNone;
      1: ButtonType := etSpin;
      2:
      begin
        ButtonType := etComboBox;
        if (TreeDrawGrid1.InplaceEditor <> nil) and
          (TreeDrawGrid1.InplaceEditor.ComboBox <> nil) then
            TreeDrawGrid1.InplaceEditor.ComboBox.Style := csDropDown;

      end;
      3: ButtonType := etButton;
      4: ButtonType := etButton;
    end;
  end;
end;

procedure TForm1.TreeDrawGrid1SetEditorProperties(Sender: TObject; ACol,
  ARow: Longint; var InplaceEditor: TCellInplaceEdit);
var
  Str:  String;
  Node:   TSFETreeNode;
begin
  InplaceEditor.Color := clWindow;
  case TreeDrawGrid1.GetAttributeNumFromColumn(ACol) of
    2:
    begin
      Str := InplaceEditor.Text;
      InplaceEditor.ComboBox.Items.Clear;
      InplaceEditor.ComboBox.Items.Add(YesStr);
      InplaceEditor.ComboBox.Items.Add(NoStr);
      InplaceEditor.ComboBox.Style := csDropDownList;
      InplaceEditor.ComboBox.ItemIndex :=
        InplaceEditor.ComboBox.Items.IndexOf(Str);
    end;
    4:
    begin
      Node := TreeDrawGrid1.GetNodeFromRow(ARow);
      if Node <> nil then
        InplaceEditor.Color := TDemoTreeItem(Node.Item).Attribute5;
    end;
  end;
end;

procedure TForm1.TreeDrawGrid1EditorStop(Sender: TObject; ACol,
  ARow: Longint; const Value: String; Confirmed: Boolean;
  var Valid: Boolean);
var
  Node: TSFETreeNode;
begin
  try
    if not Confirmed then
      Exit;
    Valid := True;
    Node := TreeDrawGrid1.GetNodeFromRow(TreeDrawGrid1.RowIndexes[ARow]);
    if Node = nil then
      raise Exception.Create('Treee Node not found');
    if TreeDrawGrid1.ColIndexes[ACol] = TreeDrawGrid1.TreeColumn then
      TDemoTreeItem(Node.Item).ItemName := Value
    else
    begin
      case TreeDrawGrid1.GetAttributeNumFromColumn(ACol) of
        0: TDemoTreeItem(Node.Item).Attribute1 := Value;
        1:
          TDemoTreeItem(Node.Item).Attribute2 := StrToInt(Value);
        2:
          if Value = NoStr then
            TDemoTreeItem(Node.Item).Attribute3 := False
          else
            TDemoTreeItem(Node.Item).Attribute3 := True;
        3:
          TDemoTreeItem(Node.Item).Attribute4 := StrToDate(Value);
        4:
          TDemoTreeItem(Node.Item).Attribute5 := TreeDrawGrid1.InplaceEditor.Color;
      end;
    end;
    if Confirmed then
    begin
      FTree.Recalc;
      TreeDrawGrid1.RefreshFromData;
    end;
  except
    on E: Exception do
    begin
      MessageDlg(E.Message, mtError, [mbOk], 0);
      Valid := False;
    end;
  end;
end;

procedure TForm1.TreeDrawGrid1EditDownClick(Sender: TObject; Col,
  Row: Longint);
begin
  try
    TreeDrawGrid1.InplaceEditor.Text :=
      IntToStr(StrToInt(TreeDrawGrid1.InplaceEditor.Text) - 1)
  except
    TreeDrawGrid1.InplaceEditor.Text := IntToStr(0);
  end;
end;

procedure TForm1.TreeDrawGrid1EditUpClick(Sender: TObject; Col,
  Row: Longint);
begin
  try
    TreeDrawGrid1.InplaceEditor.Text :=
      IntToStr(StrToInt(TreeDrawGrid1.InplaceEditor.Text) + 1)
  except
    TreeDrawGrid1.InplaceEditor.Text := IntToStr(0);
  end;
end;

procedure TForm1.TreeDrawGrid1EditButtonClick(Sender: TObject; Col,
  Row: Longint);
var
  ADate: TDateTime;
  AColor: TColor;
begin
  if (TreeDrawGrid1.GetAttributeNumFromColumn(Col) = 3) then
  begin
    try
      ADate := StrToDate(TreeDrawGrid1.InplaceEditor.Text);
    except
      ADate := Date;
    end;
    if GetDateDlgDate(ADate) then
      TreeDrawGrid1.InplaceEditor.Text := DateToStr(ADate);
  end;
  if (TreeDrawGrid1.GetAttributeNumFromColumn(Col) = 4) then
  begin
    AColor := TreeDrawGrid1.InplaceEditor.Color;
    if GetColorDlg(AColor) then
      TreeDrawGrid1.InplaceEditor.Color := AColor;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  DemoTreeItem: TDemoTreeItem;
  ParentId:     Longint;
begin
  ParentId := TreeDrawGrid1.GetItemIdFromRow(TreeDrawGrid1.Row);
  if ParentId = -2 then
    Exit;
  DemoTreeItem := TDemoTreeItem.Create;
  DemoTreeItem.FItemId := MyInc(IDsCounter);
  DemoTreeItem.FParentId := ParentId;
  DemoTreeItem.ItemName := 'New Item No ' + IntToStr(DemoTreeItem.FItemId);
  DemoTreeItem.Attribute1 := DemoTreeItem.ItemName;
  FTreeManager.AddItem(DemoTreeItem);

  FTree.Recalc;
  TreeDrawGrid1.RefreshFromData;
  TreeDrawGrid1.SelectItem(DemoTreeItem.FItemId);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  ItemId:     Longint;
  ParentId:   Longint;
  Node:       TSFETreeNode;
begin
  Node := TreeDrawGrid1.GetNodeFromRow(TreeDrawGrid1.Row);
  if Node = nil then
    Exit;
  ItemId := Node.Item.Id;
  if ItemId = RootId then
    raise Exception.Create('Unable to remove the root node');
  ParentId := -1;
  if Node.Parent <> nil then
    ParentId := Node.Parent.Item.Id;
  FTreeManager.DelItem(ItemId);
  FTree.Recalc;
  TreeDrawGrid1.RefreshFromData;
  if ParentId <> -1 then
    TreeDrawGrid1.SelectItem(ParentId);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  I:          Integer;
  SrcNode:       TSFETreeNode;
  Node:       TSFETreeNode;
  Parent:       TSFETreeNode;
  ItemId:     Longint;
begin
  SrcNode := TreeDrawGrid1.GetNodeFromRow(TreeDrawGrid1.Row);
  if SrcNode = nil then
    Exit;
  Parent := SrcNode.Parent;
  ItemId := SrcNode.Item.Id;
  if Parent = nil then
    Exit;
  I := Parent.GetVisibleChildIndex(SrcNode);
  I := Parent.PrevVisibleChild(I);
  if I = -1 then
    raise Exception.Create('The item is on first position within its level');
  I := Parent.PrevVisibleChild(I);
  if I = -1 then
    Node := Parent
  else
    Node := Parent.Children[I];
  if Node <> nil then
    SrcNode.PlaceAfterNode(Node);
  FTree.Recalc;
  TreeDrawGrid1.RefreshFromData;
  TreeDrawGrid1.SelectItem(ItemId);
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  I:          Integer;
  SrcNode:       TSFETreeNode;
  Node:       TSFETreeNode;
  Parent:       TSFETreeNode;
  ItemId:     Longint;
begin
  SrcNode := TreeDrawGrid1.GetNodeFromRow(TreeDrawGrid1.Row);
  if SrcNode = nil then
    Exit;
  Parent := SrcNode.Parent;
  ItemId := SrcNode.Item.Id;
  if Parent = nil then
    Exit;
  I := Parent.GetVisibleChildIndex(SrcNode);
  I := Parent.NextVisibleChild(I);
  if I = -1 then
    raise Exception.Create('The item is on last position within its level');
  Node := Parent.Children[I];
  if Node <> nil then
    SrcNode.PlaceAfterNode(Node);
  FTree.Recalc;
  TreeDrawGrid1.RefreshFromData;
  TreeDrawGrid1.SelectItem(ItemId);
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  TreeDrawGrid1.HideItem(TreeDrawGrid1.GetItemIdFromRow(TreeDrawGrid1.Row));
  TreeDrawGrid1.RefreshFromData;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  TreeDrawGrid1.UnhideItem(TreeDrawGrid1.GetItemIdFromRow(TreeDrawGrid1.Row));
  TreeDrawGrid1.RefreshFromData;
end;

procedure TForm1.FixedSpinEditChange(Sender: TObject);
begin
  TreeDrawGrid1.FixedCols := FixedSpinEdit.Value;
end;

procedure TForm1.FixSelSpinEditChange(Sender: TObject);
begin
  TreeDrawGrid1.SelFixedCols := FixSelSpinEdit.Value;
end;

procedure TForm1.TreeDrawGrid1GetEditorEnabled(Sender: TObject; ACol,
  ARow: Longint; var Enabled: Boolean);
begin
  Enabled := TreeDrawGrid1.GetAttributeNumFromColumn(ACol) <> 4;
end;

begin
  IDsCounter := 0;
end.
