unit DemoTree;

interface

uses
  Sfetree, TreeGrd, Graphics;

const
  NoItemId = 0;

type
  {TDemoTreeManager}
	TDemoTreeManager = class(TSFETreeManager)
    procedure CreateRootItem; override;
  end;

  {TDemoTreeItem}
  TDemoTreeItem = class(TSFETreeItem)
  protected
    function GetId: Longint; override;
    function GetParentId: Longint; override;
    procedure SetParentId(NewParentId: Longint); override;
    procedure ResetData; override;
    procedure SumData(const Item: TSFETreeItem); override;
    function IsFolder: Boolean; override;
    function CompareData(const Item: TSFETreeItem;
        const Tree: TSFETree): Integer; override;
    function Filter(const Tree: TSFETree): Boolean; override;
  public
    FItemId:    Longint;
    FParentId:  Longint;
    ItemName:   String;
    Attribute1: String;
    Attribute2: Longint;
    Attribute3: Boolean;
    Attribute4: TDateTime;
    Attribute5: TColor;
    constructor Create;
  end;

  TDemoTree = class(TSFETree)
    FShowHidden: Boolean;
  protected
    function GetShowHidden: Boolean; override;
    procedure SetShowHidden(Value: Boolean);
  public
    constructor Create(AManager: TSFETreeManager);
    procedure AddItem(Item: TSFETreeItem); override;
    property ShowHidden: Boolean read GetShowHidden write SetShowHidden;
  end;

implementation

uses
  SortList, SysUtils;

{TDemoTreeManager}
procedure TDemoTreeManager.CreateRootItem;
var
  DemoTreeItem: TDemoTreeItem;
begin
  DemoTreeItem := TDemoTreeItem.Create;
  DemoTreeItem.FItemId := RootId;
  DemoTreeItem.FParentId := RootParentId;
  DemoTreeItem.ItemName := 'Root Item';
  AddItemDataOnly(DemoTreeItem);
end;

{TDemoTreeItem}
constructor TDemoTreeItem.Create;
begin
  FItemId := NoItemId;
  FParentId := NoItemId;
  ItemName := 'No Name';
  Attribute1 := '';
  Attribute2 := 0;
  Attribute3 := True;
  Attribute4 := Date;
  Attribute5 := clWhite;
end;

function TDemoTreeItem.GetId: Longint;
begin
  Result := FItemId;
end;

function TDemoTreeItem.GetParentId: Longint;
begin
  Result := FParentId;
end;

procedure TDemoTreeItem.SetParentId(NewParentId: Longint);
begin
  FParentId := NewParentId;
end;

procedure TDemoTreeItem.ResetData;
begin
  Attribute2 := 0;
end;

procedure TDemoTreeItem.SumData(const Item: TSFETreeItem);
begin
  Attribute2 := Attribute2 + TDemoTreeItem(Item).Attribute2;
end;

function TDemoTreeItem.CompareData(const Item: TSFETreeItem;
        const Tree: TSFETree): Integer;
begin
  Result := CompareInt(FItemId, TDemoTreeItem(Item).FItemId);
end;

function TDemoTreeItem.IsFolder: Boolean;
begin
  Result := False;
end;

function TDemoTreeItem.Filter(const Tree: TSFETree): Boolean;
begin
  Result := True;
end;

{TDemoTree}
constructor TDemoTree.Create(AManager: TSFETreeManager);
begin
  inherited Create(AManager);
  FShowHidden := True;
end;

procedure TDemoTree.AddItem(Item: TSFETreeItem);
begin
  inherited AddItem(Item);
end;

function TDemoTree.GetShowHidden: Boolean;
begin
  Result := FShowHidden;
end;

procedure TDemoTree.SetShowHidden(Value: Boolean);
begin
  FShowHidden := Value;
  RecalcVisibility;
end;

end.
