unit Ssetdate;

interface

uses
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCal, FixSelGd;

type
  TSimpleSetDateDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    SetDateExtCalendar: TExtCalendar;
    procedure SetDateExtCalendarDblClick(Sender: TObject);
  private
  public
    procedure SetDate(newDate: TDateTime);
    function GetDate: TDateTime;
  end;

function GetDateDlgDate(var ADate: TDateTime): Boolean;
procedure SimpleSetDateToEditControl(var AEdit: TCustomEdit);
procedure FullSelect(var Edit: TCustomEdit);

implementation

{$R *.DFM}

uses
  SysUtils;

procedure SimpleSetDateToEditControl(var AEdit: TCustomEdit);
var
  ADate: TDateTime;
begin
  try
    ADate := StrToDate(AEdit.Text);
  except
    ADate := Date;
  end;
  if GetDateDlgDate(ADate) then
  begin
  	AEdit.Text := DateToStr(ADate);
    FullSelect(AEdit);
  end;
end;

function GetDateDlgDate(var ADate: TDateTime): Boolean;
var
  SimpleSetDateDlg: TSimpleSetDateDlg;
begin
	SimpleSetDateDlg := TSimpleSetDateDlg.Create(Application);
  try
    try
      SimpleSetDateDlg.SetDate(ADate);
    except
      SimpleSetDateDlg.SetDate(Date);
    end;
    SimpleSetDateDlg.ShowModal;
    if SimpleSetDateDlg.ModalResult = mrOk then
    begin
      ADate := SimpleSetDateDlg.GetDate;
      Result := True;
    end
    else
    	Result := False;
  finally
  	SimpleSetDateDlg.Destroy;
  end;
end;

procedure TSimpleSetDateDlg.SetDate(newDate: TDateTime);
begin
  SetDateExtCalendar.CalendarDate := newDate;
end;

function TSimpleSetDateDlg.GetDate: TDateTime;
begin
  Result := SetDateExtCalendar.CalendarDate;
end;

procedure FullSelect(var Edit: TCustomEdit);
begin
  if Edit.Focused then
  begin
    Edit.SelStart := 0;
    Edit.SelLength := Length(Edit.Text);
  end
  else
    Edit.SetFocus;
end;

procedure TSimpleSetDateDlg.SetDateExtCalendarDblClick(Sender: TObject);
begin
	OKBtn.Click;
end;

end.
