VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Edit"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
'
' Sistema:    AxcelLib
' Classe:     Edit
'
' Criado:     11 Jan 1996
' Atualizado:
'
' Copyright  1996 by Marco Antnio Gutierrez
' Copyright  1996 by Axcel Books do Brasil
' Editora Ltda
'

Option Explicit

' Propriedades do objeto
Dim BuscaFalhou As Boolean

' Variveis modulares
Dim Janela As Form

' Construtora da classe
Private Sub Class_Initialize()
  Dim NovaInstncia As New frmEdit
  
  ' Carrega janela
  On Error GoTo InitErro
  Set Janela = NovaInstncia
  Load Janela
  
  ' Inicializa variveis
  BuscaFalhou = True
  Exit Sub

' Erro carregando formulrio
InitErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_ERROCARGA, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_ERROCARGA)
  Exit Sub
End Sub

' Retorna permisso de insero
Public Property Get AllowAddNew() As Boolean
  AllowAddNew = Janela.dbgEdit.AllowAddNew
End Property

' Determina permisso de insero
Public Property Let AllowAddNew _
 (Insere As Boolean)
  Janela.dbgEdit.AllowAddNew = Insere
  Janela.Data.ReadOnly = _
   IIf(Not Janela.dbgEdit.AllowAddNew And _
   Not Janela.dbgEdit.AllowDelete And _
   Not Janela.dbgEdit.AllowUpdate, _
   True, False)
End Property

' Retorna permisso de remoo
Public Property Get AllowDelete() As Boolean
  AllowDelete = Janela.dbgEdit.AllowDelete
End Property

' Atribui permisso de remoo
Public Property Let AllowDelete _
 (Remove As Boolean)
  Janela.dbgEdit.AllowDelete = Remove
  Janela.Data.ReadOnly = _
   IIf(Not Janela.dbgEdit.AllowAddNew And _
   Not Janela.dbgEdit.AllowDelete And _
   Not Janela.dbgEdit.AllowUpdate, _
   True, False)
End Property

' Retorna permisso de atualizao
Public Property Get AllowUpdate() As Boolean
  AllowUpdate = Janela.dbgEdit.AllowUpdate
End Property

' Atribui permisso de atualizao
Public Property Let AllowUpdate _
 (Atualiza As Boolean)
  Janela.dbgEdit.AllowUpdate = Atualiza
  Janela.Data.ReadOnly = _
   IIf(Not Janela.dbgEdit.AllowAddNew And _
   Not Janela.dbgEdit.AllowDelete And _
   Not Janela.dbgEdit.AllowUpdate, _
   True, False)
End Property

' Retorna o marcador do registro corrente
Public Property Get Bookmark() As String
  Bookmark = IIf(Janela.Data.Recordset. _
   Bookmarkable, Janela.Data. _
   Recordset.Bookmark, "")
End Property

' Salta para o registro marcado
Public Property Let Bookmark(Marca As String)
  If Janela.Data.Recordset.Bookmarkable Then _
   Janela.Data.Recordset.Bookmark = Marca
End Property

' Retorna a barra de ttulo da janela
Public Property Get Caption() As String
  Caption = Janela.Caption
End Property

' Atribui a barra de ttulo da janela
Public Property Let Caption(Ttulo As String)
  Janela.Caption = Ttulo
End Property

' Retorna o tipo de dado da clula corrente
Public Property Get DataType() As Integer
  On Error GoTo DataTypeErro
  DataType = Janela.Data.Recordset.Fields _
   (Janela.dbgEdit.Col).Type
  Exit Property

' Objeto no declarado
DataTypeErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Property
End Property

' Retorna o banco de dados aberto
Public Property Get DatabaseName() As String
  DatabaseName = Janela.Data.DatabaseName
End Property

' Determina o banco de dados
Public Property Let DatabaseName _
 (Banco As String)
  If Not ArquivoExiste(Banco) Then _
   GoTo DatabaseNameErro
  Janela.Data.DatabaseName = Banco
  Exit Property

' Arquivo no existe
DatabaseNameErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNOBANCO, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNOBANCO)
  Exit Property
End Property

' Retorna o nome do campo em edio
Public Property Get FieldName() As String
  On Error GoTo DataTypeErro
  FieldName = Janela.Data.Recordset.Fields _
   (Janela.dbgEdit.Col).Name
  Exit Property

' Objeto no declarado
DataTypeErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Property
End Property

' Retorna se busca falhou
Public Property Get NoMatch() As Boolean
  NoMatch = BuscaFalhou
End Property

' Retorna status de atualizao
Public Property Get ReadOnly() As Boolean
  ReadOnly = Janela.Data.ReadOnly
End Property

' Atribui status de atualizao
Public Property Let ReadOnly _
 (SomenteLeitura As Boolean)
  Janela.Data.ReadOnly = SomenteLeitura
  If SomenteLeitura Then
    Janela.dbgEdit.AllowAddNew = False
    Janela.dbgEdit.AllowDelete = False
    Janela.dbgEdit.AllowUpdate = False
  End If
End Property

' Retorna quantidade de registros
Public Property Get RecordCount() As Long
  Dim Marcador As String
  On Error GoTo RecordCountErro
  If Janela.Data.Recordset.Bookmarkable Then
    Marcador = Janela.Data.Recordset.Bookmark
    Janela.Data.Recordset.MoveLast
  End If
  RecordCount = Janela.Data.Recordset. _
   RecordCount
  If Janela.Data.Recordset.Bookmarkable Then _
   Janela.Data.Recordset.Bookmark = Marcador
  Exit Property
  
RecordCountErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Property
End Property

' Retorna fonte de dados do grid
Public Property Get RecordSource() As String
  RecordSource = Janela.Data.RecordSource
End Property

' Atribui fonte de dados do grid
Public Property Let RecordSource _
 (Fonte As String)
  Janela.Data.RecordSource = Fonte
End Property

' Retorna a propriedade Tag
Public Property Get Tag() As String
  Tag = Janela.Tag
End Property

' Atribui a propriedade Tag
Public Property Let Tag(Parm As String)
  Janela.Tag = Parm
End Property

' Retorna o contedo da clula corrente
Public Property Get Text() As Variant
  On Error GoTo GetTextErro
  Text = Janela.Data.Recordset.Fields _
   (Janela.dbgEdit.Col)
  Exit Property

GetTextErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Property
End Property

' Atribui o contedo da clula corrente
Public Property Let Text(Valor As Variant)
  On Error GoTo LetTextErro
  Janela.Data.Recordset.Edit
  Janela.Data.Recordset.Fields _
   (Janela.dbgEdit.Col) = Valor
  Janela.Data.Recordset.Update
  Janela.Data.UpdateControls
  Exit Property

LetTextErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDATUALIZA, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDATUALIZA)
  Exit Property
End Property

' Localiza primeiro registro
Public Sub FindFirst(Critrio As String)
  On Error GoTo FindFirstErro
  Janela.Data.Recordset.FindFirst Critrio
  BuscaFalhou = Janela.Data.Recordset.NoMatch
  Exit Sub

' Erro
FindFirstErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Localiza ltimo registro
Public Sub FindLast(Critrio As String)
  On Error GoTo FindLastErro
  Janela.Data.Recordset.FindLast Critrio
  BuscaFalhou = Janela.Data.Recordset.NoMatch
  Exit Sub

' Erro
FindLastErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Localiza prximo registro
Public Sub FindNext(Critrio As String)
  On Error GoTo FindNextErro
  Janela.Data.Recordset.FindNext Critrio
  BuscaFalhou = Janela.Data.Recordset.NoMatch
  Exit Sub

' Erro
FindNextErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Localiza registro anterior
Public Sub FindPrevious(Critrio As String)
  On Error GoTo FindPreviousErro
  Janela.Data.Recordset.FindPrevious Critrio
  BuscaFalhou = Janela.Data.Recordset.NoMatch
  Exit Sub

' Erro
FindPreviousErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Salta para o primeiro registro
Public Sub MoveFirst()
  On Error GoTo MoveFirstErro
  Janela.Data.Recordset.MoveFirst
  Exit Sub

MoveFirstErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Salta para o ltimo registro
Public Sub MoveLast()
  On Error GoTo MoveLastErro
  Janela.Data.Recordset.MoveLast
  Exit Sub

MoveLastErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Salta para o prximo registro
Public Sub MoveNext()
  On Error GoTo MoveNextErro
  Janela.Data.Recordset.MoveNext
  Exit Sub

MoveNextErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Salta para o registro anterior
Public Sub MovePrevious()
  On Error GoTo MovePreviousErro
  Janela.Data.Recordset.MovePrevious
  Exit Sub

MovePreviousErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDNORECORD, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDNORECORD)
  Exit Sub
End Sub

' Rola o grid
Public Sub Scroll _
 (Optional Linhas As Variant, _
 Optional Colunas As Variant)
  Dim Lin As Long, Col As Long
  
  ' Obtm argumentos default
  Lin = IIf(IsMissing(Linhas), _
   1&, CLng(Linhas))
  Col = IIf(IsMissing(Colunas), _
   0&, CLng(Colunas))
   
  ' Rola grid
  Janela.dbgEdit.Scroll Col, Lin
End Sub

' Exibe a janela de edio
Public Sub Show()
  Dim db As Database
  Dim pq As QueryDef
  Dim Consulta As Recordset
  Dim i As Integer, j As Integer
  Dim QueryParametrizada As Boolean
  
  ' Valida propriedades crticas
  If Janela.Data.DatabaseName = "" Or _
   Janela.Data.RecordSource = "" Then _
   GoTo ShowErro

  ' Verifica query parametrizada
  On Error GoTo ShowErro
  Set db = Workspaces(0).OpenDatabase _
   (Janela.Data.DatabaseName)
  For i = 0 To db.QueryDefs.Count - 1
    If db.QueryDefs(i).Name = _
     Janela.Data.RecordSource And _
     db.QueryDefs(i).Parameters.Count <> 0 Then
      QueryParametrizada = True
      Exit For
    End If
  Next
  
  ' Extrai parmetros
  If QueryParametrizada Then
    For j = 0 To db.TableDefs.Count - 1
      If db.TableDefs(j).Attributes = 0 Then
        Janela.Data.RecordSource = _
         db.TableDefs(j).Name
        Exit For
      End If
    Next
    Janela.Data.Refresh
    Set pq = db.QueryDefs(db.QueryDefs(i).Name)
    For i = 0 To pq.Parameters.Count - 1
      Load frmParms
      frmParms.DataName = pq.Parameters(i).Name
      frmParms.DataType = pq.Parameters(i).Type
      frmParms.Show 1
      If frmParms.DataValue <> "" Then
        pq.Parameters(i).Value = _
         frmParms.DataValue
      Else
        Exit Sub
      End If
      Unload frmParms
    Next
    Set Consulta = pq.OpenRecordset()
    Set Janela.Data.Recordset = Consulta
  End If
  
  ' Efetua conexo e verifica
  If Not QueryParametrizada Then _
   Janela.Data.Refresh
  If Janela.Data.Recordset Is Nothing _
   Then GoTo ShowErro
  Janela.Show
  Exit Sub

' Erro na conexo
ShowErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_EDSEMCONEXAO, _
   LoadResString(IDS_EDCLASSE), _
   LoadResString(IDS_EDSEMCONEXAO)
  Exit Sub
End Sub

' Atualiza grid
Public Sub Refresh()
  Janela.Data.UpdateControls
End Sub

' Verifica se arquivo existe
Private Function ArquivoExiste _
 (Arquivo As String) As Boolean
  Dim handle As Integer
  On Error Resume Next
  handle = FreeFile
  Open Arquivo For Input Shared As handle
  ArquivoExiste = IIf(Err.Number = 53, False, True)
  Close #handle
  Err = 0
End Function
