VERSION 4.00
Begin VB.Form frmFind 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "#"
   ClientHeight    =   2100
   ClientLeft      =   735
   ClientTop       =   2070
   ClientWidth     =   6885
   Height          =   2505
   Left            =   675
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2100
   ScaleWidth      =   6885
   ShowInTaskbar   =   0   'False
   Top             =   1725
   Width           =   7005
   Begin VB.CommandButton Command1 
      Cancel          =   -1  'True
      Caption         =   "#"
      Height          =   400
      Left            =   4600
      TabIndex        =   7
      Top             =   900
      Width           =   2000
   End
   Begin VB.CommandButton cmdPrxima 
      Caption         =   "#"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   400
      Left            =   4600
      TabIndex        =   6
      Top             =   240
      Width           =   2000
   End
   Begin VB.ComboBox cboCritrio 
      Height          =   360
      Left            =   3200
      Style           =   2  'Dropdown List
      TabIndex        =   5
      Top             =   1500
      Width           =   1200
   End
   Begin VB.ComboBox cboDireo 
      Height          =   360
      ItemData        =   "Find.frx":0000
      Left            =   1100
      List            =   "Find.frx":0002
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   1500
      Width           =   1200
   End
   Begin VB.ComboBox cboOcorrncia 
      Height          =   360
      Left            =   1100
      TabIndex        =   1
      Top             =   240
      Width           =   3300
   End
   Begin Threed.SSPanel sspCritrio 
      Height          =   600
      Left            =   1095
      TabIndex        =   8
      Top             =   705
      Width           =   3300
      _Version        =   65536
      _ExtentX        =   5821
      _ExtentY        =   1058
      _StockProps     =   15
      BackColor       =   12632256
      BevelOuter      =   1
      Outline         =   -1  'True
      Alignment       =   0
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "#"
      Height          =   240
      Left            =   2400
      TabIndex        =   4
      Top             =   1500
      Width           =   120
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "#"
      Height          =   240
      Left            =   120
      TabIndex        =   2
      Top             =   1500
      Width           =   120
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "#"
      Height          =   240
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   120
   End
End
Attribute VB_Name = "frmFind"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' API do Windows
#If Win32 Then
  Private Declare Function SetWindowPos _
   Lib "user32" (ByVal hWnd As Long, _
   ByVal hWndInsertAfter As Long, _
   ByVal X As Long, ByVal Y As Long, _
   ByVal cx As Long, ByVal cy As Long, _
   ByVal wFlags As Long) As Long
#Else
  Private Declare Sub SetWindowPos Lib _
   "User" (ByVal hWnd As Integer, _
   ByVal hWndInsertAfter As Integer, _
   ByVal X As Integer, ByVal Y As Integer, _
   ByVal cx As Integer, _
   ByVal cy As Integer, _
   ByVal wFlags As Integer)
#End If
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOSIZE = &H1
Private Const HWND_NOTOPMOST = -2
Private Const HWND_TOPMOST = -1
Private Const FLAGS = SWP_NOMOVE Or _
 SWP_NOSIZE

' Ocorrncias j pesquisadas
Private Type Critrio
  Valor As String   ' Valor a pesquisar
  Texto As String   ' Campo + critrio
End Type
Dim Texto() As Critrio
Dim Ocorrncias As Integer

' Objeto da classe Edit
Dim Ob As Object

' Flag de carga da janela
Dim JCarregada As Boolean


' Seleciona um novo critrio
Private Sub cboCritrio_Click()
  sspCritrio.Caption = Ob.FieldName & _
   " " & Trim(cboCritrio.Text)
End Sub

' Habilita/desabilita boto de comando
Private Sub cboOcorrncia_Change()
  cmdPrxima.Enabled = (Len(cboOcorrncia.Text) > 0)
End Sub

' Seleciona critrio anterior
Private Sub cboOcorrncia_Click()
  sspCritrio.Caption = _
   Texto(cboOcorrncia.ListIndex + 1).Texto
End Sub

' Habilita/desabilita boto de comando
Private Sub cboOcorrncia_DropDown()
  cmdPrxima.Enabled = True
End Sub

' Coloca ocorrncia na lista
Private Sub cboOcorrncia_LostFocus()
  Dim i As Integer
  If Len(cboOcorrncia.Text) > 0 Then
  
    ' Verifica se texto j consta da lista
    For i = 1 To Ocorrncias
      If Trim(cboOcorrncia.Text) = _
       Texto(i).Valor And sspCritrio.Caption = _
       Texto(i).Texto Then Exit Sub
    Next
    
    ' Inclui texto na lista
    Ocorrncias = Ocorrncias + 1
    ReDim Preserve Texto(1 To Ocorrncias) _
     As Critrio
    Texto(Ocorrncias).Valor = _
     Trim(cboOcorrncia.Text)
    Texto(Ocorrncias).Texto = _
     Trim(sspCritrio.Caption)
    cboOcorrncia.AddItem _
     Texto(Ocorrncias).Valor
  End If
End Sub

' Localiza ocorrncia
Private Sub cmdPrxima_Click()
  Dim Critrio As String, Marca As String
  Dim RepitaBusca As Boolean
  Static ltimoCritrio As String
  
  ' Determina critrio de busca e marca
  ' registro corrente
  Critrio = sspCritrio.Caption & " "
  If Ob.DataType < dbText Then
   Critrio = Critrio & cboOcorrncia.Text
  Else
   Critrio = Critrio & "'" & _
    cboOcorrncia.Text & "'"
  End If
  Marca = Ob.Bookmark
  
  ' Verifica se critrio foi alterado
  ' e salva para prxima pesquisa
  If Critrio = ltimoCritrio Then _
   RepitaBusca = True
  ltimoCritrio = Critrio
   
  ' Busca no recordset
  Select Case cboDireo.ListIndex
  Case 0    ' Abaixo
    If RepitaBusca Then
      Ob.FindNext Critrio
    Else
      Ob.FindFirst Critrio
    End If
  Case 1    ' Acima
    Ob.FindPrevious Critrio
  Case 2    ' Tudo
    If RepitaBusca Then
      Ob.FindNext Critrio
    Else
      Ob.MoveFirst
      Ob.FindFirst Critrio
    End If
  End Select
  
  ' Ocorncia no localizada
  If Ob.NoMatch Then
    MsgBox LoadResString(IDS_FDMSGNOMATCH), , _
     LoadResString(IDS_FDCAPTION)
    Ob.Bookmark = Marca
  Else
    Ob.Refresh
    cmdPrxima.SetFocus
  End If
End Sub

' Descarrega janela
Private Sub Command1_Click()
  Unload Me
End Sub

' Atualiza controles
Private Sub Form_Activate()
  On Error GoTo ObjetoErro
  If Not JCarregada Then
    cboCritrio.ListIndex = 0
    JCarregada = True
  End If
  sspCritrio.Caption = Ob.FieldName _
   & " " & cboCritrio.Text
  cboOcorrncia.SetFocus
  Exit Sub

' Propriedade no atualizada
ObjetoErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_FDOBNOTSET, _
   LoadResString(IDS_FDCLASSE), _
   LoadResString(IDS_FDOBNOTSET)
  Exit Sub
End Sub

' Carga da janela
Private Sub Form_Load()
  Dim Recurso As String
  Dim i As Integer

  ' Janela sempre no topo
  #If Win32 Then
    Dim temp As Long
    temp = SetWindowPos(hWnd, HWND_TOPMOST, _
     0&, 0&, 0&, 0&, FLAGS)
  #Else
    SetWindowPos hWnd, HWND_TOPMOST, _
     0, 0, 0, 0, FLAGS
  #End If
  
  ' Posiciona janela no p do vdeo
  Top = Screen.Height - Height
  Left = Screen.Width - Width
  
  ' Recursos da janela
  Icon = LoadResPicture(IDI_ICOFIND, vbResIcon)
  Caption = LoadResString(IDS_FDCAPTION)
  Label1.Caption = _
   LoadResString(IDS_FDLABEL1)
  Label2.Caption = _
   LoadResString(IDS_FDLABEL2)
  Recurso = LoadResString(IDS_FDDIRECAO)
  Recurso = PegaPalavra(Recurso)
  Do
    cboDireo.AddItem Recurso
    Recurso = PegaPalavra()
  Loop Until Recurso = ""
  cboDireo.ListIndex = 2
  Label3.Caption = _
   LoadResString(IDS_FDLABEL3)
  Recurso = LoadResString(IDS_FDCRITERIO)
  Recurso = PegaPalavra(Recurso)
  Do
    cboCritrio.AddItem Recurso
    Recurso = PegaPalavra()
  Loop Until Recurso = ""
   cmdPrxima.Caption = _
    LoadResString(IDS_FDPROXIMA)
  Command1.Caption = _
   LoadResString(IDS_FDCANCEL)
  
  ' Strings j pesquisadas
  For i = 1 To Ocorrncias
    cboOcorrncia.AddItem Texto(i).Valor
  Next
  JCarregada = False
End Sub

' Descarrega
Private Sub Form_Unload(Cancel As Integer)
  #If Win32 Then
    Dim temp As Long
    temp = SetWindowPos(hWnd, HWND_NOTOPMOST, _
     0&, 0&, 0&, 0&, FLAGS)
  #Else
    SetWindowPos hWnd, HWND_NOTOPMOST, _
     0, 0, 0, 0, FLAGS
  #End If
  cboOcorrncia.Clear
  cboDireo.Clear
  cboCritrio.Clear
End Sub

' Seta objeto da classe Edit
Public Property Set Object(Parm As Object)
  Set Ob = Parm
End Property

' Efetua parsing
Private Function PegaPalavra _
 (Optional Frase As Variant, _
 Optional Separador As Variant) _
 As String
  Dim i As Integer
  Dim Palavra As String
  Static sFrase As String
  Static Sep As String
  
  ' Inicializa parsing
  If Not IsMissing(Frase) Then
    sFrase = Frase
    Sep = IIf(Not IsMissing(Separador), _
     Separador, ",")
  End If
  
  ' Efetua parsing
  i = InStr(1, sFrase, Sep, 1)
  If i > 0 Then
    Palavra = Left(sFrase, i - 1)
    sFrase = Trim(Mid(sFrase, i + Len(Sep)))
  Else
    Palavra = sFrase
    sFrase = ""
  End If
  PegaPalavra = Palavra
End Function
