VERSION 4.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Demonstrao da Classe Import"
   ClientHeight    =   4590
   ClientLeft      =   1140
   ClientTop       =   1830
   ClientWidth     =   7875
   Height          =   5280
   Icon            =   "Form1.frx":0000
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4590
   ScaleWidth      =   7875
   ShowInTaskbar   =   0   'False
   Top             =   1200
   Width           =   7995
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   720
      Top             =   120
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      DefaultExt      =   "MDB"
      DialogTitle     =   "Selecionar Arquivo Access"
   End
   Begin VB.Image Image1 
      Height          =   480
      Left            =   120
      Picture         =   "Form1.frx":030A
      Top             =   120
      Visible         =   0   'False
      Width           =   480
   End
   Begin VB.Menu mnuArquivo 
      Caption         =   "&Arquivo"
      Begin VB.Menu mnuImportar 
         Caption         =   "&Importar..."
      End
      Begin VB.Menu mnuAnexar 
         Caption         =   "&Anexar..."
      End
      Begin VB.Menu mnuSeparador 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSair 
         Caption         =   "Sai&r"
      End
   End
   Begin VB.Menu mnuAjuda 
      Caption         =   "Aj&uda"
      Begin VB.Menu mnuSobre 
         Caption         =   "&Sobre a Demonstrao..."
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' Centraliza janela
Private Sub Form_Load()
  Left = (Screen.Width - Width) / 2
  Top = (Screen.Height - Height) / 2
End Sub

' Anexa tabela para um banco de dados
Private Sub mnuAnexar_Click()
  Dim Sel As New Selection
  Dim Ipt As New Import
  Dim Flags As Long
  Const cdOFNLongNames = &H200000
  
  ' Exibe dilogo de seleo de
  ' tabela fonte
  Sel.DialogTitle = "Selecionar Tabela " & _
   "Para Ser Anexada"
  Sel.AddItem "Arquivos Access         (*.Mdb)"
  Sel.AddItem "Arquivo dBase e FoxProx (*.Dbf)"
  Sel.ListIndex = 1
  Sel.ReadOnly = True
  Sel.Show
  If Sel.FileName = "" Then Exit Sub
  If Sel.Query <> "" Then
    Beep
    MsgBox "No  possvel anexar " & _
     "consultas SQL.", , "Anexar"
    Exit Sub
  End If
  
  ' Verifica se foi selecionada
  ' tabela no-nativa do Jet
  If Not Sel.Database Then
    frmConnect.Show 1
    If frmConnect.Tag = "" Then
      Unload frmConnect
      Exit Sub
    End If
    Ipt.Connect = frmConnect.Tag
    Ipt.DatabaseName = Sel.Path
    Ipt.Table = Sel.FileTitle
    Unload frmConnect
  Else
    Ipt.DatabaseName = Sel.FileName
    Ipt.Table = Sel.Table
  End If
  
  ' Exibe dilogo de seleo de
  ' banco de dados alvo
  #If Win32 Then
    Flags = cdlOFNCreatePrompt Or _
     cdlOFNHideReadOnly Or _
     cdlOFNExplorer Or _
     cdOFNLongNames
  #Else
    Flags = cdlOFNCreatePrompt Or _
     cdlOFNHideReadOnly
  #End If
  CommonDialog1.Flags = Flags
  CommonDialog1.ShowSave
  
  ' Verifica se arquivo existe e
  ' se  compatvel com o Microsoft Access
  If ArquivoExiste _
   (CommonDialog1.FileName) And _
   Not ArquivoCompatvel _
   (CommonDialog1.FileName) Then
    Beep
    MsgBox "Obrigatria a anexao para " & _
     "um arquivo compatvel com o " & _
     "Microsoft Access.", , "Anexar"
    Exit Sub
  End If
  
  ' Anexa
  Ipt.Attach CommonDialog1.FileName
End Sub

' Importa tabela para um banco de dados
Private Sub mnuImportar_Click()
  Dim Sel As New Selection
  Dim Ipt As New Import
  Dim Flags As Long
  Const cdOFNLongNames = &H200000
  
  ' Exibe dilogo de seleo de
  ' tabela fonte
  Sel.DialogTitle = "Selecionar Tabela " & _
   "Para Ser Importada"
  Sel.AddItem "Arquivos Access         (*.Mdb)"
  Sel.AddItem "Arquivo dBase e FoxProx (*.Dbf)"
  Sel.ListIndex = 1
  Sel.ReadOnly = True
  Sel.Show
  If Sel.FileName = "" Then Exit Sub
  If Sel.Query <> "" Then
    Beep
    MsgBox "No  possvel importar " & _
     "consultas SQL.", , "Importar"
    Exit Sub
  End If
  
  ' Verifica se foi selecionada
  ' tabela no-nativa do Jet
  If Not Sel.Database Then
    frmConnect.Show 1
    If frmConnect.Tag = "" Then
      Unload frmConnect
      Exit Sub
    End If
    Ipt.Connect = frmConnect.Tag
    Ipt.DatabaseName = Sel.Path
    Ipt.Table = Sel.FileTitle
    Unload frmConnect
  Else
    Ipt.DatabaseName = Sel.FileName
    Ipt.Table = Sel.Table
  End If
  
  ' Exibe dilogo de seleo de
  ' banco de dados alvo
  #If Win32 Then
    Flags = cdlOFNCreatePrompt Or _
     cdlOFNHideReadOnly Or _
     cdlOFNExplorer Or _
     cdOFNLongNames
  #Else
    Flags = cdlOFNCreatePrompt Or _
     cdlOFNHideReadOnly
  #End If
  CommonDialog1.Flags = Flags
  CommonDialog1.ShowSave
  
  ' Verifica se arquivo existe e
  ' se  compatvel com o Microsoft Access
  If ArquivoExiste _
   (CommonDialog1.FileName) And _
   Not ArquivoCompatvel _
   (CommonDialog1.FileName) Then
    Beep
    MsgBox "Obrigatria a importao para " & _
     "um arquivo compatvel com o " & _
     "Microsoft Access.", , "Importar"
    Exit Sub
  End If
  
  ' Importa
  If MsgBox("Importar somente estrutura?", _
   vbYesNo, "Importar") = vbYes Then
    Ipt.ImportData = False
  End If
  On Error GoTo ImportaErro
  Screen.MousePointer = vbHourglass
  Ipt.Append CommonDialog1.FileName
  Screen.MousePointer = vbArrow
  MsgBox "Importao efetuada com sucesso.", , _
   "Importar"
  Exit Sub

ImportaErro:
  Beep
  Screen.MousePointer = vbArrow
  MsgBox "Erro importando tabela.", , _
   "Importar"
  Exit Sub
End Sub

' Sai
Private Sub mnuSair_Click()
 End
End Sub

' Exibe dilogo de ajuda sobre
Private Sub mnuSobre_Click()
  Dim Sobre As New About
  Sobre.Caption = "Sobre a Classe Import"
  Sobre.App = "Visual Basic 4 Know-How"
  Sobre.Copyright = "Copyright  1996 " & _
   "by M. Gutierrez" & Chr(13) & _
   "Todos os direitos reservados."
  Sobre.Icon = Image1
  Sobre.Show
End Sub

' Verifica se arquivo existe
Private Function ArquivoExiste _
 (Arquivo As String) As Boolean
  Dim handle As Integer
  On Error Resume Next
  handle = FreeFile
  Open Arquivo For Input Shared As handle
  ArquivoExiste = IIf(Err.Number = 53, False, True)
  Close #handle
  Err = 0
End Function

' Verifica se arquivo  compatvel
' com o Microsoft Access
Private Function ArquivoCompatvel _
 (Arquivo As String) As Boolean
  Dim DB As Database
  On Error GoTo ArquivoNoCompatvel
  Set DB = Workspaces(0).OpenDatabase _
   (Arquivo)
  DB.Close
  ArquivoCompatvel = True
  Exit Function

ArquivoNoCompatvel:
  ArquivoCompatvel = False
  Exit Function
End Function
