VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Import"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
'
' Sistema:    AxcelLib
' Classe:     Import
'
' Criado:     01 Mar 1996
' Atualizado:
'
' Copyright  1996 by Marco Antnio Gutierrez
' Copyright  1996 by Axcel Books do Brasil
' Editora Ltda
'

Option Explicit

' Propriedades do objeto
Dim Conexo As String
Dim BancoDeDados As String
Dim Tabela As String
Dim ImportaDados As Boolean

' Construtor
Private Sub Class_Initialize()
  Conexo = ";"
  ImportaDados = True
End Sub

' Destrutor
Private Sub Class_Terminate()
  BancoDeDados = ""
  Tabela = ""
End Sub

' Retorna informao de conexo
Public Property Get Connect() As String
  Connect = Conexo
End Property

' Especifica informao de conexo
Public Property Let Connect _
 (Informao As String)

  ' Valida parmetro
  If Not ConnectVlida(Informao) Then
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_IPTCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
    Exit Property
  End If
  
  ' Atribui propriedade
  Conexo = Informao
End Property

' Retorna nome do banco de dados
Public Property Get DatabaseName() _
 As String
  DatabaseName = BancoDeDados
End Property

' Espefica banco de dados para importao
Public Property Let DatabaseName _
 (Banco As String)

  ' Valida parmetro
  If Not ArquivoExiste(Banco) And _
   Not CaminhoExiste(Banco) Then
    Err.Clear
    Err.Raise vbObjectError + IDS_IPTNODB, _
     LoadResString(IDS_IPTCLASSE), _
     LoadResString(IDS_IPTNODB)
    Exit Property
  End If
  
  ' Atribui propriedade
  BancoDeDados = Banco
End Property

' Retorna informao sobre importao
Public Property Get ImportData() _
 As Boolean
  ImportData = ImportaDados
End Property

' Especifica tipo de importao
Public Property Let ImportData _
 (Tipo As Boolean)
  ImportaDados = Tipo
End Property

' Retorna tabela a ser importada
Public Property Get Table() As String
  Table = Tabela
End Property

' Especifica tabela a ser importada
Public Property Let Table(Tbl As String)
  Dim i As Integer
  i = InStr(Tbl, ".")
  If i > 0 Then
    Tabela = Left(Tbl, i - 1)
  Else
    Tabela = Tbl
  End If
End Property

' Importa a tabela
Public Sub Append(Banco As String)
  Dim Base As Database
  Dim i As Integer
  Dim VTab As New ViewTable
  Dim NTab As New NewTable
  Dim SQL As String
  
  ' Valida mtodo
  If BancoDeDados = "" Or _
   Tabela = "" Then GoTo MtodoInvlido
    
  ' Conecta  fonte externa
  On Error GoTo FonteIncompatvel
  VTab.Connect = Conexo
  VTab.DatabaseName = BancoDeDados
  VTab.Table = Tabela
  VTab.Refresh
  
  ' Cria a estrutura da tabela
  NTab.DatabaseName = Banco
  NTab.Table = Tabela
  For i = 0 To VTab.FieldCount - 1
    NTab.ThisPoint = i
    NTab.FieldName = VTab.FieldName(i)
    NTab.FieldType = VTab.FieldType(i)
    NTab.FieldSize = VTab.FieldSize(i)
  Next
  NTab.Update
  For i = 0 To VTab.IndexCount - 1
    NTab.Index = VTab.IndexName(i)
    NTab.IndexKey = VTab.IndexKey(i)
    NTab.IndexPrimary = VTab.IndexPrimary(i)
    NTab.IndexUnique = VTab.IndexUnique(i)
    NTab.Update
  Next

  ' Importa dados, se for o caso
  If ImportaDados Then
    On Error GoTo ImportaErro
    SQL = "INSERT INTO [" & _
     Tabela & "] IN '" & _
     Banco & "' SELECT [" & _
     Tabela & "].* FROM [" & _
     Tabela & "]"
    Set Base = VTab.Database
    Base.Execute SQL
  End If
  Exit Sub
  
' Execuo invlida
MtodoInvlido:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTPROPNOTSET, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTPROPNOTSET)
  Exit Sub

' Banco de dados incompatvel
AlvoIncompatvel:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTDBDSTNOCOMP, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTDBDSTNOCOMP)
  Exit Sub
FonteIncompatvel:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTDBORGNOCOMP, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTDBORGNOCOMP)
  Exit Sub

' Erro na importao dos dados
ImportaErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTIMPORTERRO, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTIMPORTERRO)
  Exit Sub
End Sub

' Anexa a tabela
Public Sub Attach(Banco As String)
  Dim Base As Database
  Dim Opes As Integer
  Dim Anexada As TableDef

  ' Valida mtodo
  If BancoDeDados = "" Or _
   Tabela = "" Then GoTo MtodoInvlido
  
  ' Cria banco de dados, se inexistente
  On Error GoTo AlvoIncompatvel
  If Not ArquivoExiste(Banco) Then
    #If Win32 Then
      Opes = dbVersion30
    #Else
      Opes = dbVersion20
    #End If
    Set Base = Workspaces(0). _
     CreateDatabase(Banco, dbLangGeneral, _
     Opes)
  
  ' Abre banco de dados
  Else
    Set Base = Workspaces(0). _
     OpenDatabase(Banco)
  End If
  
  ' Anexa a fonte externa
  On Error GoTo FonteIncompatvel
  Conexo = Conexo & "DATABASE=" & _
   BancoDeDados & ";"
  Set Anexada = Base.CreateTableDef(Tabela)
  Anexada.Connect = Conexo
  Anexada.SourceTableName = Tabela
  Base.TableDefs.Append Anexada
  Exit Sub

' Execuo invlida
MtodoInvlido:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTPROPNOTSET, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTPROPNOTSET)
  Exit Sub

' Banco de dados incompatvel
AlvoIncompatvel:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTDBDSTNOCOMP, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTDBDSTNOCOMP)
  Exit Sub
FonteIncompatvel:
  Err.Clear
  Err.Raise vbObjectError + IDS_IPTDBORGNOCOMP, _
   LoadResString(IDS_IPTCLASSE), _
   LoadResString(IDS_IPTDBORGNOCOMP)
  Exit Sub
End Sub

' Verifica se arquivo existe
Private Function ArquivoExiste _
 (Arquivo As String) As Boolean
  Dim handle As Integer
  On Error Resume Next
  handle = FreeFile
  Open Arquivo For Input Shared As handle
  ArquivoExiste = IIf(Err.Number = 53, False, True)
  Close #handle
  Err = 0
End Function

' Verifica se path existe
Private Function CaminhoExiste _
 (Path As String) As Boolean
  Dim CurPath As String
  On Error GoTo CaminhoNoExiste
  CurPath = CurDir
  ChDir Path
  ChDir CurPath
  CaminhoExiste = True
  Exit Function
CaminhoNoExiste:
  CaminhoExiste = False
  Exit Function
End Function

' Valida string de conexo
Private Function ConnectVlida _
 (Informao As String) As Boolean
  Select Case Informao
  Case "dBASE III;", "dBASE IV;", _
       "Paradox 3.x;", "Paradox 4.x;", _
       "Btrieve;", "FoxPro 2.0;", _
       "FoxPro 2.5;", "FoxPro 2.6;", _
       "Excel 3.0;", "Excel 4.0;", _
       "Excel 5.0;", "Text;", ";"
    ConnectVlida = True
  Case Else
    If InStr(Informao, "ODBC;") Then
      ConnectVlida = True
    Else
      ConnectVlida = False
    End If
  End Select
End Function
