VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "NewTable"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
'
' Sistema:    AxcelLib
' Classe:     NewTable
'
' Criado:     09 Jan 1996
' Atualizado:
'
' Copyright  1996 by Marco Antnio Gutierrez
' Copyright  1996 by Axcel Books do Brasil
' Editora Ltda
'

Option Explicit

' Estrutura do campo
Private Type Estrutura
  Name As String
  Size As Integer
  Type As Integer
End Type

' Propriedades do objeto
Dim CriaTabela As Boolean     ' CreateMode
Dim BancoDeDados As String    ' DatabaseName
Dim QtCampos As Integer       ' FieldCount
Dim ndice As String          ' Index
Dim ChaveDendice As String   ' IndexKey
Dim ndicePrimrio As Boolean ' IndexPrimary
Dim ndicenico As Boolean    ' IndexUnique
Dim Tabela As String          ' Table
Dim Ponteiro As Integer       ' ThisPoint

' Propriedades privadas
Dim Campos() As Estrutura
Dim Base As Database
Dim TabelaExiste As Boolean
Dim ndiceExiste As Boolean
Dim Removerndice As Boolean

' Atribui valores default
Private Sub Class_Initialize()
  CriaTabela = True
  QtCampos = 1
  Ponteiro = 0
  ReDim Preserve Campos(0 To Ponteiro) _
   As Estrutura
  Campos(0).Name = LoadResString _
   (IDS_NTDEFAULT) & "0"
  Campos(0).Size = 10
  Campos(0).Type = dbText
End Sub

' Retorna criao/edio de tabela
Public Property Get CreateMode() As Boolean
  CreateMode = CriaTabela
End Property

' Atribui criao/edio de tabela
Public Property Let CreateMode _
 (Cria As Boolean)
  CriaTabela = Cria
End Property

' Retorna nome do banco de dados
Public Property Get DatabaseName() As String
  DatabaseName = BancoDeDados
End Property

' Atribui nome do banco de dados
Public Property Let DatabaseName _
 (Banco As String)
  BancoDeDados = Banco
  TabelaExiste = False
  ndiceExiste = False
  Removerndice = False
  
  ' Verifica compatibilidade do arquivo
  If ArquivoExiste(Banco) Then
    On Error GoTo NoCompatvel
    Set Base = Workspaces(0).OpenDatabase(Banco)
  Else
    Set Base = Nothing
  End If
  Exit Property
  
' Arquivo no compatvel com MS-Access
NoCompatvel:
  Err.Clear
  Err.Raise vbObjectError + IDS_NTNAOCOMPATIVEL, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTNAOCOMPATIVEL)
  Exit Property
End Property

' Retorna quantidade de campos disponveis
Public Property Get FieldCount() As Integer
  FieldCount = QtCampos
End Property

' Retorna nome do campo
Public Property Get FieldName() As String
  FieldName = Campos(Ponteiro).Name
End Property

' Atribui nome do campos
Public Property Let FieldName(Nome As String)
  Campos(Ponteiro).Name = Nome
End Property

' Retorna tamanho do campo
Public Property Get FieldSize() As Integer
  FieldSize = Campos(Ponteiro).Size
End Property

' Atribui tamanho do campo
Public Property Let FieldSize _
 (Tamanho As Integer)
  
  ' Valida propriedade
  If Tamanho < 0 Or _
   Tamanho > 255 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_NTCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
  Else
  
    ' Atribui propriedade
    Campos(Ponteiro).Size = Tamanho
  End If
End Property

' Retorna tipo do campo
Public Property Get FieldType() As Integer
  FieldType = Campos(Ponteiro).Size
End Property

' Atribui tipo do campo
Public Property Let FieldType(Tipo As Integer)
  
  ' Valida propriedade
  If Tipo < dbBoolean Or _
   Tipo > dbMemo Then
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_NTCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
  Else
    
    ' Atribui propriedade
    Campos(Ponteiro).Type = Tipo
  End If
End Property

' Retorna nome do ndice
Public Property Get Index() As String
  Index = ndice
End Property

' Atribui nome do ndice
Public Property Let Index(Nome As String)
  Dim Tbl As TableDef
  Dim i As Integer
  ndice = Nome
  Removerndice = False
  
  ' Verifica se ndice existe
  If Not (Base Is Nothing) And _
   TabelaExiste Then
    Set Tbl = Base.TableDefs(Tabela)
    For i = 0 To Tbl.Indexes.Count - 1
      If Tbl.Indexes(i).Name = Nome Then
        ndiceExiste = True
        Exit For
      Else
        ndiceExiste = False
      End If
    Next
    
    ' Preenche dados do ndice
    If ndiceExiste Then
      ChaveDendice = ""
      For i = 0 To Tbl.Indexes(Nome). _
       Fields.Count - 1
        ChaveDendice = ChaveDendice & _
         ", " & Tbl.Indexes(Nome). _
         Fields(i).Name
      Next
      ChaveDendice = Mid(ChaveDendice, 3)
      ndicePrimrio = _
       Tbl.Indexes(Nome).Primary
      ndicenico = _
       Tbl.Indexes(Nome).Unique
    End If
  End If
End Property

' Retorna chave de ndice
Public Property Get IndexKey() As String
  IndexKey = ChaveDendice
End Property

' Atribui chave de ndice
Public Property Let IndexKey(Chave As String)
  ChaveDendice = Chave
End Property

' Retorna ndice primrio
Public Property Get IndexPrimary() As Boolean
  IndexPrimary = ndicePrimrio
End Property

' Atribui ndice primrio
Public Property Let IndexPrimary _
 (Primrio As Boolean)
  ndicePrimrio = Primrio
End Property

' Retorna ndice nico
Public Property Get IndexUnique() As Boolean
  IndexUnique = ndicenico
End Property

' Atribui ndice nico
Public Property Let IndexUnique _
 (nico As Boolean)
  ndicenico = nico
End Property

' Retorna nome da tabela
Public Property Get Table() As String
  Table = Tabela
End Property

' Atribui nome da tabela
Public Property Let Table(Nome As String)
  Dim i As Integer
  Tabela = Nome
  
  ' Verifica se tabela existe
  If Not (Base Is Nothing) Then
    For i = 0 To Base.TableDefs.Count - 1
      If Base.TableDefs(i).Name = Nome Then
        TabelaExiste = True
        Exit For
      Else
        TabelaExiste = False
      End If
    Next
    
    ' Preenche lista de campos
    If TabelaExiste Then
      QtCampos = Base.TableDefs(Nome). _
       Fields.Count
      ReDim Campos(0 To QtCampos - 1) _
       As Estrutura
      For i = 0 To UBound(Campos)
        Campos(i).Name = _
         Base.TableDefs(Nome).Fields(i).Name
        Campos(i).Size = _
         Base.TableDefs(Nome).Fields(i).Size
        Campos(i).Type = _
         Base.TableDefs(Nome).Fields(i).Type
      Next
    End If
  End If
End Property

' Retorna ponteiro para campos
Public Property Get ThisPoint() As Integer
  ThisPoint = Ponteiro
End Property

' Atribui ponteiro para campo
Public Property Let ThisPoint _
 (NovoPonteiro As Integer)

  ' Valida propriedade
  If NovoPonteiro < 0 Or _
   NovoPonteiro > QtCampos Then
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_NTCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
    Exit Property
  End If
  
  ' Atribui ponteiro
  Ponteiro = NovoPonteiro
  If Ponteiro = QtCampos Then
  
    ' Cria um novo campo
    QtCampos = QtCampos + 1
    ReDim Preserve Campos(0 To Ponteiro) _
     As Estrutura
    Campos(Ponteiro).Name = _
     LoadResString(IDS_NTDEFAULT) & _
     Trim(Str(Ponteiro))
    Campos(Ponteiro).Size = 10
    Campos(Ponteiro).Type = dbText
  End If
End Property

' Remove um campo ou um ndice
Public Sub Delete _
 (Optional Removendice As Variant)
  Dim i As Integer

  ' Remove um campo
  If IsMissing(Removendice) Then
    For i = Ponteiro To QtCampos - 2
      Campos(i).Name = Campos(i + 1).Name
      Campos(i).Size = Campos(i + 1).Size
      Campos(i).Type = Campos(i + 1).Type
    Next
    QtCampos = QtCampos - 1
    Ponteiro = IIf(Ponteiro = 0, 0, _
     Ponteiro - 1)
    ReDim Preserve Campos _
     (0 To QtCampos - 1) As Estrutura
  Else
  
    ' Remove um ndice
    If ndiceExiste Then
      Removerndice = True
    Else
    
      ' Mtodo invlido
      Err.Clear
      Err.Raise vbObjectError + _
       IDS_NTINDICEEXISTE, _
       LoadResString(IDS_NTCLASSE), _
       LoadResString(IDS_NTINDICEEXISTE)
      Exit Sub
    End If
  End If
End Sub

' Cria/atualiza tabela/ndice
Public Sub Update()
  Dim IdxCampos() As String
  Dim Campo As String
  Dim i As Integer, Opes As Integer, _
   j As Integer
  Dim AlteraTabela As Boolean
  Dim Tbl As TableDef
  Dim FldCampo As Field
  Dim Idx As Index

  ' Valida propriedade CreateMode
  If CriaTabela Then
    If TabelaExiste And ndiceExiste _
     Then GoTo CriaErro
    If TabelaExiste And ndice = "" _
     Then GoTo CriaErro
    If Tabela = "" And ndice = "" _
     Then GoTo CriaErro
  Else
    If Not TabelaExiste And _
     Not ndiceExiste Then GoTo EditaErro
  End If
  
  ' Valida propriedades DatabaseName e Table
  If BancoDeDados = "" Or Tabela = "" _
   Then GoTo FaltaPropriedade
  
  ' Valida ndice
  If ndice <> "" And ChaveDendice <> "" Then
  
    ' Quebra lista de campos na chave
    Campo = PegaPalavra(ChaveDendice)
    Do
      ReDim Preserve IdxCampos(0 To i) As String
      IdxCampos(i) = Campo
      Campo = PegaPalavra()
      i = i + 1
    Loop Until Campo = ""
    
    ' Verifica campo existente
    For i = 0 To UBound(IdxCampos)
      If LocalizaItem(Campos, IdxCampos(i)) _
       = -1 Then GoTo ndiceInvlido
    Next
  End If
  
  ' Cria banco de dados
  If Base Is Nothing Then
    #If Win16 Then
      Opes = dbVersion20
    #Else
      Opes = dbVersion30
    #End If
    On Error GoTo CriaBancoErro
    Set Base = Workspaces(0). _
     CreateDatabase(BancoDeDados, _
     dbLangGeneral, Opes)
  End If
  
  ' Verifica se  necessrio alterar tabela
  If TabelaExiste Then
    Set Tbl = Base.TableDefs(Tabela)
    For i = 0 To Tbl.Fields.Count - 1
      j = LocalizaItem(Campos, _
       Tbl.Fields(i).Name)
      If j = -1 Then
        AlteraTabela = True
        Exit For
      End If
      If Campos(j).Type <> _
       Tbl.Fields(i).Type Then
        AlteraTabela = True
        Exit For
      End If
      If Campos(j).Type = dbText _
       And Campos(j).Size <> _
       Tbl.Fields(i).Size Then
        AlteraTabela = True
        Exit For
      End If
    Next
    If Tbl.Fields.Count <> QtCampos Then _
     AlteraTabela = True
  Else
    AlteraTabela = True
  End If
  
  ' Recria tabela, se for o caso
  If AlteraTabela Then
    On Error GoTo CriaTabelaErro
    If TabelaExiste Then _
     Base.TableDefs.Delete Tabela
    Set Tbl = Base.CreateTableDef(Tabela)
   
    ' Anexa campos
    For i = 0 To UBound(Campos)
      Set FldCampo = Tbl.CreateField _
       (Campos(i).Name, Campos(i).Type)
      If Campos(i).Type = dbText Then _
       FldCampo.Size = Campos(i).Size
      Tbl.Fields.Append FldCampo
    Next
    Base.TableDefs.Append Tbl
  End If
  If ndice <> "" Then
  
    ' Recria ndice
    On Error GoTo CriandiceErro
    If ndiceExiste Then _
     Tbl.Indexes.Delete ndice
    
    ' Anexa campos
    Set Idx = Tbl.CreateIndex(ndice)
    Idx.Primary = ndicePrimrio
    If Not ndicePrimrio Then _
     Idx.Unique = ndicenico
    For i = 0 To UBound(IdxCampos)
      Set FldCampo = Idx.CreateField _
       (IdxCampos(i))
      Idx.Fields.Append FldCampo
    Next
    Tbl.Indexes.Append Idx
    ndiceExiste = True
  End If
  TabelaExiste = True
  Exit Sub

' CreateMode invlido
CriaErro:
  Err.Clear
  Err.Raise vbObjectError + _
   IDS_NTTABELAEXISTE, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTTABELAEXISTE)
  Exit Sub
EditaErro:
  Err.Clear
  Err.Raise vbObjectError + _
   IDS_NTTABELANAOEXISTE, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTTABELANAOEXISTE)
  Exit Sub

' Falta propriedade
FaltaPropriedade:
  Err.Clear
  Err.Raise vbObjectError + IDS_NTFALTAPROP, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTFALTAPROP)
  Exit Sub

' Erro no ndice
ndiceInvlido:
  Err.Clear
  Err.Raise vbObjectError + _
   IDS_NTINDICEINVALIDO, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTINDICEINVALIDO)
  Exit Sub

' Erro criando banco de dados
CriaBancoErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_NTERROBANCO, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTERROBANCO) & _
   BancoDeDados
  Exit Sub

' Erro criando tabela
CriaTabelaErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_NTERROTABELA, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTERROTABELA) & _
   Tabela
  Exit Sub

' Erro criando ndice
CriandiceErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_NTERROINDICE, _
   LoadResString(IDS_NTCLASSE), _
   LoadResString(IDS_NTERROINDICE) & _
   ndice
End Sub

' Verifica se arquivo existe
Private Function ArquivoExiste _
 (Arquivo As String) As Boolean
  Dim handle As Integer
  On Error Resume Next
  handle = FreeFile
  Open Arquivo For Input Shared As handle
  ArquivoExiste = IIf(Err.Number = 53, False, True)
  Close #handle
  Err = 0
End Function

' Efetua parsing
Private Function PegaPalavra _
 (Optional Frase As Variant, _
 Optional Separador As Variant) _
 As String
  Dim i As Integer
  Dim Palavra As String
  Static sFrase As String
  Static Sep As String
  
  ' Inicializa parsing
  If Not IsMissing(Frase) Then
    sFrase = Frase
    Sep = IIf(Not IsMissing(Separador), _
     Separador, ",")
  End If
  
  ' Efetua parsing
  i = InStr(1, sFrase, Sep, 1)
  If i > 0 Then
    Palavra = Left(sFrase, i - 1)
    sFrase = Trim(Mid(sFrase, i + Len(Sep)))
  Else
    Palavra = sFrase
    sFrase = ""
  End If
  PegaPalavra = Palavra
End Function

' Localiza um item dentro de um vetor
Private Function LocalizaItem _
 (Vetor() As Estrutura, Item As String) _
 As Integer
  Dim i As Integer
  Dim ItemLocalizado As Boolean
  For i = LBound(Vetor) To UBound(Vetor)
    If Vetor(i).Name = Item Then
      ItemLocalizado = True
      Exit For
    End If
  Next
  If ItemLocalizado Then
    LocalizaItem = i
  Else
    LocalizaItem = -1
  End If
End Function
