VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ViewTable"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
'
' Sistema:    AxcelLib
' Classe:     ViewTable
'
' Criado:     29 Fev 1996
' Atualizado:
'
' Copyright  1996 by Marco Antnio Gutierrez
' Copyright  1996 by Axcel Books do Brasil
' Editora Ltda
'

Option Explicit

' Propriedades do objeto
Dim BancoDeDados As String  ' DatabaseName
Dim NomeDaTabela As String  ' Table
Dim Info As String          ' Connect

' Propriedades privadas
Dim Base As Database
Dim Tabela As TableDef

' Construtor
Private Sub Class_Initialize()
  Info = ";"
End Sub

' Destrutor
Private Sub Class_Terminate()
  Set Tabela = Nothing
  Set Base = Nothing
  BancoDeDados = ""
  NomeDaTabela = ""
  Info = ""
End Sub

' Retorna informao de conexo
Public Property Get Connect() As String
  Connect = Info
End Property

' Determina tipo de conexo
Public Property Let Connect(Informao As String)

  ' Valida propriedade
  If ConnectVlida(Informao) Then
    Info = Informao
  Else
  
    ' Propriedade invlida
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
  End If
End Property

' Retorna o objeto database
Public Property Get Database() As Object
  
  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
    
  ' Retorna
  Set Database = Base
End Property

' Retorna nome do arquivo de dados
Public Property Get DatabaseName() As String
  DatabaseName = BancoDeDados
End Property

' Determina arquivo de dados
Public Property Let DatabaseName(Banco As String)

  ' Valida propriedade
  If Not ArquivoExiste(Banco) And _
   Not CaminhoExiste(Banco) Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNODB, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNODB)
    Exit Property
  End If
  
  ' Atribui propriedade
  BancoDeDados = Banco
End Property

' Retorna objeto Field
Public Property Get Field _
 (ndice As Integer) As Object

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Fields.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  Set Field = Tabela.Fields(ndice)
End Property

' Retorna quantidade de campos
Public Property Get FieldCount() As Integer
  
  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Retorna
  FieldCount = Tabela.Fields.Count
End Property

' Coleo de propriedades Name dos campos
Public Property Get FieldName _
 (ndice As Integer) As String

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Fields.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  FieldName = Tabela.Fields(ndice).Name
End Property

' Coleo de tamanhos de campo
Public Property Get FieldSize _
 (ndice As Integer) As Integer

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Fields.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  FieldSize = Tabela.Fields(ndice).Size
End Property

' Coleo de tipos de campo
Public Property Get FieldType _
 (ndice As Integer) As Integer

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Fields.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  FieldType = Tabela.Fields(ndice).Type
End Property

' Retorna objeto Index
Public Property Get Index _
 (ndice As Integer) As Object
 
  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Indexes.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  Set Index = Tabela.Indexes(ndice)
End Property

' Retorna a quantidade de ndices de uma tabela
Public Property Get IndexCount() As Integer

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Retorna
  IndexCount = Tabela.Indexes.Count
End Property

' Coleo de ndices de uma tabela
Public Property Get IndexName _
 (ndice As Integer) As String
  
  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Indexes.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  IndexName = Tabela.Indexes(ndice).Name
End Property

' Coleo de expresses de ndice
Public Property Get IndexKey _
 (ndice As Integer) As String
  Dim ChaveDendice As String
  Dim i As Integer

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Indexes.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Compe chave de ndice
  For i = 0 To Tabela.Indexes _
   (ndice).Fields.Count - 1
    ChaveDendice = ChaveDendice & _
     ", " & Tabela.Indexes(ndice). _
     Fields(i).Name
  Next
  IndexKey = Mid(ChaveDendice, 3)
End Property

' Coleo de ndices primrios
Public Property Get IndexPrimary _
 (ndice As Integer) As Boolean

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Indexes.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  IndexPrimary = Tabela.Indexes(ndice).Primary
End Property

' Coleo de ndices nicos
Public Property Get IndexUnique _
 (ndice As Integer) As Boolean

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
  
  ' Valida argumento
  If ndice < 0 Or _
   ndice > Tabela.Indexes.Count - 1 Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBSUBSCRIPT, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBSUBSCRIPT)
    Exit Property
  End If
  
  ' Retorna
  IndexUnique = Tabela.Indexes(ndice).Unique
End Property

' Retorna a fonte de dados
Public Property Get Table() As String
  Table = NomeDaTabela
End Property

' Determina fonte de dados
Public Property Let Table(Tabela As String)
  Dim i As Integer
  i = InStr(Tabela, ".")
  If i > 0 Then
    NomeDaTabela = Left(Tabela, i - 1)
  Else
    NomeDaTabela = Tabela
  End If
End Property

' Retorna um objeto TableDef
Public Property Get TableDef() As Object
  
  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Property
  End If
  
  ' Atualiza propriedades
  If Base Is Nothing Or _
   Tabela Is Nothing Then _
   Refresh
    
  ' Retorna
  Set TableDef = Tabela
End Property

' Atualiza propriedades do objeto
Public Sub Refresh()

  ' Valida utilizao
  If BancoDeDados = "" Or _
   NomeDaTabela = "" Then
    Err.Clear
    Err.Raise vbObjectError + IDS_VTBNOTSET, _
     LoadResString(IDS_VTBCLASSE), _
     LoadResString(IDS_VTBNOTSET)
    Exit Sub
  End If
  
  ' Atualiza propriedades
  On Error GoTo RefreshErro
  Set Base = Workspaces(0).OpenDatabase _
   (BancoDeDados, False, True, Info)
  Set Tabela = Base.TableDefs(NomeDaTabela)
  Exit Sub

RefreshErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_VTBNOCONNECT, _
   LoadResString(IDS_VTBCLASSE), _
   LoadResString(IDS_VTBNOCONNECT)
  Exit Sub
End Sub

' Verifica se arquivo existe
Private Function ArquivoExiste _
 (Arquivo As String) As Boolean
  Dim handle As Integer
  On Error Resume Next
  handle = FreeFile
  Open Arquivo For Input Shared As handle
  ArquivoExiste = IIf(Err.Number = 53, False, True)
  Close #handle
  Err = 0
End Function

' Verifica se path existe
Private Function CaminhoExiste _
 (Path As String) As Boolean
  Dim CurPath As String
  On Error GoTo CaminhoNoExiste
  CurPath = CurDir
  ChDir Path
  ChDir CurPath
  CaminhoExiste = True
  Exit Function
CaminhoNoExiste:
  CaminhoExiste = False
  Exit Function
End Function

' Valida string de conexo
Private Function ConnectVlida _
 (Informao As String) As Boolean
  Select Case Informao
  Case "dBASE III;", "dBASE IV;", _
       "Paradox 3.x;", "Paradox 4.x;", _
       "Btrieve;", "FoxPro 2.0;", _
       "FoxPro 2.5;", "FoxPro 2.6;", _
       "Excel 3.0;", "Excel 4.0;", _
       "Excel 5.0;", "Text;", ";"
    ConnectVlida = True
  Case Else
    If InStr(Informao, "ODBC;") Then
      ConnectVlida = True
    Else
      ConnectVlida = False
    End If
  End Select
End Function

' Efetua parsing
Private Function PegaPalavra _
 (Optional Frase As Variant, _
 Optional Separador As Variant) _
 As String
  Dim i As Integer
  Dim Palavra As String
  Static sFrase As String
  Static Sep As String
  
  ' Inicializa parsing
  If Not IsMissing(Frase) Then
    sFrase = Frase
    Sep = IIf(Not IsMissing(Separador), _
     Separador, ",")
  End If
  
  ' Efetua parsing
  i = InStr(1, sFrase, Sep, 1)
  If i > 0 Then
    Palavra = Left(sFrase, i - 1)
    sFrase = Trim(Mid(sFrase, i + Len(Sep)))
  Else
    Palavra = sFrase
    sFrase = ""
  End If
  PegaPalavra = Palavra
End Function
