VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "About"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
'
' Sistema:    AxcelLib
' Classe:     About
'
' Criado:     02 Jan 1996
' Atualizado:
'
' Copyright  1996 by Marco Antnio Gutierrez
' Copyright  1996 by Axcel Books do Brasil
' Editora Ltda
'
Option Explicit

' Armazena propriedade ThisPoint
Private Ponteiro As Byte

' Valores da propriedade ThisPoint
Private Const AppFon As Byte = 0
Private Const CopyrightFon As Byte = 1
Private Const TextFon As Byte = 2
Private Const MAX_THISPOINT = 2

' Mtodo Show
Public Sub Show()
  frmAbout.Show 1
End Sub

' Retorna propriedade App
Public Property Get App() As String
  App = frmAbout.lblApp.Caption
End Property

' Atribui propriedade App
Public Property Let App(Parm As String)
  frmAbout.lblApp.Caption = Parm
End Property

' Retorna propriedade Caption
Public Property Get Caption() As String
  Caption = frmAbout.Caption
End Property

' Atribui propriedade Caption
Public Property Let Caption(Parm As String)
  frmAbout.Caption = Parm
End Property

' Retorna propriedade Copyright
Public Property Get Copyright() As String
  Copyright = frmAbout.lblCopyright.Caption
End Property

' Atribui propriedade Copyright
Public Property Let Copyright(Parm As String)
  frmAbout.lblCopyright.Caption = Parm
End Property

' Retorna propriedade FontName
Public Property Get FontName() As String
  Select Case Ponteiro
  Case AppFon
    FontName = frmAbout.lblApp.Font.Name
  Case CopyrightFon
    FontName = frmAbout.lblCopyright.Font.Name
  Case TextFon
    FontName = frmAbout.lblText.Font.Name
  End Select
End Property

' Atribui propriedade FontName
Public Property Let FontName(Parm As String)

  ' Valida fonte
  Dim i As Integer
  Dim FonteDisponvel As Boolean
  For i = 0 To Screen.FontCount - 1
    If Screen.Fonts(i) = Parm Then
      FonteDisponvel = True
      Exit For
    End If
  Next
  
  ' Propriedade invlida
  If Not FonteDisponvel Then
    Err.Clear
    Err.Raise vbObjectError + IDS_ABTERROFONTE, _
     LoadResString(IDS_ABTCLASSE), _
     LoadResString(IDS_ABTERROFONTE)
    Exit Property
  End If
  
  ' Atribui
  Select Case Ponteiro
  Case AppFon
    frmAbout.lblApp.Font.Name = Parm
  Case CopyrightFon
    frmAbout.lblCopyright.Font.Name = Parm
  Case TextFon
    frmAbout.lblText.Font.Name = Parm
  End Select
End Property

' Retorna propriedade FontSize
Public Property Get FontSize() As Integer
  Select Case Ponteiro
  Case AppFon
    FontSize = frmAbout.lblApp.Font.Size
  Case CopyrightFon
    FontSize = frmAbout.lblCopyright.Font.Size
  Case TextFon
    FontSize = frmAbout.lblText.Font.Size
  End Select
End Property

' Atribui propriedade FontSize
Public Property Let FontSize(Parm As Integer)
  On Error GoTo SizeErro
  Select Case Ponteiro
  Case AppFon
    frmAbout.lblApp.Font.Size = Parm
  Case CopyrightFon
    frmAbout.lblCopyright.Font.Size = Parm
  Case TextFon
    frmAbout.lblText.Font.Size = Parm
  End Select
  Exit Property
  
' Propriedade invlida
SizeErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_ABTERROFONTE, _
   LoadResString(IDS_ABTCLASSE), _
   LoadResString(IDS_ABTERROFONTE)
  Exit Property
End Property

' Atribui propriedade Icon
Public Property Let Icon(Parm As Object)
  On Error GoTo IconErro
  frmAbout.imgIcon.Picture = Parm.Picture
  Exit Property

' Propriedade invlida
IconErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_ERROCONTROLE, _
   LoadResString(IDS_ABTCLASSE), _
   LoadResString(IDS_ERROCONTROLE)
  Exit Property
End Property


' Retorna propriedade Text
Public Property Get Text() As String
  Text = frmAbout.lblText.Caption
End Property

' Atribui propriedade Text
Public Property Let Text(Parm As String)
  frmAbout.lblText.Caption = Parm
End Property
' Retorna propriedade ThisPoint
Public Property Get ThisPoint() As Byte
  ThisPoint = Ponteiro
End Property

' Atribui propriedade ThisPoint
Public Property Let ThisPoint(Parm As Byte)
  If Parm >= 0 And Parm <= MAX_THISPOINT Then
    Ponteiro = Parm
  Else
  
    ' Propriedade invlida
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_ABTCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
  End If
End Property

' Carrega janela de dilogo
Private Sub Class_Initialize()
  On Error GoTo InitErro
  Load frmAbout
  Exit Sub

' Erro na inicializao
InitErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_ERROCARGA, _
   LoadResString(IDS_ABTCLASSE), _
   LoadResString(IDS_ERROCARGA)
  Exit Sub
End Sub
